/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.io.ASocketCounter;
import com.wily.introscope.agent.trace.io.AddressHostNameHelper;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.introscope.agent.trace.io.SocketMap;
import com.wily.introscope.api.instrument.SocketCFT;
import com.wily.util.adt.ConcurrentHighPerformanceLRUHashMap;
import com.wily.util.adt.ConcurrentThreadLocalHashMap;
import com.wily.util.adt.ConcurrentWeakThreadLocalHashMap;
import com.wily.util.adt.ICappedMap;
import com.wily.util.adt.IConcurrentMapFactory15;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;
import java.net.AgentSocketInputStream;
import java.net.AgentSocketOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public abstract class SocketFormatterCache
extends ASocketCounter
implements ITracer {
    private static final IRegisteredBehavior kBehavior = SocketFormatterCache.initPoller();
    public static final ConcurrentWeakThreadLocalHashMap<Socket, SocketFormatMetricsCache> kSocketMetricCache = SocketFormatterCache.getWeakCache("SocketMetricCache");
    private static final ConcurrentHighPerformanceLRUHashMap<String, ConcurrentHighPerformanceLRUHashMap<Integer, SocketFormatMetricsCache>> kAddressMetricCache = SocketFormatterCache.getCappedCache("AddressMetricCache");
    private static final ConcurrentThreadLocalHashMap<Integer, SocketFormatMetricsCache> kServerAddressMetricCache = SocketFormatterCache.getCache("ServerAddressMetricCache");

    private static final <K, V> ConcurrentThreadLocalHashMap<K, V> getCache(String policyName) {
        try {
            IAgent agent = AgentShim.getAgent();
            IConcurrentMapFactory15 mapFactory = (IConcurrentMapFactory15)((Object)agent.IAgent_getConcurrentMapFactory());
            return mapFactory.getConcurrentHashMap(policyName);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return null;
        }
    }

    private static final <K, V> ConcurrentWeakThreadLocalHashMap<K, V> getWeakCache(String policyName) {
        try {
            IAgent agent = AgentShim.getAgent();
            IConcurrentMapFactory15 mapFactory = (IConcurrentMapFactory15)((Object)agent.IAgent_getConcurrentMapFactory());
            return mapFactory.getConcurrentWeakHashMap(policyName);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return null;
        }
    }

    private static final <K, V> ConcurrentHighPerformanceLRUHashMap<K, V> getCappedCache(String policyName) {
        try {
            IAgent agent = AgentShim.getAgent();
            IConcurrentMapFactory15 mapFactory = (IConcurrentMapFactory15)((Object)agent.IAgent_getConcurrentMapFactory());
            return mapFactory.getConcurrentCappedHashMap(policyName);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return null;
        }
    }

    private static final IRegisteredBehavior initPoller() {
        try {
            IAgent agent = AgentShim.getAgent();
            if (agent != null) {
                return agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new ConcurrentMetricPoller(agent), "TracedSocketMetricPoller", true, 7500L, false);
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
        return null;
    }

    public SocketFormatterCache(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected final IIntegerFluctuatingCounterDataAccumulator createDataAccumulator(InvocationData data) {
        return null;
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void allocateTracerAndCache(InvocationData data, Object invocationObject, Socket socket) {
        SocketFormatMetricsCache partialFormattedName;
        block12: {
            int port;
            block11: {
                if (!SocketMap.isRequired(socket, this.getAgent())) {
                    data.setSocketRequired(false);
                    return;
                }
                data.setSocketRequired(true);
                partialFormattedName = kSocketMetricCache.getWeak(socket);
                if (partialFormattedName != null) {
                    data.setPartialSocketFormattedName(partialFormattedName);
                    data.setHasSocketResource(partialFormattedName.getResourceName() != null);
                    this.doPostFlight(socket, partialFormattedName);
                    return;
                }
                boolean isClientConnection = SocketMap.isClientConnection(socket);
                String hostName = null;
                port = 0;
                ConcurrentHighPerformanceLRUHashMap<Integer, SocketFormatMetricsCache> map = null;
                if (isClientConnection) {
                    InetSocketAddress address = (InetSocketAddress)socket.getRemoteSocketAddress();
                    if (address == null) {
                        data.setSocketRequired(false);
                        data.setHasSocketResource(false);
                        return;
                    }
                    hostName = AddressHostNameHelper.getHostName(address);
                    map = kAddressMetricCache.get(hostName);
                    if (map != null) {
                        port = address.getPort();
                        partialFormattedName = map.get(port);
                    }
                } else {
                    port = socket.getLocalPort();
                    partialFormattedName = kServerAddressMetricCache.get(port);
                }
                if (partialFormattedName != null) {
                    data.setPartialSocketFormattedName(partialFormattedName);
                    data.setHasSocketResource(partialFormattedName.getResourceName() != null);
                    kSocketMetricCache.putWeak(socket, partialFormattedName);
                    this.doPostFlight(socket, partialFormattedName);
                    return;
                }
                String formattedName = this.quickFormat(data, this.getMetricPosition());
                if (formattedName == null) {
                    data.setSocketRequired(false);
                    data.setHasSocketResource(false);
                    return;
                }
                String resourceName = SocketMap.getResourceName(socket);
                data.setHasSocketResource(resourceName != null);
                partialFormattedName = (SocketFormatMetricsCache)data.getPartialSocketFormattedName();
                if (partialFormattedName == null) return;
                partialFormattedName.setResourceName(resourceName);
                partialFormattedName.setClientConnection(isClientConnection);
                kSocketMetricCache.putWeak(socket, partialFormattedName);
                if (!isClientConnection) break block11;
                if (map == null) {
                    map = SocketFormatterCache.getCappedCache("AddressMetricCacheL2");
                    map.put(port, partialFormattedName);
                    ConcurrentHighPerformanceLRUHashMap<Integer, SocketFormatMetricsCache> mapInMap = kAddressMetricCache.putIfAbsent(hostName, map);
                    if (mapInMap != null) {
                        mapInMap.put(port, partialFormattedName);
                    }
                    break block12;
                } else {
                    map.put(port, partialFormattedName);
                }
                break block12;
            }
            kServerAddressMetricCache.put(port, partialFormattedName);
        }
        this.doPostFlight(socket, partialFormattedName);
        this.completeMetricsAndAccumulators(partialFormattedName);
    }

    protected void completeMetricsAndAccumulators(SocketFormatMetricsCache partialFormattedName) {
    }

    private void doPostFlight(Socket socket, SocketFormatMetricsCache partialFormattedName) {
        if (SocketCFT.isDynamicSocketClassModificationEnabled()) {
            try {
                Method _postFlightOS = Class.forName("com.wily.net.AgentSocketOutputStream").getDeclaredMethod("postFlight", Socket.class, SocketFormatMetricsCache.class);
                _postFlightOS.invoke(null, socket, partialFormattedName);
                Method _postFlightIS = Class.forName("com.wily.net.AgentSocketInputStream").getDeclaredMethod("postFlight", Socket.class, SocketFormatMetricsCache.class);
                _postFlightIS.invoke(null, socket, partialFormattedName);
            }
            catch (Exception e) {
                System.out.println("[IntroscopeAgent.Agent] Error in Socket tracing postFlight: " + e);
            }
        } else {
            AgentSocketOutputStream.postFlight(socket, partialFormattedName);
            AgentSocketInputStream.postFlight(socket, partialFormattedName);
        }
    }

    private static final class ConcurrentMetricPoller
    implements ITimestampedRunnable {
        public static final String kName = "TracedSocketMetricPoller";
        private final IAgent fAgent;

        public ConcurrentMetricPoller(IAgent agent) {
            this.fAgent = agent;
        }

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            try {
                kAddressMetricCache.iterateThrougEntries(new ICappedMap.IOperateOnEntry(){

                    public void doOnEntry(Map.Entry entry1) {
                        ConcurrentHighPerformanceLRUHashMap map2 = (ConcurrentHighPerformanceLRUHashMap)entry1.getValue();
                        if (map2 != null) {
                            map2.iterateThrougEntries(new ICappedMap.IOperateOnEntry(){

                                public void doOnEntry(Map.Entry entry2) {
                                    SocketFormatMetricsCache cache = (SocketFormatMetricsCache)entry2.getValue();
                                    if (cache != null) {
                                        cache.pollConcurrentMetrics();
                                    }
                                }
                            });
                        }
                    }
                });
                Collection serverValues = kServerAddressMetricCache.values();
                if (serverValues == null) {
                    return;
                }
                Iterator i = serverValues.iterator();
                while (i.hasNext()) {
                    ((SocketFormatMetricsCache)i.next()).pollConcurrentMetrics();
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    if (this.fAgent != null) {
                        this.fAgent.IAgent_safeReportError("A problem occurred while reporting concurrent socket metrics", t);
                    }
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

