/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.net;

import com.wily.isengard.KIsengardConstants;
import com.wily.isengard.postofficehub.link.net.ASocketFactory;
import com.wily.isengard.postofficehub.link.net.ISSLSocketFactory;
import com.wily.isengard.postofficehub.link.net.SSLInitializationException;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.IndexedProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public abstract class ASSLSocketFactory
extends ASocketFactory
implements ISSLSocketFactory {
    private SSLContext fContext;
    private Boolean fValidateHostname;
    private String fServerId;
    private String[] fCipherSuites;
    private String[] fProtocols;
    private static final String fSSLStorePath = "introscope.ssl.storepath";
    private final int kDefaultSSLPort = 443;
    private Module feedbackModule = new Module("SSLSocketFactory");
    private final String[] kDefaultCipherSuites = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "SSL_ECDHE_RSA_WITH_AES_256_CBC"};
    private FIPSConfiguration fipsConfiguration;

    public ASSLSocketFactory(IModuleFeedbackChannel feedback) {
        super(feedback);
    }

    public ASSLSocketFactory(IndexedProperties properties, IModuleFeedbackChannel feedback) {
        super(properties, feedback);
        this.fServerId = properties.getProperty("client.current.serverId");
    }

    @Override
    public String[] getCipherSuites() {
        return this.fCipherSuites;
    }

    @Override
    public String[] getProtocols() {
        return this.fProtocols;
    }

    @Override
    public int getPort() {
        return 443;
    }

    @Override
    public SSLContext getSSLContext() throws SSLInitializationException {
        if (this.fContext == null) {
            try {
                this.fContext = this.createSSLContext(this.getProperties(), this.getFeedbackChannel());
            }
            catch (Exception e) {
                this.getFeedbackChannel().debug(this.feedbackModule, "Failed to create SSLContext", e);
                throw new SSLInitializationException("Failed to create SSLContext", e);
            }
        }
        return this.fContext;
    }

    @Override
    public boolean shouldValidateHostname() {
        if (this.fValidateHostname == null) {
            String key = this.fServerId == null ? "transport.tcp.tls.validateHostname" : "transport.tcp.tls.validateHostname." + this.fServerId;
            this.fValidateHostname = this.getProperties().getBooleanProperty(key, false);
        }
        return this.fValidateHostname;
    }

    private File getTrustStoreFile(String trustStorePath) throws FileNotFoundException {
        String sslStorePath;
        ExtendedFile trustStorePathFile = null;
        File trustStore = null;
        if (!ExtendedFile.isAbsolutePath(trustStorePath) && (sslStorePath = this.getProperties().getIndexedProperty(fSSLStorePath, 0)) != null) {
            trustStorePathFile = new ExtendedFile(new File(sslStorePath), trustStorePath);
        }
        if (!(trustStore = trustStorePathFile == null || !trustStorePathFile.exists() ? new File(trustStorePath) : new File(trustStorePathFile.getAbsolutePath())).exists()) {
            throw new FileNotFoundException("truststore file does not exist: " + trustStore.getAbsolutePath());
        }
        return trustStore;
    }

    private KeyStore getTrustStore(String trustStorePath, String trustPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore;
        File trustStoreFile = this.getTrustStoreFile(trustStorePath);
        InputStream is = null;
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] password = trustPassword.toCharArray();
            is = new BufferedInputStream(new FileInputStream(trustStoreFile));
            trustStore.load(is, password);
            keyStore = trustStore;
        }
        catch (Throwable throwable) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
        return keyStore;
    }

    protected TrustManager[] createTrustManagers(KeyStore trustStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustFactory = null;
        if (this.fipsConfiguration.isValid()) {
            try {
                trustFactory = TrustManagerFactory.getInstance(this.fipsConfiguration.TRUST_MANAGER_FACTORY_ALGORITHM, this.fipsConfiguration.TRUST_MANAGER_FACTORY_PROVIDER);
            }
            catch (Exception e) {
                this.getFeedbackChannel().error(this.feedbackModule, "Failed to create FIPS TrustManagerFactory: " + e.getMessage());
                this.getFeedbackChannel().debug(this.feedbackModule, "Failed to create FIPS TrustManagerFactory", e);
                return null;
            }
        }
        try {
            if (trustFactory == null) {
                trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            }
            trustFactory.init(trustStore);
        }
        catch (Exception e) {
            this.getFeedbackChannel().error(this.feedbackModule, "Failed to initialize TrustManagerFactory: " + e.getMessage());
            this.getFeedbackChannel().debug(this.feedbackModule, "Failed to initialize TrustManagerFactory", e);
            return null;
        }
        return trustFactory.getTrustManagers();
    }

    protected TrustManager[] createDefaultTrustManagers() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        return trustAllCerts;
    }

    private File getKeyStoreFile(String keyStorePath) throws FileNotFoundException {
        String sslStorePath;
        ExtendedFile keyStorePathFile = null;
        File keyStore = null;
        if (!ExtendedFile.isAbsolutePath(keyStorePath) && (sslStorePath = this.getProperties().getIndexedProperty(fSSLStorePath, 0)) != null) {
            keyStorePathFile = new ExtendedFile(new File(sslStorePath), keyStorePath);
        }
        if (!(keyStore = keyStorePathFile == null || !keyStorePathFile.exists() ? new File(keyStorePath) : new File(keyStorePathFile.getAbsolutePath())).exists()) {
            throw new FileNotFoundException("keystore file does not exist: " + keyStore.getAbsolutePath());
        }
        return keyStore;
    }

    private KeyStore getKeyStore(String keyStorePath, String keyPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore;
        File keyStoreFile = this.getKeyStoreFile(keyStorePath);
        InputStream is = null;
        try {
            KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] password = keyPassword.toCharArray();
            is = new BufferedInputStream(new FileInputStream(keyStoreFile));
            keyStore2.load(is, password);
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {}
        return keyStore;
    }

    protected KeyManager[] createKeyManagers(KeyStore keyStore, String keyPassword) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        KeyManagerFactory keyFactory = null;
        if (this.fipsConfiguration.isValid()) {
            try {
                keyFactory = KeyManagerFactory.getInstance(this.fipsConfiguration.KEY_MANAGER_FACTORY_ALGORITHM, this.fipsConfiguration.KEY_MANAGER_FACTORY_PROVIDER);
            }
            catch (Exception e) {
                this.getFeedbackChannel().error(this.feedbackModule, "Failed to create FIPS KeyManagerFactory: " + e.getMessage());
                this.getFeedbackChannel().debug(this.feedbackModule, "Failed to create FIPS KeyManagerFactory", e);
                return null;
            }
        }
        try {
            if (keyFactory == null) {
                keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            }
            keyFactory.init(keyStore, keyPassword.toCharArray());
        }
        catch (Exception e) {
            this.getFeedbackChannel().error(this.feedbackModule, "Failed to initialize KeyManagerFactory: " + e.getMessage());
            this.getFeedbackChannel().debug(this.feedbackModule, "Failed to initialize KeyManagerFactory", e);
            return null;
        }
        return keyFactory.getKeyManagers();
    }

    public String[] removeUnsupportedCiphers(String[] configuredCiphers, String[] supportedCiphers, IModuleFeedbackChannel feedback) {
        String cipher;
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> supported = new ArrayList<String>(supportedCiphers.length);
        String[] stringArray = supportedCiphers;
        int n = supportedCiphers.length;
        int n2 = 0;
        while (n2 < n) {
            cipher = stringArray[n2];
            supported.add(cipher);
            ++n2;
        }
        feedback.info("SSL socket factory supported ciphers are: " + supported);
        stringArray = configuredCiphers;
        n = configuredCiphers.length;
        n2 = 0;
        while (n2 < n) {
            cipher = stringArray[n2];
            if (supported.contains(cipher)) {
                result.add(cipher);
            } else {
                feedback.info("SSL socket factory configured cipher " + cipher + " is not supported by JVM");
            }
            ++n2;
        }
        feedback.info("Setting SSL socket ciphers to: " + result);
        return result.toArray(new String[result.size()]);
    }

    protected SSLContext createSSLContext(IndexedProperties properties, IModuleFeedbackChannel feedback) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, UnrecoverableKeyException {
        this.fipsConfiguration = new FIPSConfiguration(properties, feedback);
        String key = null;
        key = this.fServerId == null ? "transport.tcp.ciphersuites" : "transport.tcp.ciphersuites." + this.fServerId;
        String[] configuredCiphers = properties.safeGetSeparatedProperty(key, ", ", this.kDefaultCipherSuites);
        key = this.fServerId == null ? "transport.tcp.protocols" : "transport.tcp.protocols." + this.fServerId;
        this.fProtocols = properties.safeGetSeparatedProperty(key, ", ", new String[0]);
        key = this.fServerId == null ? "transport.tcp.truststore" : "transport.tcp.truststore." + this.fServerId;
        String trustStorePath = properties.getProperty(key);
        key = this.fServerId == null ? "transport.tcp.trustpassword" : "transport.tcp.trustpassword." + this.fServerId;
        String trustPassword = properties.getPasswordProperty(key);
        if (!StringUtils.isEmpty(trustStorePath) && StringUtils.isEmpty(trustPassword)) {
            throw new IllegalArgumentException("trust store password property is missing " + key);
        }
        TrustManager[] trustManagers = null;
        if (trustStorePath != null && trustPassword != null) {
            KeyStore trustStore = this.getTrustStore(trustStorePath, trustPassword);
            trustManagers = this.createTrustManagers(trustStore);
        } else {
            trustManagers = this.createDefaultTrustManagers();
            feedback.verbose("No trust store configured.  Using default all-trusting trust manager");
        }
        key = this.fServerId == null ? "transport.tcp.keystore" : "transport.tcp.keystore." + this.fServerId;
        String keyStorePath = properties.getProperty(key);
        key = this.fServerId == null ? "transport.tcp.keypassword" : "transport.tcp.keypassword." + this.fServerId;
        String keyPassword = properties.getPasswordProperty(key);
        if (!StringUtils.isEmpty(keyStorePath) && StringUtils.isEmpty(keyPassword)) {
            throw new IllegalArgumentException("key store password property is missing " + key);
        }
        KeyManager[] keyManagers = null;
        if (keyStorePath != null && keyPassword != null) {
            KeyStore keyStore = this.getKeyStore(keyStorePath, keyPassword);
            keyManagers = this.createKeyManagers(keyStore, keyPassword);
        }
        SSLContext context = this.createSSLContext(keyManagers, trustManagers);
        String[] supportedCiphers = context.getSocketFactory().getSupportedCipherSuites();
        this.fCipherSuites = this.removeUnsupportedCiphers(configuredCiphers, supportedCiphers, feedback);
        return context;
    }

    public static boolean enableHostnameValidation(SSLSocket socket) {
        SSLParameters params = ASSLSocketFactory.enableHostnameValidation(socket.getSSLParameters());
        if (params != null) {
            socket.setSSLParameters(params);
            return true;
        }
        return false;
    }

    public static SSLParameters enableHostnameValidation(SSLParameters params) {
        Method method;
        try {
            method = SSLParameters.class.getMethod("setEndpointIdentificationAlgorithm", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        if (params == null) {
            params = new SSLParameters();
        }
        try {
            method.invoke((Object)params, "HTTPS");
        }
        catch (Exception exception) {
            return null;
        }
        return params;
    }

    protected SSLContext createSSLContext(KeyManager[] keyManagers, TrustManager[] trustManagers) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext returnContext = null;
        SecureRandom secureRandom = null;
        if (this.fipsConfiguration.isValid()) {
            try {
                returnContext = SSLContext.getInstance(this.fipsConfiguration.SSL_CONTEXT_PROTOCOL, this.fipsConfiguration.SSL_CONTEXT_PROVIDER);
                secureRandom = SecureRandom.getInstance(this.fipsConfiguration.SECURE_RANDOM_ALGORITHM, this.fipsConfiguration.SECURE_RANDOM_PROVIDER);
            }
            catch (Exception e) {
                this.getFeedbackChannel().error(this.feedbackModule, "Failed to create FIPS SSLContext: " + e.getMessage());
                this.getFeedbackChannel().debug(this.feedbackModule, "Failed to create FIPS SSLContext", e);
                return null;
            }
        }
        if (returnContext == null) {
            String protocol = null;
            int i = 0;
            while (i < KIsengardConstants.kSSLProtocols.length) {
                protocol = KIsengardConstants.kSSLProtocols[i];
                try {
                    SSLContext.getInstance(protocol);
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    ++i;
                }
            }
            returnContext = SSLContext.getInstance(protocol);
            secureRandom = null;
        }
        try {
            returnContext.init(keyManagers, trustManagers, secureRandom);
        }
        catch (Exception e) {
            this.getFeedbackChannel().error(this.feedbackModule, "Failed to initialize SSLContext: " + e.getMessage());
            this.getFeedbackChannel().debug(this.feedbackModule, "Failed to initialize SSLContext", e);
            return null;
        }
        return returnContext;
    }

    private class FIPSConfiguration {
        final String BOUNCY_CASTLE_THIRD_PARTY_API = "bouncycastle";
        final String SECURE_RANDOM_ALGORITHM;
        final String SECURE_RANDOM_ALGORITHM_DEFAULT = "DEFAULT";
        final String SECURE_RANDOM_PROVIDER;
        final String SECURE_RANDOM_BC_PROVIDER_DEFAULT = "BCFIPS";
        final String SSL_CONTEXT_PROTOCOL;
        final String SSL_CONTEXT_PROTOCOL_DEFAULT = "TLSv1.2";
        final String SSL_CONTEXT_PROVIDER;
        final String SSL_CONTEXT_BC_PROVIDER_DEFAULT = "BCJSSE";
        final String TRUST_MANAGER_FACTORY_ALGORITHM;
        final String TRUST_MANAGER_FACTORY_BC_ALGORITHM_DEFAULT = "PKIX";
        final String TRUST_MANAGER_FACTORY_PROVIDER;
        final String TRUST_MANAGER_FACTORY_BC_PROVIDER_DEFAULT = "BCJSSE";
        final String KEY_MANAGER_FACTORY_ALGORITHM;
        final String KEY_MANAGER_FACTORY_BC_ALGORITHM_DEFAULT = "PKIX";
        final String KEY_MANAGER_FACTORY_PROVIDER;
        final String KEY_MANAGER_FACTORY_BC_PROVIDER_DEFAULT = "BCJSSE";
        private boolean isValid = false;

        public FIPSConfiguration(IndexedProperties properties, IModuleFeedbackChannel feedback) {
            String thirdPartyAPIOrig = this.getPropertyHelper(properties, "transport.https.fips.third.party.api");
            String thirdPartyAPI = thirdPartyAPIOrig != null ? thirdPartyAPIOrig.toLowerCase().trim() : null;
            boolean isBCEnabled = "bouncycastle".equals(thirdPartyAPI);
            if (isBCEnabled) {
                System.setProperty("org.bouncycastle.fips.approved_only", Boolean.TRUE.toString());
            }
            this.outInfoMessage(feedback, "transport.https.fips.third.party.api", thirdPartyAPIOrig, thirdPartyAPI);
            if (thirdPartyAPI != null && thirdPartyAPI.length() > 0) {
                String secureRandomAlgorithm = this.getPropertyHelper(properties, "transport.https.fips.secure.random.algorithm");
                this.SECURE_RANDOM_ALGORITHM = secureRandomAlgorithm != null ? secureRandomAlgorithm : "DEFAULT";
                String secureRandomProvider = this.getPropertyHelper(properties, "transport.https.fips.secure.random.provider");
                this.SECURE_RANDOM_PROVIDER = secureRandomProvider != null ? secureRandomProvider : (isBCEnabled ? "BCFIPS" : null);
                String sslContextProtocol = this.getPropertyHelper(properties, "transport.https.fips.ssl.context.protocol");
                this.SSL_CONTEXT_PROTOCOL = sslContextProtocol != null ? sslContextProtocol : "TLSv1.2";
                String sslContextProvider = this.getPropertyHelper(properties, "transport.https.fips.ssl.context.provider");
                this.SSL_CONTEXT_PROVIDER = sslContextProvider != null ? sslContextProvider : (isBCEnabled ? "BCJSSE" : null);
                String tmAlgorithm = this.getPropertyHelper(properties, "transport.https.fips.trust.manager.factory.algorithm");
                this.TRUST_MANAGER_FACTORY_ALGORITHM = tmAlgorithm != null ? tmAlgorithm : (isBCEnabled ? "PKIX" : TrustManagerFactory.getDefaultAlgorithm());
                String tmProvider = this.getPropertyHelper(properties, "transport.https.fips.trust.manager.factory.provider");
                this.TRUST_MANAGER_FACTORY_PROVIDER = tmProvider != null ? tmProvider : (isBCEnabled ? "BCJSSE" : null);
                String kmAlgorithm = this.getPropertyHelper(properties, "transport.https.fips.key.manager.factory.algoritm");
                this.KEY_MANAGER_FACTORY_ALGORITHM = kmAlgorithm != null ? kmAlgorithm : (isBCEnabled ? "PKIX" : KeyManagerFactory.getDefaultAlgorithm());
                String kmProvider = this.getPropertyHelper(properties, "transport.https.fips.key.manager.factory.provider");
                this.KEY_MANAGER_FACTORY_PROVIDER = kmProvider != null ? kmProvider : (isBCEnabled ? "BCJSSE" : null);
                this.isValid = this.SECURE_RANDOM_ALGORITHM != null && this.SECURE_RANDOM_PROVIDER != null && this.SSL_CONTEXT_PROTOCOL != null && this.SSL_CONTEXT_PROVIDER != null && this.TRUST_MANAGER_FACTORY_ALGORITHM != null && this.TRUST_MANAGER_FACTORY_PROVIDER != null && this.KEY_MANAGER_FACTORY_ALGORITHM != null && this.KEY_MANAGER_FACTORY_PROVIDER != null;
                this.outInfoMessage(feedback, "transport.https.fips.secure.random.algorithm", secureRandomAlgorithm, this.SECURE_RANDOM_ALGORITHM);
                this.outInfoMessage(feedback, "transport.https.fips.secure.random.provider", secureRandomProvider, this.SECURE_RANDOM_PROVIDER);
                this.outInfoMessage(feedback, "transport.https.fips.ssl.context.protocol", sslContextProtocol, this.SSL_CONTEXT_PROTOCOL);
                this.outInfoMessage(feedback, "transport.https.fips.ssl.context.provider", sslContextProvider, this.SSL_CONTEXT_PROVIDER);
                this.outInfoMessage(feedback, "transport.https.fips.trust.manager.factory.algorithm", tmAlgorithm, this.TRUST_MANAGER_FACTORY_ALGORITHM);
                this.outInfoMessage(feedback, "transport.https.fips.trust.manager.factory.provider", tmProvider, this.TRUST_MANAGER_FACTORY_PROVIDER);
                this.outInfoMessage(feedback, "transport.https.fips.key.manager.factory.algoritm", kmAlgorithm, this.KEY_MANAGER_FACTORY_ALGORITHM);
                this.outInfoMessage(feedback, "transport.https.fips.key.manager.factory.provider", kmProvider, this.KEY_MANAGER_FACTORY_PROVIDER);
            } else {
                this.SECURE_RANDOM_ALGORITHM = null;
                this.SECURE_RANDOM_PROVIDER = null;
                this.SSL_CONTEXT_PROTOCOL = null;
                this.SSL_CONTEXT_PROVIDER = null;
                this.TRUST_MANAGER_FACTORY_ALGORITHM = null;
                this.TRUST_MANAGER_FACTORY_PROVIDER = null;
                this.KEY_MANAGER_FACTORY_ALGORITHM = null;
                this.KEY_MANAGER_FACTORY_PROVIDER = null;
                this.isValid = false;
            }
        }

        private String getPropertyHelper(IndexedProperties properties, String propKey) {
            return properties.getProperty(this.getServerProp(propKey));
        }

        private String getServerProp(String propKey) {
            if (ASSLSocketFactory.this.fServerId != null) {
                propKey = String.valueOf(propKey) + "." + ASSLSocketFactory.this.fServerId;
            }
            return propKey;
        }

        private void outInfoMessage(IModuleFeedbackChannel feedback, String prop, String userValue, String actual) {
            prop = this.getServerProp(prop);
            String isDefault = userValue == null ? " (default)" : "";
            feedback.info(String.valueOf(prop) + "=" + actual + isDefault);
        }

        public boolean isValid() {
            return this.isValid;
        }
    }
}

