/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.v1;

import com.wily.isengard.postofficehub.link.v1.ABaseClientTransport;
import com.wily.isengard.util.parameter.CheckParameter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public final class ClientSocketTransport
extends ABaseClientTransport {
    private final Socket fSocket;

    public ClientSocketTransport(Socket socket, int version) throws SocketException {
        super(version);
        CheckParameter.notNull("Socket", socket);
        this.fSocket = socket;
    }

    @Override
    public InputStream getRawInputStream() throws IOException {
        return this.fSocket.getInputStream();
    }

    @Override
    public OutputStream getRawOutputStream() throws IOException {
        return this.fSocket.getOutputStream();
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.fSocket.getInetAddress();
    }

    @Override
    public int getRemotePort() {
        return this.fSocket.getPort();
    }

    @Override
    public void closeRemoteConnection() {
        Thread.interrupted();
        try {
            try {
                this.fSocket.shutdownOutput();
            }
            catch (Throwable throwable) {}
            try {
                this.fSocket.shutdownInput();
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            try {
                this.fSocket.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            this.fSocket.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    protected boolean isTrafficObfuscated() {
        return true;
    }

    @Override
    public String getType() {
        return "socket";
    }

    @Override
    public String getRemoteHostName() {
        return this.getRemoteAddress().getHostName();
    }

    public String toString() {
        return "Socket Transport connected with " + this.fSocket.toString();
    }
}

