/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.parser.DGInvalidFlagNameException;
import com.wily.util.classfile.InvalidIdentifierException;
import com.wily.util.classfile.java.ClassFileValidationUtilities;

public final class FlagName {
    private final String fName;
    private final String fCaseInsensitiveName;

    private FlagName(String name) {
        this.fName = name.intern();
        this.fCaseInsensitiveName = name.toLowerCase().intern();
    }

    public String getName() {
        return this.fName;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FlagName) {
            return this.fCaseInsensitiveName.equals(((FlagName)obj).fCaseInsensitiveName);
        }
        return false;
    }

    public int hashCode() {
        return this.fCaseInsensitiveName.hashCode();
    }

    public static FlagName getFlagName(String name) throws DGInvalidFlagNameException {
        try {
            ClassFileValidationUtilities.validateCoreJavaIdentifier((String)name);
        }
        catch (InvalidIdentifierException iie) {
            throw new DGInvalidFlagNameException(iie.getIdentifier());
        }
        return new FlagName(name);
    }
}

