/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.errors;

import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureBlameStack;
import com.wily.introscope.agent.blamestackfeature.BlameStackFeatureStackEntry;
import com.wily.introscope.agent.blamestackfeature.IBlameStackFeature;
import com.wily.introscope.agent.errors.IErrorSnapshotFeature;
import com.wily.introscope.agent.errors.Log;
import com.wily.introscope.agent.errors.Throttle;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.spec.server.transactiontrace.AgentSideErrorTransactionTraceFilter;
import java.util.HashMap;

public class SoapFaultSnapshotFeature
implements IBlameStackFeature,
IErrorSnapshotFeature {
    private BlameStackFeatureBlameStack fStack;
    private boolean fErrorDetected;
    private final ComponentTracer fComponentTracer;

    public SoapFaultSnapshotFeature(BlameStackFeatureBlameStack blameStack, ComponentTracer componentTracer) {
        this.fStack = blameStack;
        this.fComponentTracer = componentTracer;
        this.fErrorDetected = false;
    }

    public void onAfterPop(BlameStackFeatureStackEntry poppedEntry, BlameStackFeatureStackEntry newTopEntry) {
        if (this.fErrorDetected) {
            this.sendErrorSnapshot(poppedEntry);
            this.fErrorDetected = false;
        }
    }

    public boolean flagErrorInManagedApplication(String errorMessage) {
        boolean result = false;
        if (!this.fStack.IBlameStack_isEmpty() && !this.fErrorDetected) {
            if (Log.out.isDebugEnabled()) {
                Log.out.debug("Will send soap snapshot:" + errorMessage);
            }
            this.fErrorDetected = true;
            AgentSideErrorTransactionTraceFilter.AnyErrorFlag.set(Boolean.TRUE);
            this.annotateFrameWithError(errorMessage);
            result = true;
        }
        return result;
    }

    private void sendErrorSnapshot(BlameStackFeatureStackEntry poppedEntry) {
        HashMap<String, String> rootParams = new HashMap<String, String>();
        rootParams.put("Trace Type", "ErrorSnapshot");
        rootParams.put("Trace SubType", "SoapFaultSnapshot");
        this.fStack.makeAndSendSnapshot(poppedEntry, rootParams);
    }

    public void annotateFrameWithError(String string) {
        String limitedString = InvocationData.limitSize((String)string);
        this.fComponentTracer.addExtraParameter("Extra Error Message", limitedString);
    }

    public void onBeforePush(BlameStackFeatureStackEntry entry) {
    }

    public void tearDown() {
    }

    public void setFrontBoundary(String component) {
    }

    public void setEndBoundary(String component) {
    }

    public void reset() {
    }

    public void setThrottle(Throttle throttle) {
    }
}

