/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.transform;

import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.apply.ClassSettingsApplier;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.cmp.mutate.IMethodMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.transform.AClassAndEveryMethodTransformation;
import com.wily.diagnos.cmp.transform.builder.ITransformationBuilder;
import com.wily.diagnos.cmp.transform.builder.InjectFieldIntoClassTransformationBuilder;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import java.util.HashSet;
import java.util.Set;

public class InjectFieldIntoClassTransformation
extends AClassAndEveryMethodTransformation {
    private final TracerGroup fTracerGroup;
    private final String fFieldName;
    private final String fFieldDesc;
    private final Set<String> fInjectedToClassSet = new HashSet<String>();

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fFieldDesc == null ? 0 : this.fFieldDesc.hashCode());
        result = 31 * result + (this.fFieldName == null ? 0 : this.fFieldName.hashCode());
        result = 31 * result + (this.fTracerGroup == null ? 0 : this.fTracerGroup.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InjectFieldIntoClassTransformation other = (InjectFieldIntoClassTransformation)obj;
        if (this.fFieldDesc == null ? other.fFieldDesc != null : !this.fFieldDesc.equals(other.fFieldDesc)) {
            return false;
        }
        if (this.fFieldName == null ? other.fFieldName != null : !this.fFieldName.equals(other.fFieldName)) {
            return false;
        }
        return !(this.fTracerGroup == null ? other.fTracerGroup != null : !this.fTracerGroup.equals(other.fTracerGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFieldAsInjected(String className) {
        Set<String> set = this.fInjectedToClassSet;
        synchronized (set) {
            this.fInjectedToClassSet.add(className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFieldInjectedToClass(String className) {
        Set<String> set = this.fInjectedToClassSet;
        synchronized (set) {
            return this.fInjectedToClassSet.contains(className);
        }
    }

    public TracerGroup getTracerGroup() {
        return this.fTracerGroup;
    }

    public String getFieldName() {
        return this.fFieldName;
    }

    public String getFieldDesc() {
        return this.fFieldDesc;
    }

    public InjectFieldIntoClassTransformation(ICompilerLog log, String name, String desc) {
        this(log, null, name, desc);
    }

    public InjectFieldIntoClassTransformation(ICompilerLog log, TracerGroup tracerGroup, String name, String desc) {
        super(log);
        this.fTracerGroup = tracerGroup;
        this.fFieldName = name;
        this.fFieldDesc = desc;
    }

    @Override
    public ITransformationBuilder generateTransformationBuilder(CompilerSettingsBuilder builder) {
        return new InjectFieldIntoClassTransformationBuilder(builder.getTracerGroupBuilder(this.getTracerGroup()), this.getFieldName(), this.getFieldDesc());
    }

    @Override
    public boolean isClassStructureAltering(Class<?> classRedefined) {
        if (classRedefined == null) {
            return true;
        }
        String className = classRedefined.getName();
        return !this.isFieldInjectedToClass(className);
    }

    @Override
    protected boolean doShouldProcessClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return !ClassSettingsApplier.shouldSkipClassForTracerGroup(this.getLog(), targetClass, this.getTracerGroup()) && this.getTracerGroup().getClassMatcher().IClassMatcher_matches(targetClass);
    }

    @Override
    protected boolean doShouldMutateClass(DGCompilerSettings settings, IModeledClass targetClass) {
        return true;
    }

    @Override
    protected boolean doShouldMutateMethod(DGCompilerSettings settings, IModeledMethod targetMethod) {
        return false;
    }

    @Override
    protected IMutation doGenerateClassMutation(DGCompilerSettings settings, IClassMutator mutator, IModeledClass targetClass) {
        return mutator.newInjectFieldIntoClassMutation(settings, targetClass, this);
    }

    @Override
    protected IMutation doGenerateMethodMutation(DGCompilerSettings settings, IMethodMutator mutator, IModeledMethod targetMethod) {
        return null;
    }

    @Override
    public boolean shouldValidateDurinDirectiveReload() {
        return false;
    }
}

