/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile;

import com.wily.diagnos.cmp.classfile.DGAlreadyInstrumentedException;
import com.wily.diagnos.cmp.classfile.DGClassAlreadyInstrumentedException;
import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.classfile.DGIncompleteClassFileException;
import com.wily.diagnos.cmp.classfile.DGInvalidClassFileException;
import com.wily.diagnos.cmp.classfile.DGInvalidUTFDataException;
import com.wily.diagnos.cmp.classfile.DGInvalidVersionException;
import com.wily.diagnos.cmp.classfile.DGMethodAlreadyInstrumentedException;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.utility.CompilerSettingsUtility;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.log.NullCompilerLog;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.tracer.DGAggregateAllParameterMethodTracer;
import com.wily.diagnos.cmp.tracer.DGAggregateMethodTracer;
import com.wily.diagnos.cmp.transform.AgentInitializationTransformation;
import com.wily.diagnos.cmp.transform.CatchExceptionTransformation;
import com.wily.diagnos.cmp.transform.InjectFieldIntoClassTransformation;
import com.wily.diagnos.cmp.transform.NoticeConstructorCompletionTransformation;
import com.wily.diagnos.cmp.transform.NoticeFieldAssignmentTransformation;
import com.wily.diagnos.cmp.transform.NoticeObjectCreationTransformation;
import com.wily.diagnos.cmp.transform.SubstituteClassTransformation;
import com.wily.diagnos.cmp.transform.SubstituteObjRefResultTransformation;
import com.wily.diagnos.cmp.transform.SubstituteParamByNamedProxyTransformation;
import com.wily.diagnos.cmp.transform.SubstituteResultByNamedProxyTransformation;
import com.wily.diagnos.cmp.transform.SubstituteStaticFieldTransformation;
import com.wily.diagnos.cmp.transform.SubstituteStaticMethodTransformation;
import com.wily.diagnos.cmp.transform.ThrowExceptionTransformation;
import com.wily.diagnos.personality.java.classfile.DGClassConstants;
import com.wily.diagnos.personality.java.classfile.DGField;
import com.wily.diagnos.personality.java.classfile.DGInterfaces;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.diagnos.personality.java.classfile.attributes.DGAttribute;
import com.wily.diagnos.personality.java.classfile.attributes.DGAttributes;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.IAnnotationAttribute;
import com.wily.diagnos.personality.java.classfile.bytecode.DGByteCode;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.diagnos.personality.java.classfile.constants.DGFieldMethodRefConstant;
import com.wily.diagnos.personality.java.mutate.AgentInitializationMutation;
import com.wily.diagnos.personality.java.mutate.CatchExceptionMutation;
import com.wily.diagnos.personality.java.mutate.InjectFieldIntoClassClassMutation;
import com.wily.diagnos.personality.java.mutate.NoticeConstructorCompletionMutation;
import com.wily.diagnos.personality.java.mutate.NoticeFieldAssignmentMutation;
import com.wily.diagnos.personality.java.mutate.NoticeObjectCreationMutation;
import com.wily.diagnos.personality.java.mutate.SubscribeToClassMutation;
import com.wily.diagnos.personality.java.mutate.SubscribeToOneMethodMutation;
import com.wily.diagnos.personality.java.mutate.SubstituteClassMethodMutation;
import com.wily.diagnos.personality.java.mutate.SubstituteObjRefResultMutation;
import com.wily.diagnos.personality.java.mutate.SubstituteParamByNamedProxyMutation;
import com.wily.diagnos.personality.java.mutate.SubstituteResultByNamedProxyMutation;
import com.wily.diagnos.personality.java.mutate.SubstituteStaticFieldMutation;
import com.wily.diagnos.personality.java.mutate.SubstituteStaticMethodMutation;
import com.wily.diagnos.personality.java.mutate.SubstituteSuperclassClassMutation;
import com.wily.diagnos.personality.java.mutate.ThrowExceptionMutation;
import com.wily.diagnos.personality.java.tracer.DGAggregateAllParameterConstructorMethodTracerInstance;
import com.wily.diagnos.personality.java.tracer.DGAggregateAllParameterMethodTracerInstance;
import com.wily.diagnos.personality.java.tracer.DGAggregateConstructorMethodTracerInstance;
import com.wily.diagnos.personality.java.tracer.DGAggregateMethodTracerInstance;
import com.wily.introscope.agent.transformer.dynamic.ThreadLocalClassHelper;
import com.wily.util.classfile.ClassFileException;
import com.wily.util.classfile.FullyQualifiedFieldName;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.INarrowedMatchingClass;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.wilyassert.Assertion;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

public class DGClass
implements DGClassConstants,
IClassMutator,
IModeledClass,
INarrowedMatchingClass {
    private static final String kInvalidMagicNumberMessage = "Bad Magic Number";
    private static final int JDK1_0_2 = 102;
    private static final int JDK1_1 = 11;
    private static final int JDK1_2 = 12;
    private static final int JDK1_3 = 13;
    private static final int JDK1_4 = 14;
    private static final int JDK1_5 = 15;
    private static final int JDK1_6 = 16;
    private static final int JDK1_7 = 17;
    private static final int JDK1_8 = 18;
    private static final int JDK1_9 = 19;
    private static final int JDK10 = 20;
    private static final int JDK11 = 21;
    private static boolean kActivateDeepInheritance = true;
    private int kIsAssignable = 0;
    private int kIsNotAssignable = 1;
    private int kInconclusive = 2;
    private int fMajorVersion;
    private int fMinorVersion;
    private int fAccessFlags;
    protected DGConstantPool fConstantPool;
    protected final int fCPI_class;
    protected int fCPI_superClass;
    private final DGInterfaces fInterfaces;
    private Vector fFields;
    private Vector fMethods;
    private final DGAttributes fAttributes;
    private final ICompilerLog fLog;
    private final IClassName fClassName;
    private IClassName fSuperClassName = null;
    public final String[] fPossibleKeys;

    public static void setDeepInheritance(boolean activateInheritance) {
        kActivateDeepInheritance = activateInheritance;
    }

    public DGClass(InputStream is) throws DGClassLoadingException, IOException {
        this(is, NullCompilerLog.getInstance());
    }

    public DGClass(InputStream is, ICompilerLog log) throws DGClassLoadingException, IOException {
        Assertion.wilyAssert((log != null ? 1 : 0) != 0);
        this.fLog = log;
        try {
            DataInputStream in = new DataInputStream(is);
            int magic = in.readInt();
            if (magic != -889275714) {
                throw new DGInvalidClassFileException(kInvalidMagicNumberMessage, (ILocalizableMessage)new SimpleLocalizableMessage("Diagnos_Exception_Invalid_Magic_Number"));
            }
            this.fMinorVersion = in.readUnsignedShort();
            this.fMajorVersion = in.readUnsignedShort();
            this.fConstantPool = new DGConstantPool(in, this);
            this.fConstantPool.validate();
            this.fAccessFlags = in.readUnsignedShort();
            this.fCPI_class = in.readUnsignedShort();
            this.fClassName = ClassName.getClassName((String)this.fConstantPool.getClassName(this.fCPI_class));
            this.setSuperClassCPI(in.readUnsignedShort());
            this.fInterfaces = new DGInterfaces(this.fConstantPool, in);
            int fieldCount = in.readUnsignedShort();
            this.fFields = new Vector(fieldCount);
            int i = 0;
            while (i < fieldCount) {
                DGField field = new DGField(this.fConstantPool, in, this.fLog);
                this.fFields.addElement(field);
                ++i;
            }
            int methodCount = in.readUnsignedShort();
            this.fMethods = new Vector(methodCount);
            int i2 = 0;
            while (i2 < methodCount) {
                DGMethod method = new DGMethod(this.fConstantPool, in, this.fLog, this);
                this.fMethods.addElement(method);
                ++i2;
            }
            this.fAttributes = new DGAttributes(this.fConstantPool, in, this.fLog);
            this.fPossibleKeys = this.fetchPossibleKeys();
        }
        catch (EOFException eOFException) {
            throw new DGIncompleteClassFileException();
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new DGInvalidUTFDataException();
        }
        catch (ClassFileException classFileException) {
            throw new DGInvalidClassFileException();
        }
    }

    public int getMajorVersion() {
        return this.fMajorVersion;
    }

    public int getMinorVersion() {
        return this.fMinorVersion;
    }

    private String[] fetchPossibleKeys() {
        String[] attributesPossibleKeys = this.fAttributes.getPossibleKeys();
        String[] interfacesPossibleKeys = this.fInterfaces.getPossibleKeys();
        ArrayList<String> possibleKeys = new ArrayList<String>(attributesPossibleKeys.length + interfacesPossibleKeys.length + 2);
        int i = 0;
        while (i < attributesPossibleKeys.length) {
            possibleKeys.add(attributesPossibleKeys[i]);
            ++i;
        }
        i = 0;
        while (i < interfacesPossibleKeys.length) {
            possibleKeys.add(interfacesPossibleKeys[i]);
            ++i;
        }
        possibleKeys.add(CompilerSettingsUtility.getKeyFromString(this.fClassName.getPackageAndNameString()));
        if (this.hasSuperClass()) {
            possibleKeys.add(CompilerSettingsUtility.getKeyFromString(this.getSuperClassName().getPackageAndNameString()));
        }
        return possibleKeys.toArray(new String[0]);
    }

    public DGClass(String className, String superClassName, int accessFlags, String[] interfaces) throws DGClassModificationException, ClassFileException {
        this.fLog = NullCompilerLog.getInstance();
        this.fMajorVersion = 45;
        this.fMinorVersion = 3;
        this.fAccessFlags = accessFlags | 0x20;
        this.fConstantPool = new DGConstantPool();
        this.fFields = new Vector();
        this.fMethods = new Vector();
        this.fAttributes = new DGAttributes(this.fConstantPool);
        this.fCPI_class = this.fConstantPool.addClassReference(className);
        this.fClassName = ClassName.getClassName((String)this.fConstantPool.getClassName(this.fCPI_class));
        this.setSuperClassCPI(this.fConstantPool.addClassReference(superClassName));
        this.fInterfaces = new DGInterfaces(this.fConstantPool, interfaces);
        this.fPossibleKeys = this.fetchPossibleKeys();
    }

    public IClassName getClassName() {
        return this.fClassName;
    }

    public boolean hasSuperClass() {
        return this.fSuperClassName != null;
    }

    public IClassName getSuperClassName() {
        return this.fSuperClassName;
    }

    public ICompilerLog getLog() {
        return this.fLog;
    }

    public String getSuperClassQualifiedNameString() {
        if (this.fSuperClassName == null) {
            return "";
        }
        return this.fSuperClassName.getPackageAndNameString();
    }

    public boolean isPublic() {
        return (this.fAccessFlags & 1) != 0;
    }

    public void makePublic() {
        if (!this.isPublic()) {
            this.fAccessFlags |= 1;
        }
    }

    public void makeConstructorsPublic() {
        Iterator temp = this.getAllDeclaredMethods();
        while (temp.hasNext()) {
            DGMethod current = (DGMethod)temp.next();
            if (current == null || !current.isClassConstructor() && !current.isInstanceConstructor()) continue;
            current.makePublic();
        }
    }

    public boolean makeFieldPublic(String name) {
        for (Object current : this.fFields) {
            DGField temp = (DGField)current;
            if (!temp.getName().equals(name)) continue;
            temp.makePublic();
            return true;
        }
        return false;
    }

    public boolean isInterface() {
        return (this.fAccessFlags & 0x200) != 0;
    }

    public boolean isValueType() {
        return false;
    }

    public boolean isAnnotation() {
        return (this.fAccessFlags & 0x2000) != 0;
    }

    public boolean isEnum() {
        return (this.fAccessFlags & 0x4000) != 0;
    }

    public boolean inheritsDirectlyFromInterface(IClassName interfaceName) {
        return this.getInterfaces().inheritsFrom(interfaceName.getPackageAndNameString());
    }

    public Iterator getAllDeclaredMethods() {
        return this.fMethods.iterator();
    }

    @Override
    public void markInstrumented(DGCompilerSettings settings, IModeledMethod targetMethod) throws DGClassModificationException, IOException {
        DGMethod dgMethod = (DGMethod)targetMethod;
        dgMethod.getAttributes().setInstrumentationInfo(settings.getInstrumentationInfo());
        dgMethod.getAttributes().addWilyAttribute();
    }

    @Override
    public void preflight(DGCompilerSettings settings, IModeledMethod targetMethod) throws DGClassModificationException, IOException {
    }

    @Override
    public void throwIfAlreadyInstrumented(IModeledMethod targetMethod) throws DGAlreadyInstrumentedException {
        DGMethod dgMethod = (DGMethod)targetMethod;
        if (dgMethod.getAttributes().hasWilyAttribute()) {
            throw new DGMethodAlreadyInstrumentedException();
        }
    }

    @Override
    public IMutation newSubscribeToOneMethodMutation(DGCompilerSettings settings, IModeledMethod targetMethod, String subscriberPluginName) {
        return new SubscribeToOneMethodMutation(settings, this, targetMethod, subscriberPluginName);
    }

    @Override
    public IMutation newSubscribeToClassMutation(DGCompilerSettings settings, IModeledClass targetClass, String subscriberPluginName) {
        return new SubscribeToClassMutation(settings, this, targetClass, subscriberPluginName);
    }

    @Override
    public IMutation newNoticeConstructorCompletionMethodMutation(DGCompilerSettings settings, IModeledMethod targetMethod, NoticeConstructorCompletionTransformation transform) {
        return new NoticeConstructorCompletionMutation(settings, this, transform, targetMethod, this.getLog());
    }

    @Override
    public IMutation newNoticeFieldAssignmentMethodMutation(DGCompilerSettings settings, IModeledMethod targetMethod, NoticeFieldAssignmentTransformation transform) {
        return new NoticeFieldAssignmentMutation(settings, this, transform, targetMethod);
    }

    @Override
    public IMutation newNoticeObjectCreationMethodMutation(DGCompilerSettings settings, IModeledMethod targetMethod, NoticeObjectCreationTransformation transform) {
        return new NoticeObjectCreationMutation(settings, this, transform, targetMethod);
    }

    @Override
    public IMutation newSubstituteSuperclassClassMutation(DGCompilerSettings settings, IModeledClass targetClass, SubstituteClassTransformation transform) {
        return new SubstituteSuperclassClassMutation(settings, this, transform, targetClass);
    }

    @Override
    public IMutation newInjectFieldIntoClassMutation(DGCompilerSettings settings, IModeledClass targetClass, InjectFieldIntoClassTransformation transform) {
        return new InjectFieldIntoClassClassMutation(settings, this, transform, targetClass);
    }

    @Override
    public IMutation newSubstituteClassMethodMutation(DGCompilerSettings settings, IModeledMethod targetMethod, SubstituteClassTransformation transform) {
        return new SubstituteClassMethodMutation(settings, this, transform, targetMethod);
    }

    @Override
    public IMutation newSubstituteObjRefResultMethodMutation(DGCompilerSettings settings, IModeledMethod targetMethod, SubstituteObjRefResultTransformation transform) {
        return new SubstituteObjRefResultMutation(settings, this, transform, targetMethod);
    }

    @Override
    public IMutation newSubstituteResultByNamedProxyMethodMutation(DGCompilerSettings settings, IModeledMethod targetMethod, SubstituteResultByNamedProxyTransformation transform) {
        return new SubstituteResultByNamedProxyMutation(settings, this, transform, targetMethod);
    }

    @Override
    public IMutation newSubstituteParamByNamedProxyMethodMutation(DGCompilerSettings settings, IModeledMethod targetMethod, SubstituteParamByNamedProxyTransformation transform) {
        return new SubstituteParamByNamedProxyMutation(settings, this, transform, targetMethod);
    }

    @Override
    public IMutation newSubstituteStaticFieldClassMutation(DGCompilerSettings settings, IModeledClass targetClass, SubstituteStaticFieldTransformation transform) {
        return new SubstituteStaticFieldMutation(settings, this, transform, targetClass);
    }

    @Override
    public IMutation newSubstituteStaticMethodClassMutation(DGCompilerSettings settings, IModeledClass targetClass, SubstituteStaticMethodTransformation transform) {
        return new SubstituteStaticMethodMutation(settings, this, transform, targetClass);
    }

    @Override
    public IMutation newThrowExceptionMethodMutation(DGCompilerSettings settings, IModeledMethod targetMethod, ThrowExceptionTransformation transform) {
        return new ThrowExceptionMutation(settings, (IClassMutator)this, transform, targetMethod);
    }

    @Override
    public IMutation newCatchExceptionMethodMutation(DGCompilerSettings settings, IModeledMethod targetMethod, CatchExceptionTransformation transform) {
        return new CatchExceptionMutation(settings, (IClassMutator)this, transform, targetMethod);
    }

    @Override
    public IMutation newAgentInitializationMethodMutation(DGCompilerSettings settings, IModeledMethod targetMethod, AgentInitializationTransformation transform) {
        return new AgentInitializationMutation(settings, this, transform, targetMethod);
    }

    @Override
    public IMutation newAggregateMethodTracerMutation(IModeledMethod targetMethod, DGAggregateMethodTracer tracer, IClassName tracerLoadingClass) {
        return new DGAggregateMethodTracerInstance(tracer, (DGMethod)targetMethod, (ClassName)tracerLoadingClass);
    }

    @Override
    public IMutation newAggregateConstructorMethodTracerMutation(IModeledMethod targetMethod, DGAggregateMethodTracer tracer, IClassName tracerLoadingClass) {
        return new DGAggregateConstructorMethodTracerInstance(tracer, (DGMethod)targetMethod, (ClassName)tracerLoadingClass);
    }

    @Override
    public IMutation newAggregateAllParameterMethodTracerMutation(IModeledMethod targetMethod, DGAggregateAllParameterMethodTracer tracer, IClassName tracerLoadingClass) {
        return new DGAggregateAllParameterMethodTracerInstance(tracer, (DGMethod)targetMethod, (ClassName)tracerLoadingClass);
    }

    @Override
    public IMutation newAggregateAllParameterConstructorMethodTracerMutation(IModeledMethod targetMethod, DGAggregateAllParameterMethodTracer tracer, IClassName tracerLoadingClass) {
        return new DGAggregateAllParameterConstructorMethodTracerInstance(tracer, (DGMethod)targetMethod, (ClassName)tracerLoadingClass);
    }

    @Override
    public IMutation newCustomConstructorMethodTracerMutation(IModeledMethod method, DGAggregateMethodTracer dgTracer, IClassName tracerLoadingClass) {
        return dgTracer.getConstructorMethodTracerMutationInstance(dgTracer, (DGMethod)method, (ClassName)tracerLoadingClass);
    }

    @Override
    public IMutation newCustomMethodTracerMutation(IModeledMethod method, DGAggregateMethodTracer dgTracer, IClassName tracerLoadingClass) {
        return dgTracer.getMethodTracerMutationInstance(dgTracer, (DGMethod)method, (ClassName)tracerLoadingClass);
    }

    private void validateVersion(int majorVersion, int minorVersion) throws DGInvalidVersionException {
        this.validateVersion(majorVersion, minorVersion, 21);
    }

    private void validateVersion(int majorVersion, int minorVersion, int jdkVersion) throws DGInvalidVersionException {
        if (!this.versionIsSupported(majorVersion, minorVersion, jdkVersion)) {
            throw new DGInvalidVersionException(majorVersion, minorVersion);
        }
    }

    private boolean versionIsSupported(int majorVersion, int minorVersion, int jdkVersion) {
        switch (jdkVersion) {
            case 21: {
                if (majorVersion == 55) {
                    return true;
                }
            }
            case 20: {
                if (majorVersion == 54) {
                    return true;
                }
            }
            case 19: {
                if (majorVersion == 53) {
                    return true;
                }
            }
            case 18: {
                if (majorVersion == 52) {
                    return true;
                }
            }
            case 17: {
                if (majorVersion == 51) {
                    return true;
                }
            }
            case 16: {
                if (majorVersion == 50) {
                    return true;
                }
            }
            case 15: {
                if (majorVersion == 49) {
                    return true;
                }
            }
            case 14: {
                if (majorVersion == 48) {
                    return true;
                }
            }
            case 13: {
                if (majorVersion == 47 || majorVersion == 46) {
                    return true;
                }
            }
            case 12: {
                if (majorVersion == 46 && minorVersion == 0) {
                    return true;
                }
            }
            case 11: {
                if (majorVersion == 45 && minorVersion >= 0 && minorVersion <= 65535) {
                    return true;
                }
            }
            case 102: {
                if (majorVersion != 45 || minorVersion < 0 || minorVersion > 3) break;
                return true;
            }
        }
        return false;
    }

    public DGConstantPool getConstantPool() {
        return this.fConstantPool;
    }

    public DGInterfaces getInterfaces() {
        return this.fInterfaces;
    }

    @Override
    public void throwIfAlreadyInstrumented(IModeledClass targetClass) throws DGAlreadyInstrumentedException {
        Assertion.wilyAssert((targetClass == this ? 1 : 0) != 0);
        if (this.fAttributes.hasWilyAttribute()) {
            throw new DGClassAlreadyInstrumentedException();
        }
    }

    @Override
    public void preflight(DGCompilerSettings settings, IModeledClass targetClass) throws DGClassModificationException {
        this.widenJumpOffsets(targetClass, settings.getMinOffsetForJumpWidening());
    }

    private void widenJumpOffsets(IModeledClass targetClass, int minOffsetToWiden) throws DGClassModificationException {
        Assertion.wilyAssert((targetClass == this ? 1 : 0) != 0);
        Enumeration e = this.fMethods.elements();
        while (e.hasMoreElements()) {
            DGMethod m = (DGMethod)e.nextElement();
            m.widenJumpOffsets(minOffsetToWiden);
        }
    }

    @Override
    public void markInstrumented(DGCompilerSettings settings, IModeledClass targetClass) throws DGClassModificationException, IOException {
        Assertion.wilyAssert((targetClass == this ? 1 : 0) != 0);
        this.fAttributes.setInstrumentationInfo(settings.getInstrumentationInfo());
        this.fAttributes.addWilyAttribute();
    }

    public boolean referencesClass(IClassName referencedName) {
        int cpiClass = this.fConstantPool.findClassReference(referencedName.getPackageAndNameString());
        return cpiClass != 0;
    }

    public void substituteStaticMethod(FullyQualifiedMethodName sourceMethod, FullyQualifiedMethodName replacementMethod) throws DGClassModificationException {
        this.substituteStaticMemberReference(sourceMethod.toString(), sourceMethod.getClassName(), sourceMethod.getMethodName().getNameString(), sourceMethod.getMethodName().getSignature().getSignatureString(), replacementMethod.toString(), replacementMethod.getClassName(), replacementMethod.getMethodName().getNameString(), replacementMethod.getMethodName().getSignature().getSignatureString());
    }

    public void substituteStaticField(FullyQualifiedFieldName sourceField, FullyQualifiedFieldName replacementField) throws DGClassModificationException {
        this.substituteStaticMemberReference(sourceField.toString(), sourceField.getClassName(), sourceField.getFieldName().getNameString(), sourceField.getFieldName().getSignature().getSignatureString(), replacementField.toString(), replacementField.getClassName(), replacementField.getFieldName().getNameString(), replacementField.getFieldName().getSignature().getSignatureString());
    }

    private void substituteStaticMemberReference(String fullSource, IClassName sourceClassName, String sourceMemberName, String sourceMemberDescriptor, String fullReplacement, IClassName replacementClassName, String replacementMemberName, String replacementMemberDescriptor) throws DGClassModificationException {
        Assertion.wilyAssert((boolean)false);
        DGFieldMethodRefConstant[] memberRefs = this.fConstantPool.findFieldMethodReferences(sourceClassName.toString(), sourceMemberName, sourceMemberDescriptor);
        if (memberRefs.length > 0) {
            this.fLog.ICompilerLog_logMemberReferenceChange(fullSource, fullReplacement);
            int i = 0;
            while (i < memberRefs.length) {
                memberRefs[i].redefine(replacementClassName.toString(), replacementMemberName);
                ++i;
            }
        }
    }

    public void addBytecodeToMethodStart(IClassMatcher classMatcher, IMethodMatcher methodMatcher, DGByteCode bytecode) throws DGClassModificationException {
        if (classMatcher.IClassMatcher_matches(this)) {
            Enumeration e = this.fMethods.elements();
            while (e.hasMoreElements()) {
                DGMethod method = (DGMethod)e.nextElement();
                if (!methodMatcher.IMethodMatcher_matches(method)) continue;
                method.addBytecodeToMethodStart(bytecode);
            }
        }
    }

    @Override
    public void disassemble(PrintStream ps) {
        ps.println("Class Disassembly");
        ps.println("=================");
        ps.println("Class Name: " + this.getClassName().getPackageAndNameString());
        ps.println("SuperClass: " + this.getSuperClassQualifiedNameString());
        ps.println();
        this.fConstantPool.disassemble(ps);
        ps.println("Fields");
        Enumeration e = this.fFields.elements();
        while (e.hasMoreElements()) {
            DGField f = (DGField)e.nextElement();
            ps.println(f.toString());
        }
    }

    public void write(OutputStream os) throws IOException {
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(os));
        out.writeInt(-889275714);
        out.writeShort(this.fMinorVersion);
        out.writeShort(this.fMajorVersion);
        this.fConstantPool.write(out);
        out.writeShort(this.fAccessFlags);
        out.writeShort(this.fCPI_class);
        out.writeShort(this.fCPI_superClass);
        this.fInterfaces.write(out);
        int fieldCount = this.fFields.size();
        out.writeShort(fieldCount);
        Enumeration e = this.fFields.elements();
        while (e.hasMoreElements()) {
            DGField f = (DGField)e.nextElement();
            f.write(out);
        }
        int methodCount = this.fMethods.size();
        out.writeShort(methodCount);
        e = this.fMethods.elements();
        while (e.hasMoreElements()) {
            DGMethod m = (DGMethod)e.nextElement();
            m.write(out);
        }
        this.fAttributes.write(out);
        out.flush();
    }

    public void renameClass(String newName) {
        try {
            this.fConstantPool.renameUtf(this.getClassName().getPackageAndNameString(), newName);
        }
        catch (DGClassLoadingException dGClassLoadingException) {}
    }

    public void setSuperClassCPI(int newSuperClassCPI) throws ClassFileException {
        this.fCPI_superClass = newSuperClassCPI;
        this.fSuperClassName = this.getClassName().getPackageAndNameString().equals("java/lang/Object") ? null : ClassName.getClassName((String)this.fConstantPool.getClassName(this.fCPI_superClass));
    }

    public int getClassCPI() {
        return this.fCPI_class;
    }

    public int getSuperClassCPI() {
        return this.fCPI_superClass;
    }

    public Enumeration getMethods() {
        return this.fMethods.elements();
    }

    public DGAttributes getAttributes() {
        return this.fAttributes;
    }

    public boolean containsAnnotation(IClassName annotationName) {
        if (this.fAttributes.hasAnnotations()) {
            for (DGAttribute attribute : this.fAttributes.getAttributes()) {
                IAnnotationAttribute annotationAttribute;
                if (!(attribute instanceof IAnnotationAttribute) || !(annotationAttribute = (IAnnotationAttribute)((Object)attribute)).containsAnnotation(annotationName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMainMethod() {
        Enumeration e = this.fMethods.elements();
        while (e.hasMoreElements()) {
            DGMethod m = (DGMethod)e.nextElement();
            if (!m.isEntryPoint()) continue;
            return true;
        }
        return false;
    }

    public DGField addNewField(String fieldName, String fieldDesc, int accessFlags) throws DGClassModificationException {
        DGField newField = new DGField(this.fConstantPool, fieldName, fieldDesc, accessFlags);
        this.fFields.addElement(newField);
        this.fLog.ICompilerLog_logFieldInjection(this, fieldName, fieldDesc);
        return newField;
    }

    public DGMethod addNewMethod(String methodName, String methodDesc, int accessFlags) throws DGClassModificationException {
        DGMethod newMethod = new DGMethod(this.fConstantPool, methodName, methodDesc, accessFlags);
        this.fMethods.addElement(newMethod);
        return newMethod;
    }

    public boolean isInstanceOf(IClassName superclassOrInterfaceName) {
        String superClassName;
        if (superclassOrInterfaceName.getContainerAndPackageAndNameString().equals(this.fClassName.getContainerAndPackageAndNameString())) {
            return true;
        }
        int resultFromThreadLocalTest = this.testUsingThreadLocalClass(superclassOrInterfaceName);
        if (resultFromThreadLocalTest != this.kInconclusive) {
            return resultFromThreadLocalTest == this.kIsAssignable;
        }
        String superclassOrInterfaceNameReflectionFriendlyName = superclassOrInterfaceName.getReflectionFriendlyQualifiedNameString();
        if (superclassOrInterfaceNameReflectionFriendlyName.equals(superClassName = this.getSuperClassName().getReflectionFriendlyQualifiedNameString())) {
            return true;
        }
        String[] interfaceNames = this.getInterfaces().getInterfaceNames();
        int i = 0;
        while (i < interfaceNames.length) {
            if (superclassOrInterfaceName.getContainerAndPackageAndNameString().equals(interfaceNames[i])) {
                return true;
            }
            ++i;
        }
        if (kActivateDeepInheritance) {
            Class pivot = ThreadLocalClassHelper.findClass((String)superClassName, (boolean)false);
            if (pivot != null) {
                Set classes = this.getSuperclassAndImplementedInterfaces(pivot);
                for (Class implementedClass : classes) {
                    if (!superclassOrInterfaceNameReflectionFriendlyName.equals(implementedClass.getName())) continue;
                    return true;
                }
            }
            int i2 = 0;
            while (i2 < interfaceNames.length) {
                String interfaceNameReflectionFriendly = interfaceNames[i2].replace('/', '.');
                Class interfaceClass = ThreadLocalClassHelper.findClass((String)interfaceNameReflectionFriendly, (boolean)true);
                if (interfaceClass != null) {
                    Set classes = this.getSuperclassInterfaces(interfaceClass);
                    for (Class implementedClass : classes) {
                        if (!superclassOrInterfaceNameReflectionFriendlyName.equals(implementedClass.getName())) continue;
                        return true;
                    }
                }
                ++i2;
            }
        }
        return false;
    }

    private Set getSuperclassAndImplementedInterfaces(Class pivot) {
        HashSet<Class<Object>> classes = new HashSet<Class<Object>>();
        HashSet<Class> interfaces = new HashSet<Class>();
        while (pivot != null) {
            classes.add(pivot);
            interfaces.addAll(Arrays.asList(pivot.getInterfaces()));
            pivot = pivot.getSuperclass();
        }
        Stack dealtWithInterfaces = new Stack();
        dealtWithInterfaces.addAll(interfaces);
        interfaces.clear();
        while (dealtWithInterfaces.size() > 0) {
            Class myInterface = (Class)dealtWithInterfaces.pop();
            interfaces.add(myInterface);
            Class<?>[] implementedInterfaces = myInterface.getInterfaces();
            int j = 0;
            while (j < implementedInterfaces.length) {
                dealtWithInterfaces.push(implementedInterfaces[j]);
                ++j;
            }
        }
        classes.addAll(interfaces);
        return classes;
    }

    private Set getSuperclassInterfaces(Class pivotInterface) {
        Stack dealtWithInterfaces = new Stack();
        dealtWithInterfaces.add(pivotInterface);
        HashSet<Class> interfaces = new HashSet<Class>();
        while (dealtWithInterfaces.size() > 0) {
            Class myInterface = (Class)dealtWithInterfaces.pop();
            interfaces.add(myInterface);
            Class<?>[] implementedInterfaces = myInterface.getInterfaces();
            int j = 0;
            while (j < implementedInterfaces.length) {
                dealtWithInterfaces.push(implementedInterfaces[j]);
                ++j;
            }
        }
        return interfaces;
    }

    private int testUsingThreadLocalClass(IClassName superclassOrInterfaceName) {
        return this.kInconclusive;
    }

    public String[] getPossibleKeys() {
        return this.fPossibleKeys;
    }

    public void debugDump(PrintWriter log) {
        log.println("*********** Debug dump ************  ");
        log.println("Class: " + this.fClassName.getNameString());
        int i = 0;
        i = 0;
        while (i < this.fMethods.size()) {
            DGMethod method = (DGMethod)this.fMethods.get(i);
            if (method.getCode() != null && method.getCode().isDirty()) {
                log.println();
                method.getCode().debug_showCode(log);
                log.println();
                method.getCode().debug_showStackMapTable(log);
                log.println();
            }
            ++i;
        }
    }

    public boolean isDirty() {
        int i = 0;
        i = 0;
        while (i < this.fMethods.size()) {
            DGMethod method = (DGMethod)this.fMethods.get(i);
            if (method.getCode() != null && method.getCode().isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

