/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.compiler;

import com.wily.diagnos.cmp.batch.ASingleCompiler;
import com.wily.diagnos.cmp.classfile.DGClassException;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.mutate.IClassMutator;
import com.wily.diagnos.personality.java.classfile.DGClass;
import com.wily.util.classfile.IModeledClass;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DGStreamSingleCompiler
extends ASingleCompiler {
    private final InputStream fClassFileStream;
    private final OutputStream fOutputStream;

    public DGStreamSingleCompiler(DGCompilerSettings settings, ICompilerLog log, InputStream classFileStream, OutputStream outputStream, boolean isRedefine, Class<?> classRedefined) {
        super(settings, log, isRedefine, classRedefined);
        this.fClassFileStream = classFileStream;
        this.fOutputStream = outputStream;
    }

    @Override
    protected IModeledClass doNewModeledClass() throws DGClassException, IOException {
        return new DGClass(this.fClassFileStream, this.getLog());
    }

    @Override
    protected IClassMutator doNewMutator(IModeledClass targetClass) throws DGClassException, IOException {
        Assertion.wilyAssert((boolean)(targetClass instanceof DGClass));
        return (DGClass)targetClass;
    }

    @Override
    protected void doCommit(IModeledClass targetClass, IClassMutator mutator) throws DGClassException, IOException {
        Assertion.wilyAssert((boolean)(targetClass instanceof DGClass));
        DGClass javaClass = (DGClass)targetClass;
        javaClass.write(this.fOutputStream);
    }
}

