/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.websphere.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class ClientAsyncResponseTimeTracer
extends ASingleInstanceTracerFactory
implements KConstants {
    protected final IModuleFeedbackChannel logger;

    public ClientAsyncResponseTimeTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public void ITracer_finishTrace(int i, InvocationData data) {
        long stoptime = System.currentTimeMillis();
        long starttime = 0L;
        long crestime = 0L;
        try {
            Object listenerObj = data.getInvocationObject();
            Object handlerObj = WSMUtils.invokeMethodOnObject(listenerObj, "getHandler");
            Map reqctxtobj = (Map)WSMUtils.invokeMethodOnObject(handlerObj, "getRequestContext");
            starttime = (Long)reqctxtobj.get("soa_asynch_client");
            crestime = stoptime - starttime;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("ClientAsyncResponseTimeTracer:crestime" + crestime);
            }
            String component = this.formatParameterizedName(data);
            this.createUpdateCustomMetrics(component, crestime, starttime, stoptime);
        }
        catch (Throwable e) {
            this.logger.error("ClientAsynchResponseTimeTracer:Error in retreiving from request context", e);
        }
    }

    public void ITracer_startTrace(int i, InvocationData invocationdata) {
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    protected void createUpdateCustomMetrics(String metricResourceName, long elapsed, long startTime, long endTime) {
        AgentMetric responseTimeMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(String.valueOf(metricResourceName) + ":" + "Average Response Time (ms)", 1025, "Invalid Names:Invalid name given for an integer duration metric");
        IRepository newResp = BlamePointTracer.getAverageMetricRepository();
        IRepository prevResp = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)AAgentMetricArray.getInstance((AgentMetric)responseTimeMetric), (IRepository)newResp);
        if (prevResp != null) {
            prevResp.update(BlamePointTracer.getUpdater(), elapsed, startTime, endTime);
        } else {
            newResp.update(BlamePointTracer.getUpdater(), elapsed, startTime, endTime);
        }
        AgentMetric responsePerIntervalMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(String.valueOf(metricResourceName) + ":" + "Responses Per Interval", 8194, "Invalid Names:Invalid name given for a long interval counter metric");
        IRepository newPerInt = BlamePointTracer.getCountQueuedRepository((boolean)true);
        IRepository prevPerInt = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)AAgentMetricArray.getInstance((AgentMetric)responsePerIntervalMetric), (IRepository)newPerInt);
        if (prevPerInt != null) {
            prevPerInt.update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
        } else {
            newPerInt.update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
        }
    }
}

