/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.log4j.performance;

import com.wily.org.apache.log4j.Category;
import com.wily.org.apache.log4j.NDC;
import com.wily.org.apache.log4j.xml.DOMConfigurator;

public class Logging {
    static int runLength;
    static int delay;
    static int burstLen;
    static int DELAY_MULT;
    static Category cat;
    static /* synthetic */ Class class$0;

    static {
        delay = -1;
        burstLen = 100;
        DELAY_MULT = 1000 / burstLen;
        cat = Category.getInstance("A0123456789.B0123456789.C0123456789");
    }

    static void Usage(String msg) {
        System.err.println(msg);
        StringBuffer stringBuffer = new StringBuffer("Usage: java ");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.org.apache.log4j.performance.Logging");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.err.println(stringBuffer.append(clazz.getName()).append(" confFile runLength [delay] [burstLen]\n").append("        confFile is an XML configuration file and\n").append("        runLength (integer) is the length of test loop.\n").append("        delay is the time in millisecs to wait every bustLen log requests.").toString());
        System.exit(1);
    }

    public static void main(String[] argv) {
        if (argv.length == 2) {
            Logging.init(argv[0], argv[1], null, null);
        } else if (argv.length == 4) {
            Logging.init(argv[0], argv[1], argv[2], argv[3]);
        } else {
            Logging.Usage("Wrong number of arguments.");
        }
        NDC.push("some context");
        String msg = "ABCDEGHIJKLMNOPQRSTUVWXYZabcdeghijklmnopqrstuvwxyz1234567890";
        double delta = delay <= 0 ? Logging.NoDelayLoop(cat, msg) : Logging.DelayedLoop(cat, msg);
        System.out.print((int)delta);
        Category.shutdown();
    }

    static void init(String configFile, String runLengthStr, String delayStr, String burstLenStr) {
        try {
            runLength = Integer.parseInt(runLengthStr);
            if (delayStr != null) {
                delay = Integer.parseInt(delayStr);
            }
            if (delayStr != null) {
                burstLen = Integer.parseInt(burstLenStr);
                DELAY_MULT = 1000 / burstLen;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        DOMConfigurator.configure(configFile);
    }

    static double NoDelayLoop(Category category, String msg) {
        long before = System.currentTimeMillis();
        int i = 0;
        while (i < runLength) {
            category.info(msg);
            ++i;
        }
        return (double)(System.currentTimeMillis() - before) * 1000.0 / (double)runLength;
    }

    static double DelayedLoop(Category category, String msg) {
        long before = System.currentTimeMillis();
        int j = 0;
        Thread currentThread = Thread.currentThread();
        int i = 0;
        while (i < runLength) {
            category.info(msg);
            if (j++ == burstLen) {
                j = 0;
                try {
                    Thread.sleep(delay);
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        double actualTime = (double)(System.currentTimeMillis() - before) * 1000.0 / (double)runLength;
        System.out.println("actual time: " + actualTime);
        return actualTime - (double)(delay * DELAY_MULT);
    }
}

