/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.pmi;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.webappsupport.AWebAppSupportReflectionDelegatingService;
import com.wily.util.properties.IndexedProperties;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class PMIDelegatingService
extends AWebAppSupportReflectionDelegatingService {
    public static final String kAgentPMIServiceName = "PMI";

    public PMIDelegatingService() {
        super(kAgentPMIServiceName, "com.wily.introscope.agent.pmi.PMIService", PMIDelegatingService.class.getClassLoader());
    }

    @Override
    protected boolean doShouldAttemptDelegateLoad(IAgent agent) {
        Class[] kIsDisabledMethodParameterTypes = new Class[]{};
        boolean result = false;
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        Assertion.wilyAssert((props != null ? 1 : 0) != 0);
        boolean pmiOn = props.getBooleanProperty("introscope.agent.pmi.enable");
        if (pmiOn) {
            try {
                Class<?> pmiRegistryClass = null;
                pmiRegistryClass = Class.forName("com.ibm.ws.pmi.server.PmiRegistry");
                Method isDisabled = pmiRegistryClass.getDeclaredMethod("isDisabled", kIsDisabledMethodParameterTypes);
                if (!Modifier.isStatic(isDisabled.getModifiers())) {
                    NoSuchMethodError problem = new NoSuchMethodError("com.ibm.ws.pmi.server.PmiRegistry.isDisabled");
                    agent.IAgent_safeReportError(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_PMI_PMI_Is_Not_Present_Message"), (Throwable)problem);
                    throw problem;
                }
                Object disabledResult = isDisabled.invoke(null, new Object[0]);
                if (Boolean.valueOf(disabledResult.toString()).booleanValue()) {
                    String message = agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_PMI_PMI_Is_Disabled_Message");
                    Throwable problem = null;
                    agent.IAgent_safeReportWarning(message, problem);
                    agent.IAgent_safeReportWarning(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_PMI_Failed_To_Activate_PMI_Message"), problem);
                    return false;
                }
                return true;
            }
            catch (Throwable t) {
                this.reportFailure(agent, t);
            }
        }
        return result;
    }

    @Override
    protected void doHandleDelegateLoadException(IAgent agent, Throwable t) {
        this.reportFailure(agent, t);
    }

    private void reportFailure(IAgent agent, Throwable t) {
        agent.IAgent_safeReportError(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_PMI_Failed_To_Activate_PMI_Message"), t);
    }
}

