/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter.sampling;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.filter.sampling.DerivativeSamplingResult;
import com.wily.introscope.agent.transactiontrace.ISamplingInput;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.ArrayList;

public abstract class SamplingResult
implements ISamplingResult {
    protected final ISamplingResult.Answer answer;
    private ISamplingResult.Answer answerDetermined;
    private boolean hadMayBe;
    private ArrayList<ISamplingResult.Callback> pendingCallbacks;

    public static final ISamplingResult YES(String byWho) {
        return new ISamplingResult.ConstantSamplingResult(true, byWho);
    }

    protected SamplingResult(ISamplingResult.Answer answer) {
        this.answer = answer;
    }

    @Override
    public final synchronized ISamplingResult.Answer shouldStartSampling() {
        if (this.answerDetermined != null) {
            return this.answerDetermined;
        }
        return this.answer;
    }

    @Override
    public final void determineSampling(ISamplingInput input, final ISamplingResult.Callback callback) {
        ISamplingResult.Callback myCallback = new ISamplingResult.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSamplingDetermined(ISamplingResult.Answer answer) {
                RuntimeException thrown = null;
                SamplingResult samplingResult = SamplingResult.this;
                synchronized (samplingResult) {
                    try {
                        callback.onSamplingDetermined(answer);
                    }
                    catch (RuntimeException e) {
                        thrown = e;
                    }
                    if (answer.choice == ISamplingResult.Choice.MAYBE) {
                        if (SamplingResult.this.hadMayBe) {
                            return;
                        }
                        SamplingResult.this.hadMayBe = true;
                    }
                    try {
                        SamplingResult.this.onSamplingDeterminedByLead(answer);
                    }
                    catch (RuntimeException e) {
                        if (thrown == null) {
                            thrown = e;
                        }
                        SamplingResult.logExecutionException(answer, e);
                    }
                }
                if (thrown != null) {
                    throw thrown;
                }
            }
        };
        if (!input.valid()) {
            SamplingResult.execute(myCallback, ISamplingResult.Answer.create(ISamplingResult.Choice.NO, null));
            return;
        }
        this.determineSamplingInternal(input, myCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addDerivativeCallback(ISamplingResult.Callback callback) {
        ISamplingResult.Answer shouldAnswer;
        SamplingResult samplingResult = this;
        synchronized (samplingResult) {
            if (this.answerDetermined == null) {
                if (this.pendingCallbacks == null) {
                    this.pendingCallbacks = new ArrayList();
                }
                this.pendingCallbacks.add(callback);
                ISamplingResult.Choice choice = this.hadMayBe ? ISamplingResult.Choice.MAYBE : ISamplingResult.Choice.LEAD_IS_NOT_READY;
                callback.onSamplingDetermined(ISamplingResult.Answer.create(choice, null));
                return;
            }
            shouldAnswer = this.answerDetermined;
        }
        SamplingResult.execute(callback, shouldAnswer);
    }

    public static void execute(ISamplingResult.Callback callback, ISamplingResult.Answer answer) {
        try {
            callback.onSamplingDetermined(answer);
        }
        catch (Exception e) {
            SamplingResult.logExecutionException(answer, e);
        }
    }

    private static void logExecutionException(ISamplingResult.Answer answer, Exception e) {
        IAgent agent;
        try {
            agent = AgentShim.getAgent();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return;
        }
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        if (feedback.isDebugEnabled(kSamplingModule)) {
            feedback.debug(kSamplingModule, String.valueOf(answer.byWho == null ? "SamplingResult" : answer.byWho) + " failed to execute " + (Object)((Object)answer.choice) + " callback", e);
        } else {
            feedback.warn(kSamplingModule, String.valueOf(answer.byWho == null ? "SamplingResult" : answer.byWho) + " failed to execute " + (Object)((Object)answer.choice) + " callback: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onSamplingDeterminedByLead(ISamplingResult.Answer answer) {
        ArrayList<ISamplingResult.Callback> arr;
        SamplingResult samplingResult = this;
        synchronized (samplingResult) {
            if (answer.choice != ISamplingResult.Choice.MAYBE) {
                this.answerDetermined = answer;
            }
            arr = this.pendingCallbacks;
            if (this.answerDetermined != null) {
                this.pendingCallbacks = null;
            }
        }
        if (arr == null) {
            return;
        }
        if (arr.size() == 1) {
            arr.get(0).onSamplingDetermined(answer);
            return;
        }
        for (ISamplingResult.Callback callback : arr) {
            SamplingResult.execute(callback, answer);
        }
    }

    protected abstract void determineSamplingInternal(ISamplingInput var1, ISamplingResult.Callback var2);

    @Override
    public ISamplingResult derivativeSamplingResult() {
        return new DerivativeSamplingResult(this);
    }

    @Override
    public boolean isDerivative() {
        return false;
    }
}

