/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedElement;
import com.wily.introscope.agent.trace.cas.IUpdater;
import java.util.concurrent.atomic.AtomicReference;

public class SharedDataStructure
implements IRepository {
    private final AtomicReference<ISharedElement> sharedValue = new AtomicReference();
    private final ISharedElement kInstance;
    private volatile boolean fShutOff = false;

    public SharedDataStructure(ISharedElement instance) {
        this.kInstance = instance;
        this.sharedValue.set(this.kInstance);
    }

    @Override
    public void offer(ISharedElement offered) {
        this.sharedValue.set(offered);
    }

    public String toString() {
        return String.valueOf(Thread.currentThread().getName()) + " value = " + this.sharedValue.get();
    }

    @Override
    public ISharedElement get() {
        ISharedElement tryGet;
        while ((tryGet = (ISharedElement)this.sharedValue.getAndSet(null)) == null) {
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return tryGet;
    }

    @Override
    public void reset() {
        this.sharedValue.set(this.kInstance.getSharedElementInstance());
    }

    @Override
    public ISharedElement read() {
        ISharedElement tryGet = this.get();
        ISharedElement result = tryGet.getSharedElementInstance();
        result.merge(tryGet);
        if (tryGet.shouldBeConsumendOnRead()) {
            tryGet.reset();
        } else {
            tryGet.resetMinMax();
        }
        this.offer(tryGet);
        return result;
    }

    @Override
    public ISharedElement read(ISharedElement result) {
        ISharedElement current = this.read();
        result.merge(current);
        return result;
    }

    public IRepository getInstance(ISharedElement instance) {
        return new SharedDataStructure(instance);
    }

    @Override
    public void update(IUpdater updater, long value, long startTime, int hashcode) {
        ISharedElement element = this.get();
        updater.update(element, value, startTime);
        this.offer(element);
    }

    @Override
    public boolean hasNotChanged() {
        return false;
    }

    @Override
    public boolean shouldBeHarvested() {
        return true;
    }

    @Override
    public void update(IUpdater updater, long value, long startTime, long endTime) {
        this.update(updater, value, startTime, 0);
    }

    @Override
    public ISharedElement read(IRepository.IRepositorySustainabilityCallback callback) {
        return this.read();
    }

    @Override
    public void cleanup(boolean offerBack) {
        if (!offerBack) {
            this.reset();
        }
    }

    @Override
    public void setShutOff(boolean shutOff) {
        this.fShutOff = shutOff;
    }

    @Override
    public boolean isShutOff() {
        return this.fShutOff;
    }
}

