/*
 * Decompiled with CFR 0.152.
 */
package com.wily.net;

import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.net.AgentSocketOutputStream;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.SocketOutputStream;

public final class ManagedSocketOutputStreamAPSIHighPerformanceNew
extends SocketOutputStream {
    private final AgentSocketOutputStream agentSocketOutputStream = new AgentSocketOutputStream();

    public ManagedSocketOutputStreamAPSIHighPerformanceNew(AbstractPlainSocketImpl impl) throws IOException {
        super(impl);
        this.agentSocketOutputStream.setCache(impl.socket);
    }

    public final void write(int b) throws IOException {
        if (this.agentSocketOutputStream.getCache() == null || this.checkWithOverheadMgr()) {
            super.write(b);
            return;
        }
        boolean addedConcurrentWriter = this.agentSocketOutputStream.addToConcurrentWriters("write(int )");
        if (this.agentSocketOutputStream.getCache().isClientConnection()) {
            this.agentSocketOutputStream.annotateBlameStack(this);
            this.agentSocketOutputStream.suggestStackTraceRecording();
        }
        try {
            super.write(b);
            this.agentSocketOutputStream.addToOutputBandwidth(1);
        }
        finally {
            this.agentSocketOutputStream.removeFromConcurrentWriters(addedConcurrentWriter, "write(int )");
        }
    }

    private boolean checkWithOverheadMgr() {
        return OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND == OverheadAdministrator.getOverheadMode() || OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode();
    }

    public final void write(byte[] b) throws IOException {
        if (this.agentSocketOutputStream.getCache() == null || this.checkWithOverheadMgr()) {
            super.write(b);
            return;
        }
        boolean addedConcurrentWriter = this.agentSocketOutputStream.addToConcurrentWriters("write(byte )");
        if (this.agentSocketOutputStream.getCache().isClientConnection()) {
            this.agentSocketOutputStream.annotateBlameStack(this);
            this.agentSocketOutputStream.suggestStackTraceRecording();
        }
        try {
            super.write(b);
            if (b != null) {
                this.agentSocketOutputStream.addToOutputBandwidth(b.length);
            }
        }
        finally {
            this.agentSocketOutputStream.removeFromConcurrentWriters(addedConcurrentWriter, "write(byte )");
        }
    }

    public final void write(byte[] b, int off, int len) throws IOException {
        if (this.agentSocketOutputStream.getCache() == null || this.checkWithOverheadMgr()) {
            super.write(b, off, len);
            return;
        }
        boolean addedConcurrentWriter = this.agentSocketOutputStream.addToConcurrentWriters("write(byte , int , int )");
        if (this.agentSocketOutputStream.getCache().isClientConnection()) {
            this.agentSocketOutputStream.annotateBlameStack(this);
            this.agentSocketOutputStream.suggestStackTraceRecording();
        }
        try {
            super.write(b, off, len);
            if (b != null) {
                this.agentSocketOutputStream.addToOutputBandwidth(len);
            }
        }
        finally {
            this.agentSocketOutputStream.removeFromConcurrentWriters(addedConcurrentWriter, "write(byte , int , int )");
        }
    }
}

