/*
 * Decompiled with CFR 0.152.
 */
package com.wily.net;

import com.wily.introscope.agent.AgentShim;
import com.wily.net.AgentSocketOutputStream;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.SocketOutputStream;

public final class ManagedSocketOutputStreamHighPerformance
extends SocketOutputStream {
    private final AgentSocketOutputStream agentSocketOutputStream = new AgentSocketOutputStream();

    public ManagedSocketOutputStreamHighPerformance(AbstractPlainSocketImpl impl) throws IOException {
        super(impl);
        this.agentSocketOutputStream.setCache(impl.socket);
    }

    public final void write(int b) throws IOException {
        boolean addedConcurrentWriter;
        Object tl;
        block18: {
            if (this.agentSocketOutputStream.getCache() == null) {
                super.write(b);
                return;
            }
            tl = AgentShim.getAgentShimThreadLocal();
            if (AgentShim.isThreadInAgentCode(tl)) {
                super.write(b);
                return;
            }
            addedConcurrentWriter = false;
            try {
                try {
                    AgentShim.setThreadInAgentCode(tl);
                    addedConcurrentWriter = this.agentSocketOutputStream.addToConcurrentWriters("write(int )");
                    if (this.agentSocketOutputStream.getCache().isClientConnection()) {
                        this.agentSocketOutputStream.annotateBlameStack();
                        this.agentSocketOutputStream.suggestStackTraceRecording();
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("Exception preparing write(int) in High Performance Output Stream ", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                    AgentShim.clearThreadInAgentCode(tl);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                AgentShim.clearThreadInAgentCode(tl);
                throw throwable;
            }
            AgentShim.clearThreadInAgentCode(tl);
        }
        try {
            super.write(b);
            AgentShim.setThreadInAgentCode(tl);
            this.agentSocketOutputStream.addToOutputBandwidth(1);
        }
        finally {
            this.agentSocketOutputStream.removeFromConcurrentWriters(addedConcurrentWriter, "write(int )");
            AgentShim.clearThreadInAgentCode(tl);
        }
    }

    public final void write(byte[] b) throws IOException {
        boolean addedConcurrentWriter;
        Object tl;
        block19: {
            if (this.agentSocketOutputStream.getCache() == null) {
                super.write(b);
                return;
            }
            tl = AgentShim.getAgentShimThreadLocal();
            if (AgentShim.isThreadInAgentCode(tl)) {
                super.write(b);
                return;
            }
            addedConcurrentWriter = false;
            try {
                try {
                    AgentShim.setThreadInAgentCode(tl);
                    addedConcurrentWriter = this.agentSocketOutputStream.addToConcurrentWriters("write(byte )");
                    if (this.agentSocketOutputStream.getCache().isClientConnection()) {
                        this.agentSocketOutputStream.annotateBlameStack();
                        this.agentSocketOutputStream.suggestStackTraceRecording();
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("Exception preparing write(byte[]) in High Performance Output Stream ", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                    AgentShim.clearThreadInAgentCode(tl);
                    break block19;
                }
            }
            catch (Throwable throwable) {
                AgentShim.clearThreadInAgentCode(tl);
                throw throwable;
            }
            AgentShim.clearThreadInAgentCode(tl);
        }
        try {
            super.write(b);
            AgentShim.setThreadInAgentCode(tl);
            if (b != null) {
                this.agentSocketOutputStream.addToOutputBandwidth(b.length);
            }
        }
        finally {
            this.agentSocketOutputStream.removeFromConcurrentWriters(addedConcurrentWriter, "write(byte )");
            AgentShim.clearThreadInAgentCode(tl);
        }
    }

    public final void write(byte[] b, int off, int len) throws IOException {
        boolean addedConcurrentWriter;
        Object tl;
        block18: {
            if (this.agentSocketOutputStream.getCache() == null) {
                super.write(b, off, len);
                return;
            }
            tl = AgentShim.getAgentShimThreadLocal();
            if (AgentShim.isThreadInAgentCode(tl)) {
                super.write(b, off, len);
                return;
            }
            addedConcurrentWriter = false;
            try {
                try {
                    AgentShim.setThreadInAgentCode(tl);
                    addedConcurrentWriter = this.agentSocketOutputStream.addToConcurrentWriters("write(byte, int, int)");
                    if (this.agentSocketOutputStream.getCache().isClientConnection()) {
                        this.agentSocketOutputStream.annotateBlameStack();
                        this.agentSocketOutputStream.suggestStackTraceRecording();
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("Exception preparing write(byte[],int,int) in High Performance Output Stream ", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                    AgentShim.clearThreadInAgentCode(tl);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                AgentShim.clearThreadInAgentCode(tl);
                throw throwable;
            }
            AgentShim.clearThreadInAgentCode(tl);
        }
        try {
            super.write(b, off, len);
            AgentShim.setThreadInAgentCode(tl);
            this.agentSocketOutputStream.addToOutputBandwidth(len);
        }
        finally {
            this.agentSocketOutputStream.removeFromConcurrentWriters(addedConcurrentWriter, "write(byte, int, int)");
            AgentShim.clearThreadInAgentCode(tl);
        }
    }
}

