/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.api;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.Utils;
import com.ca.apm.agent.jmxclient.api.BeanConfigElement;
import com.ca.apm.agent.jmxclient.api.BeanConfiguration;
import com.ca.apm.agent.jmxclient.api.JmxCustomBeanConfig;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.wily.introscope.agent.trace.intelligent.Logger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class MixedConfigProvider
implements BeanConfiguration.ConfigProvider {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private final MBeanServerConnection server;
    private final JmxNodeInfo nodeInfo;
    private final BeanConfiguration.ConfigProvider customConfigProvider;
    private final QueryExp queryExp;

    public MixedConfigProvider(BeanConfiguration.ConfigProvider customConfigProvider) {
        this(null, null, ObjectName.WILDCARD, customConfigProvider);
    }

    public MixedConfigProvider(MBeanServerConnection server, JmxNodeInfo nodeInfo, QueryExp queryExp, BeanConfiguration.ConfigProvider customConfigProvider) {
        this.server = server;
        this.nodeInfo = nodeInfo;
        this.queryExp = queryExp;
        this.customConfigProvider = customConfigProvider;
    }

    @Override
    public Map<ObjectName, Map<String, Set<BeanConfigElement>>> getConfig() {
        boolean forceDiscoveryEnabled = Boolean.valueOf(this.nodeInfo.getMetricInfo().getForceDiscoveryEnabled());
        if (!forceDiscoveryEnabled) {
            return this.getConfig(this.loadMBeans());
        }
        return this.getConfig(this.loadJBossMBeans());
    }

    protected Map<ObjectName, Map<String, Set<BeanConfigElement>>> getConfig(Set<ObjectName> names) {
        LOGGER.logDebugMessage("Generating auto configuration");
        if (names.size() == 0) {
            LOGGER.logDebugMessage("Auto Configuration Provider - No Mbeans found that match the query: " + this.queryExp);
        }
        Map<ObjectName, Map<String, Set<BeanConfigElement>>> configElements = this.customConfigProvider.getConfig();
        try {
            for (ObjectName name : names) {
                Object atInfo;
                int n;
                int n2;
                Object[] objectArray;
                LOGGER.logTraceMessage("Object name: " + name);
                Map<String, Set<BeanConfigElement>> atConfigMap = configElements.get(name);
                MBeanInfo beanInfo = this.server.getMBeanInfo(name);
                Object[] atInfos = beanInfo.getAttributes();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.logTraceMessage("Attribute info: " + Arrays.toString(atInfos));
                }
                if (atConfigMap != null) {
                    objectArray = atInfos;
                    n2 = atInfos.length;
                    n = 0;
                    while (n < n2) {
                        atInfo = objectArray[n];
                        Set<BeanConfigElement> atConfigElements = atConfigMap.get(((MBeanFeatureInfo)atInfo).getName());
                        if (atConfigElements == null) {
                            atConfigMap.put(((MBeanFeatureInfo)atInfo).getName(), this.createAutoConfigElementSet(name, (MBeanAttributeInfo)atInfo));
                        }
                        ++n;
                    }
                    continue;
                }
                atConfigMap = new HashMap<String, Set<BeanConfigElement>>();
                objectArray = atInfos;
                n2 = atInfos.length;
                n = 0;
                while (n < n2) {
                    atInfo = objectArray[n];
                    atConfigMap.put(((MBeanFeatureInfo)atInfo).getName(), this.createAutoConfigElementSet(name, (MBeanAttributeInfo)atInfo));
                    ++n;
                }
                JmxCustomBeanConfig customBeanConfig = BeanConfiguration.getCustomBeanConfigLowercaseMap().get(name.getCanonicalName().toLowerCase());
                if (customBeanConfig != null) {
                    customBeanConfig.getCustomConfig(name, atConfigMap, beanInfo);
                }
                configElements.put(name, atConfigMap);
            }
        }
        catch (Exception e) {
            LOGGER.logDebugMessage("Got exception while creating defult configuration for jmx server: " + this.nodeInfo.getHost(), (Throwable)e);
        }
        return configElements;
    }

    protected Set<ObjectName> loadMBeans() {
        LOGGER.logDebugMessage("Auto Configuration Provider - Querying jmx server " + this.nodeInfo.getHost() + " for: " + this.queryExp);
        if (this.queryExp != null) {
            try {
                Set<ObjectName> beans = this.server.queryNames(null, this.queryExp);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebugMessage("Auto Configuration Provider Query result: ");
                }
                for (ObjectName n : beans) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.logDebugMessage(n.toString());
                }
                return beans;
            }
            catch (Throwable e) {
                LOGGER.logDebugMessage("Got exception while loading beans", e);
            }
        }
        return Collections.emptySet();
    }

    protected Set<ObjectName> loadJBossMBeans() {
        LOGGER.logDebugMessage("Auto Configuration Provider - Querying JBoss jmx server " + this.nodeInfo.getHost());
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        try {
            Set<ObjectName> beans = this.server.queryNames(null, null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebugMessage("JBoss Auto Configuration Provider Query result: ");
            }
            String whiteListPatterns = this.nodeInfo.getMetricInfo().getWhiteListPatterns();
            List<String> whiteListFilter = Utils.getObjectNameRegex(whiteListPatterns);
            String blackListPatterns = this.nodeInfo.getMetricInfo().getBlackListPatterns();
            List<String> blackListFilter = Utils.getObjectNameRegex(blackListPatterns);
            for (ObjectName n : beans) {
                boolean matches;
                Matcher matcher;
                Pattern pattern;
                String oname = n.toString();
                for (String filter : whiteListFilter) {
                    pattern = Pattern.compile(filter);
                    matcher = pattern.matcher(oname);
                    matches = matcher.matches();
                    if (!matches) continue;
                    result.add(n);
                }
                for (String filter : blackListFilter) {
                    pattern = Pattern.compile(filter);
                    matcher = pattern.matcher(oname);
                    matches = matcher.matches();
                    if (!matches) continue;
                    result.remove(n);
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.logDebugMessage(n.toString());
            }
            return result;
        }
        catch (Throwable e) {
            LOGGER.logDebugMessage("Got exception while loading beans", e);
            return Collections.emptySet();
        }
    }

    private Set<BeanConfigElement> createAutoConfigElementSet(ObjectName name, MBeanAttributeInfo atInfo) {
        HashSet<BeanConfigElement> elements = new HashSet<BeanConfigElement>();
        BeanConfigElement element = this.createAutoConfigElement(name, atInfo);
        if (element != null) {
            elements.add(element);
        }
        return elements;
    }

    private BeanConfigElement createAutoConfigElement(ObjectName name, MBeanAttributeInfo atInfo) {
        String type = atInfo.getType();
        BeanConfiguration.AttributeValueType attValueType = BeanConfiguration.SUPPORTED_VALUE_TYPES.get(type);
        if (attValueType != null) {
            BeanConfigElement element = new BeanConfigElement(name.getCanonicalName(), atInfo.getName());
            element.setMetricName(Configuration.getDefaultMetricFormat());
            element.setMetricType(attValueType.getDefaultMetricType().name());
            return element;
        }
        return null;
    }
}

