/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.metrics;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.JmxClamp;
import com.ca.apm.agent.jmxclient.metrics.MetricValueListener;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;

public class IntegerIntervalCounterMetric
implements MetricValueListener<Integer> {
    final ILongIntervalCounterDataAccumulator acc;

    public IntegerIntervalCounterMetric(String metricName) {
        JmxClamp clamp = JmxClamp.getInstance(Configuration.getAgent());
        if (!clamp.isClampHit()) {
            clamp.incrementMetricCounter();
            this.acc = Configuration.getAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(metricName);
        } else {
            clamp.printClampWarning();
            this.acc = null;
        }
    }

    @Override
    public void update(Integer value) {
        if (this.acc != null) {
            this.acc.ILongAggregatingDataAccumulator_recordDataPoint((long)value.intValue());
        }
    }

    @Override
    public boolean validate(Object value) {
        return value instanceof Integer;
    }

    @Override
    public void close() {
        if (this.acc != null) {
            JmxClamp.getInstance(Configuration.getAgent()).decrementMetricCounter();
            Configuration.getAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.acc);
        }
    }
}

