/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.metrics;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.JmxClamp;
import com.ca.apm.agent.jmxclient.metrics.MetricValueListener;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;

public class StringMetric
implements MetricValueListener<String> {
    final IStringEveryEventDataAccumulator acc;

    public StringMetric(String metricName) {
        JmxClamp clamp = JmxClamp.getInstance(Configuration.getAgent());
        if (!clamp.isClampHit()) {
            clamp.incrementMetricCounter();
            this.acc = Configuration.getAccumulatorFactory().safeGetStringEveryEventDataAccumulator(metricName);
        } else {
            clamp.printClampWarning();
            this.acc = null;
        }
    }

    @Override
    public void update(String value) {
        if (this.acc != null) {
            this.acc.IStringEveryEventDataAccumulator_addString(String.valueOf(value));
        }
    }

    @Override
    public boolean validate(Object value) {
        return value != null ? value instanceof String : true;
    }

    @Override
    public void close() {
        if (this.acc != null) {
            JmxClamp.getInstance(Configuration.getAgent()).decrementMetricCounter();
            Configuration.getAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.acc);
        }
    }
}

