/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.jms.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.backend.jms.nameformatter.JMSNameFormatter;
import com.wily.util.feedback.Module;

public class JMSProducerNameFormatter
extends JMSNameFormatter {
    private static final Module moduleName = new Module("JMSProducerNameFormatter");

    public JMSProducerNameFormatter(IAgent agent) {
        super(agent);
    }

    @Override
    protected Object getJMSDestination(InvocationData data) {
        Object firstArg = data.getInvocationParameterAsObject(0);
        if (firstArg != null && JMSHelper.isJMSDestinationPassedAsFirstArg(data, feedback)) {
            JMSHelper.debug(moduleName, "The destination was passed as an argumemnt to send()");
            return firstArg;
        }
        String producerDestinationName = JMSHelper.getDestinationNameUsingProducerAPI(data, feedback);
        if (producerDestinationName != null && !"Unknown".equals(producerDestinationName)) {
            return producerDestinationName;
        }
        Object jmsConsumer = data.getInvocationObject();
        Object destinationName = JMSHelper.getDestinationInfoFromSession(jmsConsumer);
        return destinationName;
    }
}

