/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.api;

import com.ca.apm.agent.jmxclient.Utils;
import com.ca.apm.agent.jmxclient.api.SSLSettings;
import java.util.Objects;

public class JmxConnectionInfo {
    private final String url;
    private final String host;
    private final int port;
    private String authUserName;
    private String authPassword;
    private boolean sslEnabled = false;
    private boolean isRegistrySecure = false;
    private SSLSettings sslSettings;

    private JmxConnectionInfo(String url) {
        this.url = url;
        String[] hostPort = Utils.findHostPort(url);
        if (hostPort.length == 2) {
            this.host = Utils.getValidHostName(hostPort[0]);
            this.port = Integer.valueOf(hostPort[1]);
        } else if (hostPort.length == 1) {
            this.host = Utils.getValidHostName(hostPort[0]);
            this.port = 0;
        } else {
            this.host = "unknown";
            this.port = 0;
        }
    }

    private JmxConnectionInfo(String host, int port) {
        this(host, port, "jmxrmi");
    }

    private JmxConnectionInfo(String host, int port, String servicePath) {
        this.host = Utils.getValidHostName(host);
        this.port = port;
        this.url = String.format("service:jmx:rmi:///jndi/rmi://%s:%d/%s", host, port, servicePath);
    }

    public String getUrl() {
        return this.url;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuthUserName() {
        return this.authUserName;
    }

    public void setAuthUserName(String authUserName) {
        this.authUserName = authUserName;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public boolean isRegistrySecure() {
        return this.isRegistrySecure;
    }

    public void setRegistrySecure(boolean isRegistrySecure) {
        this.isRegistrySecure = isRegistrySecure;
    }

    public SSLSettings getSslSettings() {
        return this.sslSettings;
    }

    public void setSslSettings(SSLSettings sslSettings) {
        this.sslSettings = sslSettings;
    }

    public String getHostPort() {
        return Utils.genKey(this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JmxConnectionInfo other = (JmxConnectionInfo)o;
        return Objects.equals(this.getHost(), other.getHost()) && this.getPort() == other.getPort() && Objects.equals(this.getUrl(), other.getUrl()) && Objects.equals(this.getAuthUserName(), other.getAuthUserName()) && Objects.equals(this.getAuthPassword(), other.getAuthPassword()) && this.isSslEnabled() == other.isSslEnabled() && this.isRegistrySecure() == other.isRegistrySecure() && Objects.equals(this.getSslSettings(), other.getSslSettings());
    }

    public int hashCode() {
        return Objects.hash(this.getHost(), this.port, this.getUrl(), this.getAuthUserName(), this.getAuthPassword(), this.isSslEnabled(), this.isRegistrySecure(), this.getSslSettings());
    }

    public String toString() {
        return "host: " + this.host + ", port:" + this.port + ", url: " + this.url + ", ssl: " + this.sslEnabled + ", registrySSL: " + this.isRegistrySecure;
    }

    public static JmxConnectionInfo newInstance(String host, int port) {
        return new JmxConnectionInfo(host, port);
    }

    public static JmxConnectionInfo newInstance(String host) {
        return JmxConnectionInfo.newInstance(host, 1099);
    }

    public static JmxConnectionInfo newInstanceFromUrl(String url) {
        return new JmxConnectionInfo(url);
    }

    public static JmxConnectionInfo newInstance(String host, int port, String servicePath) {
        return new JmxConnectionInfo(host, port, servicePath);
    }
}

