/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.api;

import com.ca.apm.agent.jmxclient.Utils;
import com.ca.apm.agent.jmxclient.api.JmxAtcVertexInfo;
import com.ca.apm.agent.jmxclient.api.JmxConnectionInfo;
import com.ca.apm.agent.jmxclient.api.JmxMetricInfo;
import java.util.Objects;

public class JmxNodeInfo {
    private final String name;
    private final JmxConnectionInfo connInfo;
    private final JmxMetricInfo metricInfo;
    private final JmxAtcVertexInfo vertexInfo;

    public JmxNodeInfo(String host, int port) {
        this("JMX System", host, port);
    }

    public JmxNodeInfo(String name, String host, int port) {
        this(host, port, name, Utils.formatNodeName("JMX|{name} on {host}_{port}", name, host, port), Utils.formatNodeName("{name} on {host}_{port}", name, host, port));
    }

    public JmxNodeInfo(String host, int port, String name, String metricRoot) {
        this(host, port, name, metricRoot, "{name} on {host}_{port}");
    }

    public JmxNodeInfo(String host, int port, String name, String metricRoot, String atcVertexName) {
        this.name = name;
        this.connInfo = JmxConnectionInfo.newInstance(host, port);
        String metricNodeName = Utils.formatNodeName(metricRoot, this.name, this.connInfo.getHost(), this.connInfo.getPort());
        this.metricInfo = new JmxMetricInfo(metricNodeName, "*:*", "");
        this.vertexInfo = new JmxAtcVertexInfo(atcVertexName);
    }

    public JmxNodeInfo(String name, JmxConnectionInfo connInfo, JmxMetricInfo metricInfo) {
        this(name, connInfo, metricInfo, new JmxAtcVertexInfo(Utils.formatNodeName("{name} on {host}_{port}", name, connInfo.getHost(), connInfo.getPort())));
    }

    public JmxNodeInfo(String name, JmxConnectionInfo connInfo, JmxMetricInfo metricInfo, JmxAtcVertexInfo vertexInfo) {
        this.name = name;
        this.connInfo = connInfo;
        this.metricInfo = metricInfo;
        this.vertexInfo = vertexInfo;
    }

    public JmxNodeInfo(JmxConnectionInfo connInfo, JmxMetricInfo metricInfo) {
        this("JMX System", connInfo, metricInfo);
    }

    public JmxConnectionInfo getConnInfo() {
        return this.connInfo;
    }

    public JmxMetricInfo getMetricInfo() {
        return this.metricInfo;
    }

    public JmxAtcVertexInfo getAtcVertexInfo() {
        return this.vertexInfo;
    }

    public String getHost() {
        return this.getConnInfo().getHost();
    }

    public int getPort() {
        return this.getConnInfo().getPort();
    }

    public String getMetricRoot() {
        return this.getMetricInfo().getMetricRoot();
    }

    public String getSystemName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JmxNodeInfo other = (JmxNodeInfo)o;
        return Objects.equals(this.getConnInfo(), other.getConnInfo()) && Objects.equals(this.getMetricInfo(), other.getMetricInfo()) && Objects.equals(this.getAtcVertexInfo(), other.getAtcVertexInfo());
    }

    public int hashCode() {
        return Objects.hash(this.getHost(), this.getPort());
    }

    public String getHostPort() {
        return "host - " + this.getHost() + ", port - " + this.getPort();
    }

    public String toString() {
        return "{name: " + this.name + ", connection info: " + this.connInfo + ", metric root path: " + this.getMetricRoot() + "}";
    }

    public String detail() {
        return "{name: " + this.name + ", connection info: " + this.connInfo + ", metricInfo: " + this.metricInfo + "}";
    }
}

