/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.metrics;

import com.ca.apm.agent.jmxclient.metrics.BooleanMetric;
import com.ca.apm.agent.jmxclient.metrics.FluctuatingCounterMetric;
import com.ca.apm.agent.jmxclient.metrics.IntervalCounterMetric;
import com.ca.apm.agent.jmxclient.metrics.MetricValueListener;
import com.ca.apm.agent.jmxclient.metrics.MetricValueTransformer;
import com.ca.apm.agent.jmxclient.metrics.RateMetric;
import com.ca.apm.agent.jmxclient.metrics.StringMetric;
import com.ca.apm.agent.jmxclient.metrics.ValueAdaptor;

public class ListenerFactoriesRepo {
    public static final MetricValueListenerFactory<Number> PER_INTERVAL_COUNTER_FACTORY = new PerIntervalCounterMetricFactory<Number>(Number.class);
    public static final MetricValueListenerFactory<Number> FLUCTUATING_COUNTER_FACTORY = new FluctuatingCounterMetricFactory<Number>(Number.class);
    public static final MetricValueListenerFactory<Number> RATE_FACTORY = new RateMetricFactory<Number>(Number.class);
    public static final MetricValueListenerFactory<String> STRING_FACTORY = new StringMetricFactory(String.class);
    public static final MetricValueListenerFactory<Boolean> BOOLEAN_FACTORY = new BooleanMetricFactory(Boolean.class);
    public static final AdaptorFactory<Number, Number> NUMERIC_OP_ADAPTOR_FACTORY = new AdaptorFactory();
    public static final AdaptorFactory<?, Number> GENERIC_ADAPTOR_FACTORY = new AdaptorFactory();

    public static class AdaptorFactory<T, R> {
        public MetricValueListener<T> createMetricListener(MetricValueTransformer<T, R> transformer, MetricValueListener<R> listener) {
            return new ValueAdaptor<T, R>(transformer, listener);
        }
    }

    static abstract class BaseCounterMetricFactory<T extends Number>
    extends BaseMetricFactory<T> {
        public BaseCounterMetricFactory(Class<T> cls) {
            super(cls);
        }
    }

    static abstract class BaseMetricFactory<T>
    implements MetricValueListenerFactory<T> {
        private Class<T> cls;

        public BaseMetricFactory(Class<T> cls) {
            this.cls = cls;
        }

        @Override
        public boolean isSupportedType(Class<?> cls2) {
            return this.cls.isAssignableFrom(cls2);
        }
    }

    static class BooleanMetricFactory<R>
    extends BaseMetricFactory<Boolean> {
        public BooleanMetricFactory(Class<Boolean> cls) {
            super(cls);
        }

        @Override
        public MetricValueListener<Boolean> createMetricListener(String metricName) {
            return new BooleanMetric(metricName);
        }
    }

    static class FluctuatingCounterMetricFactory<T extends Number>
    extends BaseCounterMetricFactory<T> {
        FluctuatingCounterMetricFactory(Class<T> cls) {
            super(cls);
        }

        @Override
        public MetricValueListener<T> createMetricListener(String metricName) {
            return new FluctuatingCounterMetric(metricName);
        }
    }

    public static interface MetricValueListenerFactory<T> {
        public MetricValueListener<T> createMetricListener(String var1);

        public boolean isSupportedType(Class<?> var1);
    }

    static class PerIntervalCounterMetricFactory<T extends Number>
    extends BaseCounterMetricFactory<T> {
        PerIntervalCounterMetricFactory(Class<T> cls) {
            super(cls);
        }

        @Override
        public MetricValueListener<T> createMetricListener(String metricName) {
            return new IntervalCounterMetric(metricName);
        }
    }

    static class RateMetricFactory<T extends Number>
    extends BaseCounterMetricFactory<T> {
        RateMetricFactory(Class<T> cls) {
            super(cls);
        }

        @Override
        public MetricValueListener<T> createMetricListener(String metricName) {
            return new RateMetric(metricName);
        }
    }

    static class StringMetricFactory<R>
    extends BaseMetricFactory<String> {
        public StringMetricFactory(Class<String> cls) {
            super(cls);
        }

        @Override
        public MetricValueListener<String> createMetricListener(String metricName) {
            return new StringMetric(metricName);
        }
    }
}

