/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.sqlagent.SQLTokenizer;
import com.wily.introscope.agent.sqlagent.StatementToSQLMappingTracer;
import com.wily.introscope.agent.trace.ISqlNormalizer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.install.KIntroscopeConfigConstants;
import com.wily.util.WilyStringBuilder;
import com.wily.util.adt.CanonicalObjectPool;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationPropertySet;
import com.wily.util.properties.hot.StringSetConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

final class StatementNormalizer {
    private static final char kWildCardChar = '?';
    private static final String kTruncatedSQLSuffix = "...";
    private static final char kSeparatorReplacementChar = '_';
    private static final String kElidedSetOfWildCards = "(?, ?, ...)";
    private static final int kWildCardElidingThreshold = 3;
    private static final String kSavepoint = "SAVEPOINT";
    private static final String kNormalizedSavepoint = "SAVEPOINT ?";
    private static final String kRollbackTo = "ROLLBACK TO";
    private static final String kNormalizedRollbackTo = "ROLLBACK TO ?";
    private static final String kReleaseSavepoint = "RELEASE SAVEPOINT";
    private static final String kNormalizedReleaseSavepoint = "RELEASE SAVEPOINT ?";
    private static IAgent fAgent;
    private static volatile String sSqlNormalizerName;
    private static ISqlNormalizer fSqlNormalizer;
    public static final String kSqlNormalizerKey = "sqlnormalizer";
    public static final int kCurrentSqlNormalizerPluginVersion = 1;
    private static int fSqlNormalizerErrorCount;
    private static int fSqlNormalizerNullCount;
    private static int kSqlNormalizerErrorThreshold;
    private static boolean fRunPredefinedScheme;
    private static boolean isUsingOldConfig;
    private static final Module kModule;
    private static volatile boolean clearSqlCache;
    private static final ConcurrentHashMap sRegexGroupKeys;
    private static IGuaranteedCounter fSQLStmtCounter;
    private static final Set<String> fSQLStmtSet;
    private static int fSQLStmtClamp;
    private static ThreadLocal TokenizerThreadLocal;

    private StatementNormalizer() {
    }

    private static void safeRegisterSqlNormalizerExtension() {
        if (sSqlNormalizerName != null) {
            fAgent.IAgent_getModuleFeedback().info("Statement Normalizer: Trying to load sql normalizer extension with name " + sSqlNormalizerName);
            fSqlNormalizer = StatementNormalizer.registerSqlNormalizerExtension(fAgent);
            if (fSqlNormalizer != null) {
                fAgent.IAgent_getModuleFeedback().info("Statement Normalizer: registered the sql normalizer extension " + sSqlNormalizerName);
            } else {
                fAgent.IAgent_getModuleFeedback().info("Statement Normalizer: No sql normalizer extensions were found with the name " + sSqlNormalizerName + " , falling back to the preconfigured normalization scheme ");
            }
        } else {
            fAgent.IAgent_getModuleFeedback().info("Statement Normalizer: No sql normalizer extension was configured in the properties, falling back to the preconfigured normalization scheme ");
        }
    }

    private static void clearSqlNormalizerCache() {
        StatementToSQLMappingTracer.clearRawToNormalizeCache();
        if (!isUsingOldConfig) {
            WilyTransactionStructure.getInstance().ageFeatureDataImmediately(1);
        }
    }

    private static void initializeNormalizerExtension(IAgent agent) {
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        cm.add(new ConfigurationProperty("introscope.agent.sqlagent.normalizer.extension", null, "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer){

            public final void set(Object value) {
                String sNormalizerExtensionName = (String)value;
                if (sNormalizerExtensionName != null && sNormalizerExtensionName.trim().length() > 0) {
                    sNormalizerExtensionName = sNormalizerExtensionName.trim();
                    if (sSqlNormalizerName == null) {
                        fSqlNormalizerErrorCount = 0;
                        fSqlNormalizerNullCount = 0;
                        sSqlNormalizerName = sNormalizerExtensionName;
                        StatementNormalizer.safeRegisterSqlNormalizerExtension();
                        clearSqlCache = true;
                    } else if (!sNormalizerExtensionName.equalsIgnoreCase(sSqlNormalizerName)) {
                        fSqlNormalizerErrorCount = 0;
                        fSqlNormalizerNullCount = 0;
                        sSqlNormalizerName = sNormalizerExtensionName;
                        StatementNormalizer.safeRegisterSqlNormalizerExtension();
                        clearSqlCache = true;
                    }
                } else {
                    if (sSqlNormalizerName != null) {
                        fAgent.IAgent_getModuleFeedback().info("Statement Normalizer: extension is now disabled falling back to the preconfigured normalization scheme ");
                        clearSqlCache = true;
                    }
                    fSqlNormalizer = null;
                    sSqlNormalizerName = null;
                }
                if (clearSqlCache) {
                    StatementNormalizer.clearSqlNormalizerCache();
                    clearSqlCache = false;
                }
            }
        });
    }

    private static ISqlNormalizer registerSqlNormalizerExtension(IAgent agent) {
        try {
            ExtensionAdministrator extensionAdministrator = agent.IAgent_getExtensionAdministrator();
            Assertion.wilyAssert((boolean)false);
            IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kSqlNormalizerKey);
            for (int i = 0; i < plugins.length; ++i) {
                if (!plugins[i].IPlugin_getName().equalsIgnoreCase(sSqlNormalizerName)) continue;
                Class nameFormatterClass = ExtensionUtilities.loadEntryPointClass((IModuleFeedbackChannel)agent.IAgent_getModuleFeedback(), (IStringLocalizer)agent.IAgent_getStringLocalizer(), (IPlugin)plugins[i], (int)1, ISqlNormalizer.class);
                if (nameFormatterClass == null) {
                    return null;
                }
                return (ISqlNormalizer)nameFormatterClass.newInstance();
            }
        }
        catch (InstantiationException e) {
            agent.IAgent_getModuleFeedback().error("Statement Normalizer: unable to instantiate normalizer plugin extension " + e.getMessage());
            agent.IAgent_getModuleFeedback().debug((Throwable)e);
        }
        catch (IllegalAccessException e) {
            agent.IAgent_getModuleFeedback().error("Statement Normalizer: unable to instantiate normalizer plugin extension " + e.getMessage());
            agent.IAgent_getModuleFeedback().debug((Throwable)e);
        }
        return null;
    }

    private static String normalizeSQLWithExtension(String sql, int maxNormalizedLength) {
        block9: {
            try {
                String normalizedSQL = null;
                if (fRunPredefinedScheme) {
                    normalizedSQL = StatementNormalizer.normalizeSQLInternal(sql, maxNormalizedLength);
                    normalizedSQL = fSqlNormalizer.normalize(normalizedSQL, maxNormalizedLength);
                } else {
                    normalizedSQL = fSqlNormalizer.normalize(sql, maxNormalizedLength);
                }
                if (normalizedSQL != null && normalizedSQL.length() > 0) {
                    return normalizedSQL;
                }
                if (fSqlNormalizerNullCount < kSqlNormalizerErrorThreshold) {
                    fAgent.IAgent_getModuleFeedback().info("Statement Normalizer: extension could not normalize the sql, using the preconfigured normalization scheme");
                    fAgent.IAgent_getModuleFeedback().debug("Statement Normalizer: extension returned an empty/null sql for sql " + sql);
                    if (++fSqlNormalizerNullCount >= kSqlNormalizerErrorThreshold) {
                        fAgent.IAgent_getModuleFeedback().info("Statement Normalizer: number of times the extension returned null has hit clamp limit. Further failures will not be logged");
                    }
                }
            }
            catch (Exception e) {
                WilyStringBuilder errorMessage = new WilyStringBuilder("Statement Normalizer: extension ");
                errorMessage.append(sSqlNormalizerName).append(" threw an exception ").append(e.getMessage());
                fAgent.IAgent_getModuleFeedback().error(errorMessage.toString());
                fAgent.IAgent_getModuleFeedback().debug((Throwable)e);
                fAgent.IAgent_getModuleFeedback().info("Statement Normalizer: will use the preconfigured normalization scheme");
                if (++fSqlNormalizerErrorCount >= kSqlNormalizerErrorThreshold) {
                    fAgent.IAgent_getModuleFeedback().info("Statement Normalizer: number of times the extension  threw exceptions has hit the clamp. Extension " + sSqlNormalizerName + " is now disabled");
                }
            }
            catch (NoClassDefFoundError e) {
                fAgent.IAgent_getModuleFeedback().error("Statement Normalizer: extension " + sSqlNormalizerName + " threw an NoClassDefFoundError for " + e.getMessage());
                fAgent.IAgent_getModuleFeedback().debug((Throwable)e);
                fAgent.IAgent_getModuleFeedback().info("Statement Normalizer: will use the preconfigured normalization scheme");
                if (++fSqlNormalizerErrorCount != kSqlNormalizerErrorThreshold) break block9;
                fAgent.IAgent_getModuleFeedback().info("Statement Normalizer: number of times the extension  threw exceptions has hit the clamp. Extension " + sSqlNormalizerName + " is now disabled");
            }
        }
        return null;
    }

    public static String normalizeSQLInternal(String sql, int maxNormalizedLength) {
        String result;
        SQLTokenizer tokenizer = (SQLTokenizer)TokenizerThreadLocal.get();
        tokenizer.initialize(sql);
        WilyStringBuilder buffer = new WilyStringBuilder(maxNormalizedLength);
        int lastTokenType = -1;
        boolean allWildCards = false;
        int insideParens = 0;
        int startParenPos = -1;
        int runOfWildCards = 0;
        int wordsCount = 0;
        int tokenType = -1;
        while ((tokenType = tokenizer.getNextTokenType()) != 4) {
            switch (tokenType) {
                case 10: {
                    StatementNormalizer.addSpaceIfNeeded(buffer, lastTokenType);
                    if (++insideParens == 1) {
                        runOfWildCards = 0;
                        startParenPos = buffer.length();
                        allWildCards = true;
                        wordsCount = 0;
                    } else if (insideParens == 2 && wordsCount > 0) {
                        runOfWildCards = 0;
                        startParenPos = buffer.length();
                        allWildCards = true;
                    }
                    buffer.append('(');
                    break;
                }
                case 11: {
                    buffer.append(')');
                    if (--insideParens == 0) {
                        if (allWildCards && runOfWildCards >= 3) {
                            buffer.setLength(startParenPos);
                            buffer.append(kElidedSetOfWildCards);
                        }
                        allWildCards = false;
                        runOfWildCards = 0;
                        break;
                    }
                    if (insideParens == 1 && wordsCount > 0) {
                        if (allWildCards && runOfWildCards >= 3) {
                            buffer.setLength(startParenPos);
                            buffer.append(kElidedSetOfWildCards);
                        }
                        allWildCards = false;
                        runOfWildCards = 0;
                        wordsCount = 0;
                        break;
                    }
                    if (insideParens >= 0) break;
                    insideParens = Integer.MIN_VALUE;
                    break;
                }
                case 2: 
                case 3: {
                    ++runOfWildCards;
                    StatementNormalizer.addSpaceIfNeeded(buffer, lastTokenType);
                    buffer.append('?');
                    break;
                }
                case 1: {
                    allWildCards = false;
                    StatementNormalizer.addSpaceIfNeeded(buffer, lastTokenType);
                    tokenizer.appendCurrentTextToBuffer(buffer);
                    if (insideParens != 1) break;
                    ++wordsCount;
                    break;
                }
                case 13: {
                    buffer.append(',');
                    break;
                }
                case 12: {
                    ++runOfWildCards;
                    StatementNormalizer.addSpaceIfNeeded(buffer, lastTokenType);
                    buffer.append('?');
                    break;
                }
                case 14: 
                case 15: {
                    allWildCards = false;
                    StatementNormalizer.addSpaceIfNeeded(buffer, lastTokenType);
                    buffer.append('_');
                    break;
                }
                default: {
                    allWildCards = false;
                    StatementNormalizer.addSpaceIfNeeded(buffer, lastTokenType);
                    buffer.append(tokenizer.getCurrentCharacter());
                }
            }
            if (maxNormalizedLength >= 1 && buffer.length() >= maxNormalizedLength) {
                if (insideParens > 0 && allWildCards && runOfWildCards >= 3) {
                    buffer.setLength(startParenPos);
                    buffer.append(kElidedSetOfWildCards);
                    break;
                }
                buffer.setLength(maxNormalizedLength);
                buffer.append(kTruncatedSQLSuffix);
                break;
            }
            lastTokenType = tokenType;
        }
        if ((result = buffer.toString()).startsWith(kSavepoint)) {
            result = kNormalizedSavepoint;
        } else if (result.startsWith(kRollbackTo)) {
            result = kNormalizedRollbackTo;
        } else if (result.startsWith(kReleaseSavepoint)) {
            result = kNormalizedReleaseSavepoint;
        }
        if ("".equals(result)) {
            if (fSqlNormalizerNullCount < kSqlNormalizerErrorThreshold) {
                fAgent.IAgent_getModuleFeedback().info("Statement Normalizer returned an empty sql for sql " + sql);
                if (++fSqlNormalizerNullCount >= kSqlNormalizerErrorThreshold) {
                    fAgent.IAgent_getModuleFeedback().info("Statement Normalizer: number of times returned empty has hit clamp limit. Further failures will not be logged");
                }
            }
            result = "EMPTY SQL";
        }
        return result;
    }

    private static void addSpaceIfNeeded(WilyStringBuilder buffer, int lastTokenType) {
        if (lastTokenType != -1 && lastTokenType != 10 && lastTokenType != 16) {
            buffer.append(' ');
        }
    }

    public static String normalizeSQL(String sql, int maxNormalizedLength) {
        if (sql == null) {
            return "null";
        }
        String result = null;
        if (fSqlNormalizer != null && fSqlNormalizerErrorCount < kSqlNormalizerErrorThreshold) {
            result = StatementNormalizer.normalizeSQLWithExtension(sql, maxNormalizedLength);
        }
        if (result == null) {
            result = StatementNormalizer.normalizeSQLInternal(sql, maxNormalizedLength);
        }
        if (result != null) {
            result = CanonicalObjectPool.getCanonicalString((String)result);
        }
        if (fSQLStmtSet.contains(result)) {
            return result;
        }
        return StatementNormalizer.getNormalizedStringForStatementClamp(result);
    }

    public static String normalizeSQLForUserView(String sql, String normalizedSqlForMetricName, int maxNormalizedLength) {
        String result = null;
        result = fSqlNormalizer != null && fSqlNormalizerErrorCount < kSqlNormalizerErrorThreshold ? StatementNormalizer.normalizeSQLInternal(sql, maxNormalizedLength) : (normalizedSqlForMetricName != null ? normalizedSqlForMetricName : StatementNormalizer.normalizeSQLInternal(sql, maxNormalizedLength));
        if (result != null) {
            result = CanonicalObjectPool.getCanonicalString((String)result);
        }
        return result;
    }

    private static boolean checkSQLStmtClamp() {
        int metricCount;
        if (fSQLStmtClamp > 0 && (metricCount = fSQLStmtCounter.next()) >= fSQLStmtClamp) {
            if (metricCount == fSQLStmtClamp) {
                fAgent.IAgent_getModuleFeedback().warn("Absolute metric clamp of " + fSQLStmtClamp + " reached, no more new SQL metrics can be created. All metrics will be reported under the default bucket. If you wish to increase the clamp value, change the property - introscope.agent.sqlagent.statement.clamp");
                return true;
            }
            fSQLStmtCounter.prev();
            return false;
        }
        return true;
    }

    private static String getNormalizedStringForStatementClamp(String normalizedSQL) {
        String result = normalizedSQL;
        boolean isNewlyAdded = false;
        if (!StatementNormalizer.checkSQLStmtClamp()) {
            result = "Default";
            isNewlyAdded = fSQLStmtSet.add(result);
            if (isNewlyAdded) {
                SustainabilityMetricsHelper.reportSQLStatementNodesCreated((int)fSQLStmtSet.size());
            }
        } else {
            isNewlyAdded = fSQLStmtSet.add(result);
            if (isNewlyAdded) {
                SustainabilityMetricsHelper.reportSQLStatementNodesCreated((int)fSQLStmtSet.size());
            } else {
                fSQLStmtCounter.prev();
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Normalizing text from stdin, one line at a time:");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String line = in.readLine();
        while (line != null) {
            System.out.println(StatementNormalizer.normalizeSQL(line, 1000));
            line = in.readLine();
        }
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return new SetFromMap<E>(map);
    }

    static {
        fSqlNormalizerErrorCount = 0;
        fSqlNormalizerNullCount = 0;
        kSqlNormalizerErrorThreshold = 5;
        fRunPredefinedScheme = true;
        isUsingOldConfig = false;
        kModule = new Module("StatementNormalizer");
        clearSqlCache = false;
        sRegexGroupKeys = new ConcurrentHashMap();
        fSQLStmtSet = StatementNormalizer.newSetFromMap(new ConcurrentHashMap());
        fSQLStmtClamp = -1;
        TokenizerThreadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new SQLTokenizer();
            }
        };
        try {
            fAgent = AgentShim.getAgent();
            isUsingOldConfig = fAgent.IAgent_getComponentTracer().isAgentOldMode();
            kSqlNormalizerErrorThreshold = SQLAgentConfiguration.getInstance(fAgent).getNormalizerExtensionErrorCount();
            fRunPredefinedScheme = SQLAgentConfiguration.getInstance(fAgent).getNormalizerExtensionRunPredefinedScheme();
            StatementNormalizer.initializeNormalizerExtension(fAgent);
            fSQLStmtCounter = fAgent.IAgent_getGuaranteedCounter();
            fAgent.IAgent_getConfigurationManager().add((ConfigurationProperty)new RegexGroupKeysConfigurationProperty(fAgent));
            fAgent.IAgent_getConfigurationManager().add((ConfigurationProperty)new RegexMatchFallThroughConfigurationProperty(fAgent));
            fAgent.IAgent_getConfigurationManager().add(new ConfigurationProperty("introscope.agent.sqlagent.statement.clamp", "100", "Hot_Property_Configuration_Property", null, true, false, fAgent.IAgent_getModuleFeedback(), fAgent.IAgent_getModule(), fAgent.IAgent_getStringLocalizer()){

                public final void set(Object value) {
                    fSQLStmtClamp = Integer.parseInt((String)value);
                }
            });
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
        }
        catch (Exception e) {
            fAgent.IAgent_getModuleFeedback().error("Statement Normalizer: caught exception " + e.getMessage() + " while trying to load normalizer extension, falling back to the preconfigured normalization scheme  ");
            fAgent.IAgent_getModuleFeedback().debug((Throwable)e);
        }
        catch (UnsupportedClassVersionError err) {
            fAgent.IAgent_getModuleFeedback().error("Statement Normalizer: caught java.lang.UnsupportedClassVersionError for class " + err.getMessage() + " while trying to load normalizer extension, falling back to the preconfigured normalization scheme  ");
            fAgent.IAgent_getModuleFeedback().debug((Throwable)err);
        }
    }

    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Set<E>,
    Serializable {
        private final Map<E, Boolean> m;
        private transient Set<E> s;
        private static final long serialVersionUID = 2454657854757543876L;

        SetFromMap(Map<E, Boolean> map) {
            if (!map.isEmpty()) {
                throw new IllegalArgumentException("Map is non-empty");
            }
            this.m = map;
            this.s = map.keySet();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        @Override
        public boolean add(E e) {
            return this.m.put(e, Boolean.TRUE) == null;
        }

        @Override
        public Iterator<E> iterator() {
            return this.s.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.s.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.s.toArray(a);
        }

        @Override
        public String toString() {
            return this.s.toString();
        }

        @Override
        public int hashCode() {
            return this.s.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.s.equals(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.s.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.s.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.s.retainAll(c);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.s = this.m.keySet();
        }
    }

    private static final class RegexGroupKeysConfigurationProperty
    extends StringSetConfigurationProperty {
        private static volatile boolean clearSqlCache = false;
        private static volatile boolean init = true;

        public RegexGroupKeysConfigurationProperty(IAgent agent) {
            super("introscope.agent.sqlagent.normalizer.regex.keys", new HashSet(), "Hot_Property_Configuration_Property", null, true, true, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public final void set(Object value) {
            clearSqlCache = true;
            if (value != null) {
                Set regexKeys = (Set)value;
                String[] values = regexKeys.toArray(new String[0]);
                String prefix = "introscope.agent.sqlagent.normalizer.regex.";
                for (int i = 0; i < values.length; ++i) {
                    if (sRegexGroupKeys.containsKey(values[i])) continue;
                    ConfigurationPropertySet regexGroupKeyConfigPropertySet = new ConfigurationPropertySet(){

                        public void set() {
                            if (clearSqlCache && !init) {
                                StatementNormalizer.clearSqlNormalizerCache();
                                clearSqlCache = false;
                            }
                        }
                    };
                    String prefixWithKey = prefix + values[i].trim() + ".";
                    String keyWithPattern = prefixWithKey + "pattern";
                    regexGroupKeyConfigPropertySet.add(new ConfigurationProperty(keyWithPattern, null, "Hot_Property_Configuration_Property", null, true, true, fAgent.IAgent_getModuleFeedback(), kModule, fAgent.IAgent_getStringLocalizer()){

                        public void set(Object newValue) {
                            clearSqlCache = true;
                        }
                    });
                    String keyWithReplaceFormat = prefixWithKey + "replaceFormat";
                    regexGroupKeyConfigPropertySet.add(new ConfigurationProperty(keyWithReplaceFormat, null, "Hot_Property_Configuration_Property", null, true, true, fAgent.IAgent_getModuleFeedback(), kModule, fAgent.IAgent_getStringLocalizer()){

                        public void set(Object newValue) {
                            clearSqlCache = true;
                        }
                    });
                    String keyWithReplaceAll = prefixWithKey + "replaceAll";
                    regexGroupKeyConfigPropertySet.add((ConfigurationProperty)new BooleanConfigurationProperty(keyWithReplaceAll, KIntroscopeConfigConstants.kSQLAgentDefaultRegexReplaceAll, fAgent.IAgent_getModuleFeedback(), kModule, fAgent.IAgent_getStringLocalizer()){

                        public Object convert(String s) {
                            if (s == null || s.compareToIgnoreCase("true") != 0 && s.compareToIgnoreCase("false") != 0) {
                                return Boolean.FALSE;
                            }
                            return Boolean.valueOf(s);
                        }

                        public void set(Object newValue) {
                            clearSqlCache = true;
                        }
                    });
                    String keyWithCaseSensitive = prefixWithKey + "caseSensitive";
                    regexGroupKeyConfigPropertySet.add((ConfigurationProperty)new BooleanConfigurationProperty(keyWithCaseSensitive, KIntroscopeConfigConstants.kSQLAgentDefaultRegexCaseSensitive, fAgent.IAgent_getModuleFeedback(), kModule, fAgent.IAgent_getStringLocalizer()){

                        public Object convert(String s) {
                            if (s == null || s.compareToIgnoreCase("true") != 0 && s.compareToIgnoreCase("false") != 0) {
                                return Boolean.FALSE;
                            }
                            return Boolean.valueOf(s);
                        }

                        public void set(Object newValue) {
                            clearSqlCache = true;
                        }
                    });
                    sRegexGroupKeys.put(values[i], regexGroupKeyConfigPropertySet);
                    fAgent.IAgent_getConfigurationManager().add(regexGroupKeyConfigPropertySet, true);
                }
                if (sRegexGroupKeys.size() == values.length) {
                    init = false;
                }
                if (sRegexGroupKeys.size() != values.length) {
                    init = false;
                    Iterator iter = sRegexGroupKeys.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        if (regexKeys.contains(entry.getKey())) continue;
                        fAgent.IAgent_getConfigurationManager().remove((ConfigurationPropertySet)entry.getValue(), true);
                        iter.remove();
                    }
                }
            }
        }
    }

    private static final class RegexMatchFallThroughConfigurationProperty
    extends BooleanConfigurationProperty {
        private volatile boolean bOldValue = false;

        private RegexMatchFallThroughConfigurationProperty(IAgent agent) {
            super("introscope.agent.sqlagent.normalizer.regex.matchFallThrough", KIntroscopeConfigConstants.kSQLAgentDefaultRegexMatchFallThrough, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public Object convert(String s) {
            if (s == null || s.compareToIgnoreCase("true") != 0 && s.compareToIgnoreCase("false") != 0) {
                return Boolean.FALSE;
            }
            return Boolean.valueOf(s);
        }

        public void set(Object newValue) {
            boolean bNewValue = (Boolean)newValue;
            if (this.bOldValue != bNewValue) {
                StatementNormalizer.clearSqlNormalizerCache();
            }
            this.bOldValue = bNewValue;
        }
    }
}

