/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sustainability;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IEventListener;
import com.wily.introscope.agent.IOverheadManager;
import com.wily.introscope.agent.extension.OptionalExtensionsIncludeConfiguration;
import com.wily.introscope.agent.hardware.stats.ComputeUnit;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.introscope.agent.stat.IIntegerConstantDataAccumulator;
import com.wily.introscope.agent.stat.ILongConstantDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;
import com.wily.introscope.agent.sustainability.ISustainabilityMetricsCallback;
import com.wily.introscope.agent.sustainability.ISustainabilityReportLogger;
import com.wily.introscope.agent.sustainability.ISustainabilityService;
import com.wily.introscope.agent.sustainability.ISustainabilityServiceTrace;
import com.wily.introscope.agent.sustainability.ProbeInfoOverheadInfo;
import com.wily.introscope.agent.sustainability.SustainabilityReportEntry;
import com.wily.introscope.agent.sustainability.SustainabilityReportLogger;
import com.wily.introscope.agent.sustainability.SustainabilityServiceTrace;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.agent.transformer.dynamic.IDirectiveLoadListener;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.IConfigurationListener;
import com.wily.util.adt.IAgedMap;
import com.wily.util.adt.IAgedValue;
import com.wily.util.adt.IAtomicNumberFactory;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.feedback.LoggingHelper;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class SustainabilityService
extends ASimpleService
implements ISustainabilityService,
IConfigurationListener,
IDirectiveLoadListener,
IEventListener {
    private static SustainabilityService sustainabilityServiceInstance = null;
    public static final String kRootMetrics = "Agent Stats|Sustainability";
    public static final String kSustainabiliyMetricsPropertyPrefix = "com.wily.introscope.agent.sustainabilitymetrics.";
    public static final String kSustainabiliyMetricsPropertyEnabled = "com.wily.introscope.agent.sustainabilitymetrics.enabled";
    public static final String kTracerSustainabiliyMetricsPropertyEnabled = "com.wily.introscope.agent.sustainabilitymetrics.tracer.enabled";
    public static final String kSustainabiliyMetricsPropertyMetricsEnabled = "com.wily.introscope.agent.sustainabilitymetrics.tracer.metrics.enabled";
    public static final String kSustainabiliyMetricsPropertyReportsEnabled = "com.wily.introscope.agent.sustainabilitymetrics.tracer.report.enabled";
    public static final String kSustainabiliyMetricsPropertyReportFrequencyEnabled = "com.wily.introscope.agent.sustainabilitymetrics.tracer.report.frequency";
    public static final int kReportFrequency = 60000;
    public static final String kSustainabiliyMetricsPropertyReportsBasename = "com.wily.introscope.agent.sustainabilitymetrics.tracer.report.basedir";
    private static final String kOptionalExtensionsRootMetricsName = "Agent Stats|Sustainability|Extensions Bundles";
    public static final String kOptionalExtensionsTotalMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Total:Count";
    public static final String kOptionalExtensionsTotalLoadedMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Loaded:Count";
    public static final String kOptionalExtensionsTotalFailedMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Failed:Count";
    private static final String kOptionalExtensionsDeployementRootMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Deployment";
    public static final String kOptionalExtensionsDeployementLastCycleTimeMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Deployment|Last Cycle:Time (milliseconds)";
    public static final String kOptionalExtensionsDeployementStatusMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Deployment|Current Cycle:Status (0=Deployed/1=Deploying)";
    public static final String kOptionalExtensionsDeployementCounterMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Deployment|Count:All Cycles";
    public static final String kOptionalExtensionsDeployementSuccessfulCounterMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Deployment|Count:Successful Cycles";
    public static final String kOptionalExtensionsDeployementFailedCounterMetricsName = "Agent Stats|Sustainability|Extensions Bundles|Deployment|Count:Failed Cycles";
    public static final String kAutoProbeTotalFailedMetricsName = "Agent Stats|Sustainability|Configuration|Logs:AutoProbe Errors Count";
    public static final String kAgentLogWarningMetricsName = "Agent Stats|Sustainability|Configuration|Logs:Warnings Count";
    public static final String kAgentLogErrorMetricsName = "Agent Stats|Sustainability|Configuration|Logs:Errors Count";
    public static final String kAgentLogWarningPerIntervalMetricsName = "Agent Stats|Sustainability|Configuration|Logs:Warnings Per Interval";
    public static final String kAgentLogErrorPerIntervalMetricsName = "Agent Stats|Sustainability|Configuration|Logs:Errors Per Interval";
    private static final String kComputeUnitRoot = "Agent Stats|Sustainability|Compute Unit Metrics";
    private static final String kComputeUnitCores = "Agent Stats|Sustainability|Compute Unit Metrics:Cores";
    private static final String kComputeUnitMemory = "Agent Stats|Sustainability|Compute Unit Metrics:Memory";
    private static final String kSOAPExceptionAnalyzerExceptionsMetricsName = "Agent Stats|Sustainability|SOAP Exception Analyzer|Exceptions analyzed per cycle:Count";
    private static final String kOverheadManagerRootMetricsName = "Agent Stats|Sustainability|Overhead Manager";
    private static final String kOverheadManagerMode = "Agent Stats|Sustainability|Overhead Manager:Overhead Mode";
    private volatile IAgent agent;
    private volatile IOverheadManager overheadManager;
    private volatile BooleanConfigurationProperty fAgentSustainabilityMetricsEnabledProperty;
    private volatile BooleanConfigurationProperty fAgentTracerSustainabilityMetricsEnabledProperty;
    private volatile BooleanConfigurationProperty fAgentTracerSustainabilityReportEnabledProperty;
    private volatile PositiveIntegerConfigurationProperty fAgentSustainabilityReportFrequencyProperty;
    private volatile boolean fAreSustainabilityMetricsEnabled = false;
    private volatile boolean fIsTracerSustainabilityMetricsEnabled = false;
    private volatile boolean fIsTracerSustainabilityReportEnabled = false;
    private volatile int fReportFrequency = 60000;
    private volatile IAgedMap fSustainabilityMap;
    private volatile IRegisteredBehavior extractorBehavior;
    private volatile IStringEveryEventDataAccumulator fConfigUdateTime = null;
    private volatile IStringEveryEventDataAccumulator fAutoProbeUdateTime = null;
    private volatile IStringEveryEventDataAccumulator fClassRedefinitionTime = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsTotalMetricCount = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsFailedMetricCount = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsLoadedMetricCount = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsSuccessfulDeploymentCount = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsFailedDeploymentCount = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsLastDeploymentCycleTime = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsDeploymentStatus = null;
    private volatile ILongFluctuatingCounterDataAccumulator fOptionalExtensionsDeploymentCount = null;
    private static volatile ILongFluctuatingCounterDataAccumulator fAutoProbeErrorMetricCountAccumulator = null;
    private static volatile ILongFluctuatingCounterDataAccumulator fAgentErrorMetricCountAccumulator = null;
    private static volatile ILongFluctuatingCounterDataAccumulator fAgentWarningMetricCountAccumulator = null;
    private static volatile ILongIntervalCounterDataAccumulator fAgentErrorsPerIntervalMetricCountAccumulator = null;
    private static volatile ILongIntervalCounterDataAccumulator fAgentWarningsPerIntervalMetricCountAccumulator = null;
    public static volatile ILongIntervalCounterDataAccumulator fSOAPExceptionAnalyzerExceptionsCount = null;
    private static volatile boolean fLogsAccumulatorsInitialized = false;
    private static final String kTransactionTraceEventMetricsName = "Agent Stats|Sustainability|Transaction Traces";
    private static final String kTransactionTraceEventCountMetricName = "Agent Stats|Sustainability|Transaction Traces:Total";
    private static final String kTransactionTraceEventByTypePrefix = "Agent Stats|Sustainability|Transaction Traces:";
    private static volatile ILongIntervalCounterDataAccumulator fTransactionTraceEventCountAccumulator = null;
    private static Map<String, ILongIntervalCounterDataAccumulator> fTransactionTraceEventCountsByType = new HashMap<String, ILongIntervalCounterDataAccumulator>();
    private volatile IIntegerConstantDataAccumulator fComputeUnitCoresCount = null;
    private volatile ILongConstantDataAccumulator fComputeUnitMemoryBytesCount = null;
    static final Module kModule = new Module("SustainabilityService");
    static final Set<ISustainabilityReportLogger> fLoggers = new HashSet<ISustainabilityReportLogger>();
    private static final List<ISustainabilityMetricsCallback> fCallBacks = new CopyOnWriteArrayList<ISustainabilityMetricsCallback>();
    private IRegisteredBehavior fMetricReportBehavior = null;

    public SustainabilityService(String name) {
        super(name);
    }

    public static SustainabilityService getSustainabilityServiceInstance() {
        return sustainabilityServiceInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ISustainabilityReportLogger> getLoggerSnapshot() {
        ArrayList<ISustainabilityReportLogger> result = new ArrayList<ISustainabilityReportLogger>();
        Set<ISustainabilityReportLogger> set = fLoggers;
        synchronized (set) {
            Iterator<ISustainabilityReportLogger> i = fLoggers.iterator();
            while (i.hasNext()) {
                result.add(i.next());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSustainabilityReportLogger(ISustainabilityReportLogger logger) {
        Set<ISustainabilityReportLogger> set = fLoggers;
        synchronized (set) {
            fLoggers.add(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSustainabilityReportLogger(ISustainabilityReportLogger logger) {
        Set<ISustainabilityReportLogger> set = fLoggers;
        synchronized (set) {
            fLoggers.remove(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSustainabilityReportLoggerSet() {
        Set<ISustainabilityReportLogger> set = fLoggers;
        synchronized (set) {
            fLoggers.clear();
        }
    }

    private void startTracerSustainabilityDataCollection() {
        if (this.fIsTracerSustainabilityMetricsEnabled || this.fIsTracerSustainabilityReportEnabled) {
            IConcurrentMapFactory factory;
            if (this.fSustainabilityMap == null && (factory = this.agent.IAgent_getConcurrentMapFactory()) != null) {
                this.fSustainabilityMap = factory.getConcurrentAgingMap("sustainabilityMetrics");
            }
        } else {
            this.clearTracerSustainabilityDataCollection();
        }
    }

    private void clearTracerSustainabilityDataCollection() {
        if (this.fSustainabilityMap != null) {
            ((Map)((Object)this.fSustainabilityMap)).clear();
        }
        this.fSustainabilityMap = null;
    }

    @Override
    protected void doStartService(IAgent agent, Map parameters) throws Exception {
        IDynamicInstrumentationTransformer transformer;
        this.agent = agent;
        this.overheadManager = agent.IAgent_getOverheadManager();
        this.fAgentSustainabilityMetricsEnabledProperty = new BooleanConfigurationProperty(kSustainabiliyMetricsPropertyEnabled, Boolean.FALSE, "Agent_Sustainability_Metric_Enabled_Property_Name", agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            @Override
            public void set(Object value) {
                SustainabilityService.this.fAreSustainabilityMetricsEnabled = (Boolean)value;
                if (!SustainabilityService.this.fAreSustainabilityMetricsEnabled) {
                    SustainabilityService.this.clearTracerSustainabilityDataCollection();
                    SustainabilityService.this.stopMetricReportBehavior();
                } else {
                    SustainabilityService.this.startMetricReportBehavior();
                }
                SustainabilityService.this.callCallbacksOnPropertyChange(SustainabilityService.this.fAreSustainabilityMetricsEnabled);
            }
        };
        this.fAgentTracerSustainabilityMetricsEnabledProperty = new BooleanConfigurationProperty(kSustainabiliyMetricsPropertyMetricsEnabled, Boolean.FALSE, "Agent_Sustainability_Metric_Enabled_Property_Name", agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            @Override
            public void set(Object value) {
                boolean newValue = (Boolean)value;
                SustainabilityService.this.fIsTracerSustainabilityMetricsEnabled = newValue;
                SustainabilityService.this.startTracerSustainabilityDataCollection();
            }
        };
        this.fAgentTracerSustainabilityReportEnabledProperty = new BooleanConfigurationProperty(kSustainabiliyMetricsPropertyReportsEnabled, Boolean.FALSE, "Agent_Sustainability_Report_Enabled_Property_Name", agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            @Override
            public void set(Object value) {
                SustainabilityService.this.fIsTracerSustainabilityReportEnabled = (Boolean)value;
                SustainabilityService.this.startTracerSustainabilityDataCollection();
            }
        };
        this.fAgentSustainabilityReportFrequencyProperty = new PositiveIntegerConfigurationProperty(kSustainabiliyMetricsPropertyReportFrequencyEnabled, 60000, "Agent_Sustainability_Report_Frequency_Property_Name", agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer()){

            @Override
            public void set(Object value) {
                SustainabilityService.this.fReportFrequency = (Integer)value;
                if (SustainabilityService.this.extractorBehavior != null) {
                    SustainabilityService.this.extractorBehavior.close();
                }
                SustainabilityService.this.extractorBehavior = SustainabilityService.this.startReportBehavior(SustainabilityService.this.getAgent());
            }
        };
        agent.IAgent_getConfigurationManager().add(this.fAgentSustainabilityMetricsEnabledProperty, true);
        agent.IAgent_getConfigurationManager().add(this.fAgentTracerSustainabilityMetricsEnabledProperty, true);
        agent.IAgent_getConfigurationManager().add(this.fAgentTracerSustainabilityReportEnabledProperty, true);
        agent.IAgent_getConfigurationManager().add(this.fAgentSustainabilityReportFrequencyProperty, true);
        sustainabilityServiceInstance = this;
        String metricName = "Agent Stats|Sustainability|Configuration:Last Profile Update Time";
        this.fConfigUdateTime = agent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator(metricName);
        this.fConfigUdateTime.IStringEveryEventDataAccumulator_addString(new Date(System.currentTimeMillis()).toString());
        agent.addConfigurationListener(this);
        metricName = "Agent Stats|Sustainability|Configuration:Last AutoProbe Reload Time";
        this.fAutoProbeUdateTime = agent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator(metricName);
        this.fAutoProbeUdateTime.IStringEveryEventDataAccumulator_addString(new Date(System.currentTimeMillis()).toString());
        metricName = "Agent Stats|Sustainability|Configuration:Last Class Redefinition Time";
        this.fClassRedefinitionTime = agent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator(metricName);
        this.fClassRedefinitionTime.IStringEveryEventDataAccumulator_addString(new Date(System.currentTimeMillis()).toString());
        this.fOptionalExtensionsTotalMetricCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsTotalMetricsName);
        this.fOptionalExtensionsLoadedMetricCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsTotalLoadedMetricsName);
        this.fOptionalExtensionsFailedMetricCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsTotalFailedMetricsName);
        this.fOptionalExtensionsFailedDeploymentCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsDeployementFailedCounterMetricsName);
        this.fOptionalExtensionsSuccessfulDeploymentCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsDeployementSuccessfulCounterMetricsName);
        this.fOptionalExtensionsDeploymentStatus = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsDeployementStatusMetricsName);
        this.fOptionalExtensionsDeploymentCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsDeployementCounterMetricsName);
        this.fOptionalExtensionsLastDeploymentCycleTime = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kOptionalExtensionsDeployementLastCycleTimeMetricsName);
        fAutoProbeErrorMetricCountAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kAutoProbeTotalFailedMetricsName);
        fAgentWarningMetricCountAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kAgentLogWarningMetricsName);
        fAgentErrorMetricCountAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(kAgentLogErrorMetricsName);
        fAgentWarningsPerIntervalMetricCountAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(kAgentLogWarningPerIntervalMetricsName);
        fAgentErrorsPerIntervalMetricCountAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(kAgentLogErrorPerIntervalMetricsName);
        fSOAPExceptionAnalyzerExceptionsCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(kSOAPExceptionAnalyzerExceptionsMetricsName);
        fLogsAccumulatorsInitialized = true;
        if (this.isSustainabilityMetricsEnabled()) {
            this.fComputeUnitCoresCount = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerConstantDataAccumulator(kComputeUnitCores, ComputeUnit.getNumberOfCores());
            this.fComputeUnitMemoryBytesCount = agent.IAgent_getDataAccumulatorFactory().safeGetLongConstantDataAccumulator(kComputeUnitMemory, ComputeUnit.getMaximumMemory());
            SustainabilityService.reportAgentErrorMetrics();
            SustainabilityService.reportAutoProbeErrorCountMetric();
            this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsLoadedMetricCount, OptionalExtensionsIncludeConfiguration.getIncludedExtensions().size());
            this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsFailedMetricCount, 0L);
        }
        if (this.overheadManager != null) {
            this.overheadManager.updateSustainabilityMetrics();
        }
        if ((transformer = agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer()) != null) {
            transformer.registerDirectiveLoadListener(this);
        }
        agent.IAgent_getTracerAdministrator().setService(this);
        SustainabilityReportLogger logger = new SustainabilityReportLogger(this.getAgent(), this.getAgent().IAgent_getConfigurationResource());
        agent.addConfigurationListener(logger);
        this.addSustainabilityReportLogger(logger);
        fTransactionTraceEventCountAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(kTransactionTraceEventCountMetricName);
        agent.addEventListener(this);
    }

    private IRegisteredBehavior startReportBehavior(IAgent agent) {
        return agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new ReportExtractor(), "Sustainability Tracer Overhead Report", true, (long)this.fReportFrequency, false);
    }

    @Override
    public ISustainabilityServiceTrace startSustainabilityTrace() {
        if (this.fIsTracerSustainabilityMetricsEnabled) {
            SustainabilityServiceTrace trace = new SustainabilityServiceTrace(this);
            return trace;
        }
        return null;
    }

    @Override
    public IAtomicNumberFactory getFactory() {
        return this.agent.IAgent_getAtomicNumberFactory();
    }

    @Override
    public ProbeInfoOverheadInfo getProbeInfoOverheadInfo(ProbeInformation probeInformation) {
        ProbeInfoOverheadInfo existingResult;
        ProbeInfoOverheadInfo result = (ProbeInfoOverheadInfo)this.fSustainabilityMap.getAged(probeInformation);
        if (result == null && (existingResult = (ProbeInfoOverheadInfo)this.fSustainabilityMap.addAgedIfAbsent(probeInformation, result = new ProbeInfoOverheadInfo(this, probeInformation))) != null) {
            result = existingResult;
        }
        return result;
    }

    @Override
    public void storeAway(ISustainabilityServiceTrace sustainabilityServiceTrace) {
        if (!this.fAreSustainabilityMetricsEnabled) {
            return;
        }
        ProbeInfoOverheadInfo info = this.getProbeInfoOverheadInfo(sustainabilityServiceTrace.getProbeInfo());
        long totalElapsedTime = sustainabilityServiceTrace.getTotalElapsedTime();
        long totalTimeInTracers = sustainabilityServiceTrace.getTotalTimeInTracers();
        long currentTotal = info.fGlobalTimeInMethod.addLongAndGet(totalElapsedTime);
        long currentTracer = info.fTraceTimeInMethod.addLongAndGet(totalTimeInTracers);
        if (this.fIsTracerSustainabilityMetricsEnabled) {
            info.fGlobal.ILongAggregatingDataAccumulator_recordDataPoint(totalElapsedTime);
            info.fTracers.ILongAggregatingDataAccumulator_recordDataPoint(totalTimeInTracers);
            double percentage = 100.0 * ((double)currentTracer / (double)currentTotal);
            int percentageTotal = (int)Math.floor(percentage);
            info.fPercentage.IIntegerAggregatingDataAccumulator_recordDataPoint(percentageTotal);
        }
    }

    @Override
    public IAgent getAgent() {
        return this.agent;
    }

    public static boolean areSustainabilityMetricsEnabled() {
        if (sustainabilityServiceInstance == null) {
            try {
                IndexedProperties props = AgentShim.getAgent().IAgent_getIndexedProperties();
                if (props != null) {
                    return props.getBooleanProperty(kSustainabiliyMetricsPropertyEnabled, false);
                }
            }
            catch (AgentNotAvailableException e) {
                return false;
            }
            return false;
        }
        return sustainabilityServiceInstance.isSustainabilityMetricsEnabled();
    }

    @Override
    public boolean isSustainabilityMetricsEnabled() {
        return this.fAreSustainabilityMetricsEnabled;
    }

    @Override
    public long getNanoTime() {
        return this.agent.getNanoTime();
    }

    @Override
    public void onChange(IndexedProperties newProps) {
        this.fConfigUdateTime.IStringEveryEventDataAccumulator_addString(new Date(System.currentTimeMillis()).toString());
    }

    @Override
    public void notifyDirectivesLoaded(Object dgCompilerSettings) {
        this.fAutoProbeUdateTime.IStringEveryEventDataAccumulator_addString(new Date(System.currentTimeMillis()).toString());
    }

    @Override
    public void notifyRedefinitionComplete() {
        this.fClassRedefinitionTime.IStringEveryEventDataAccumulator_addString(new Date(System.currentTimeMillis()).toString());
    }

    public void setOptionalExtensionsFailedMetricCount(int metricCount) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsFailedMetricCount, metricCount);
    }

    public void setOptionalExtensionsLoadedMetricCount(int metricCount) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsLoadedMetricCount, metricCount);
    }

    public void setOptionalExtensionsTotalMetricCount(long metricCount) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsTotalMetricCount, metricCount);
    }

    public void setOptionalExtensionsFailedDeploymentCount(long metricCount) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsFailedDeploymentCount, metricCount);
    }

    public void setOptionalExtensionsSuccessfulDeploymentCount(long metricCount) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsSuccessfulDeploymentCount, metricCount);
    }

    public void setOptionalExtensionsDeploymentCount(long metricCount) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsDeploymentCount, metricCount);
    }

    public void setOptionalExtensionsLastDeploymentCycleTime(long metricValue) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsLastDeploymentCycleTime, metricValue);
    }

    public void setOptionalExtensionsDeploymentStatus(int metricValue) {
        this.reportOptionalExtensionsMetrics(this.fOptionalExtensionsDeploymentStatus, metricValue);
    }

    private void reportOptionalExtensionsMetrics(ILongFluctuatingCounterDataAccumulator accumulator, long value) {
        if (accumulator != null) {
            accumulator.ILongCounterDataAccumulator_setValue(value);
        }
    }

    public static void reportAutoProbeErrorCountMetric() {
        if (AInstrumentationHelper.isAutoProbeSettingsInvalid() && fLogsAccumulatorsInitialized && fAutoProbeErrorMetricCountAccumulator != null) {
            fAutoProbeErrorMetricCountAccumulator.ILongCounterDataAccumulator_setValue(1L);
        }
    }

    public void setFeatureControlGenericMetrics() {
        OverheadMode overheadMode = OverheadAdministrator.getOverheadMode();
        if (overheadMode == OverheadMode.DEFAULT) {
            this.setFeatureControlMetricsUtil(kOverheadManagerMode, 0L);
        }
        if (overheadMode == OverheadMode.ABSOLUTE_LOW) {
            this.setFeatureControlMetricsUtil(kOverheadManagerMode, 1L);
        }
    }

    private void setFeatureControlMetricsUtil(String metricName, long metricValue) {
        this.agent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(metricName).ILongCounterDataAccumulator_setValue(metricValue);
    }

    public static void reportAgentErrorMetrics() {
        if (fLogsAccumulatorsInitialized) {
            fAgentErrorMetricCountAccumulator.ILongCounterDataAccumulator_setValue(LoggingHelper.getErrorCount());
            fAgentWarningMetricCountAccumulator.ILongCounterDataAccumulator_setValue(LoggingHelper.getWarningCount());
            fAgentWarningsPerIntervalMetricCountAccumulator.ILongAggregatingDataAccumulator_recordDataPoint(LoggingHelper.getAndResetWarningPerIntervalCount());
            fAgentErrorsPerIntervalMetricCountAccumulator.ILongAggregatingDataAccumulator_recordDataPoint(LoggingHelper.getAndResetErrorPerIntervalCount());
        }
    }

    public void reportSOAPExceptionsAnalyzedCount(long metricCount) {
        fSOAPExceptionAnalyzerExceptionsCount.ILongAggregatingDataAccumulator_recordDataPoint(metricCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noticeEvent(TransactionComponentData root) {
        if (!this.isSustainabilityMetricsEnabled()) {
            return;
        }
        fTransactionTraceEventCountAccumulator.ILongIntervalCounterDataAccumulator_addSingleIncident();
        String key = root.getParameterValue("Trace Type");
        if (key != null && key.length() > 0) {
            Map<String, ILongIntervalCounterDataAccumulator> map = fTransactionTraceEventCountsByType;
            synchronized (map) {
                ILongIntervalCounterDataAccumulator byTypeAcc = fTransactionTraceEventCountsByType.get(key);
                if (byTypeAcc == null) {
                    byTypeAcc = this.agent.IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(kTransactionTraceEventByTypePrefix + key);
                    fTransactionTraceEventCountsByType.put(key, byTypeAcc);
                }
                byTypeAcc.ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
        }
    }

    public static void addSustainabilityMetricCallback(ISustainabilityMetricsCallback callback) {
        fCallBacks.add(callback);
    }

    private void callCallbacksOnPropertyChange(boolean value) {
        for (ISustainabilityMetricsCallback cb : fCallBacks) {
            if (value) {
                cb.sustainabilityMetricsEnabled();
                continue;
            }
            cb.sustainabilityMetricsDisabled();
        }
    }

    private void startMetricReportBehavior() {
        if (this.fMetricReportBehavior != null) {
            this.fMetricReportBehavior.close();
        }
        this.fMetricReportBehavior = this.agent.IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

            @Override
            public void ITimestampedRunnable_execute(long nowInMillis) {
                if (SustainabilityService.this.fAreSustainabilityMetricsEnabled) {
                    for (ISustainabilityMetricsCallback cb : fCallBacks) {
                        cb.sustainabilityMetricInterval(nowInMillis);
                    }
                }
            }
        }, "Sustainability Metrics", true, 7500L, false);
    }

    private void stopMetricReportBehavior() {
        if (this.fMetricReportBehavior != null) {
            this.fMetricReportBehavior.close();
        }
    }

    private final class ReportExtractor
    implements ITimestampedRunnable {
        private ReportExtractor() {
        }

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            if (!SustainabilityService.this.fIsTracerSustainabilityReportEnabled) {
                return;
            }
            Map map = (Map)((Object)SustainabilityService.this.fSustainabilityMap);
            if (map != null) {
                ArrayList<SustainabilityReportEntry> result = new ArrayList<SustainabilityReportEntry>();
                for (Map.Entry e : map.entrySet()) {
                    IAgedValue dv = (IAgedValue)e.getValue();
                    ProbeInformation info = (ProbeInformation)e.getKey();
                    ProbeInfoOverheadInfo overhead = (ProbeInfoOverheadInfo)dv.get();
                    SustainabilityReportEntry ri = new SustainabilityReportEntry();
                    ri.setInfo(info);
                    ri.setTotal(overhead.fGlobalTimeInMethod.getLongAndSet(0L));
                    ri.setInTracers(overhead.fTraceTimeInMethod.getLongAndSet(0L));
                    double percentage = 100.0 * ((double)ri.getInTracers() / (double)ri.getTotal());
                    ri.setPercentage((int)Math.floor(percentage));
                    result.add(ri);
                }
                Collections.sort(result);
                List snapshot = SustainabilityService.this.getLoggerSnapshot();
                for (ISustainabilityReportLogger logger : snapshot) {
                    logger.log(result);
                }
            }
        }
    }
}

