/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.metric.calculator;

import com.wily.introscope.agent.metric.calculator.Operation;
import com.wily.introscope.agent.metric.calculator.UnaryOperation;
import com.wily.introscope.agent.metric.calculator.Variables;
import com.wily.introscope.spec.metric.TypeInquisitor;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.timeslice.ANumericalTimeslicedValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import java.util.HashMap;
import java.util.Map;

public class CounterOperation
extends UnaryOperation {
    private Map<Variables, ANumericalTimeslicedValue> lastValueMap = new HashMap<Variables, ANumericalTimeslicedValue>();

    public CounterOperation(Operation op) {
        super(op);
    }

    @Override
    protected IMetricDataValue calculate(String[] vars, IMetricDataValue v) {
        Variables key = new Variables(vars);
        ANumericalTimeslicedValue lastValue = this.lastValueMap.get(key);
        ANumericalTimeslicedValue value = (ANumericalTimeslicedValue)v;
        IntegerTimeslicedValue result = null;
        int type = v.getType();
        if (!TypeInquisitor.isIntervalCounter((int)type) && !TypeInquisitor.isRate((int)type)) {
            return null;
        }
        long counter = value.getValueAsLong();
        long min = 0L;
        if (lastValue != null) {
            counter += lastValue.getValueAsLong();
            min = lastValue.getValueAsLong();
        }
        result = new IntegerTimeslicedValue(0x100101, v.getStartTimestampInMillis(), v.getStopTimestampInMillis(), null, v.getDataPointCount(), false, (int)counter, (int)min, (int)counter);
        this.lastValueMap.put(key, (ANumericalTimeslicedValue)result);
        return result;
    }
}

