/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.blame.StackDecoration;
import com.wily.introscope.agent.blame.ThreadLocals;
import com.wily.introscope.agent.blame.TransactionCache;
import com.wily.introscope.agent.blame.VirtualElement;
import com.wily.introscope.agent.blame.VirtualStackCursor;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.feature.StallFeatureBase;
import com.wily.introscope.agent.filter.FilterController;
import com.wily.introscope.agent.trace.AbortedStackElement;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.StartTransactionStackElement;
import com.wily.introscope.agent.trace.WrappedInvocationData;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IBoundaryBlameStackHelper;
import com.wily.introscope.agent.trace.cas.IBoundaryBlameStackHelperProvider;
import com.wily.introscope.agent.trace.cas.IPlaceholderElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionCache;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProvider;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProviderFactory;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementCallbackOnRecursion;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.ITransactionInstance;
import com.wily.introscope.agent.trace.cas.ITransactionInstanceProvider;
import com.wily.introscope.agent.trace.cas.StackRecursionHelper;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.SocketTransactionElement;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.agent.trace.hc2.WilyEndTransactionInstance;
import com.wily.introscope.agent.trace.hc2.WilyStartTransactionInstance;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.transactiontrace.CrossCorrelationStringParameterProvider;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.Module;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VirtualStack
implements IBlameStack,
IBoundaryBlameStackHelperProvider,
ITransactionCacheProvider {
    protected static volatile IAgent fAgent;
    static final Module kModule;
    private static volatile boolean sIsMixedModeWarningGiven;
    private static final TxnElementRecursionHelper kTxnElementRecusrsionHelper;
    public static IStackType kStackType;
    public static final ITransactionCacheProviderFactory sCacheProviderFactory;

    public VirtualStack(IAgent agent) {
        fAgent = agent;
    }

    public void setUseExternalThreadId() {
        ThreadLocals.sCacheProviderFactory.setUseExternalThreadId();
    }

    public static final boolean isParentDummyVirtualElement(InvocationData data) {
        VirtualStackCursor cursor = (VirtualStackCursor)data.getVirtualCursor();
        if (cursor == null) {
            cursor = ThreadLocals.getStack();
        }
        return cursor.data != null && cursor.data.getParent() != null && cursor.data.getParent() instanceof VirtualElement.Dummy;
    }

    private static final IStackElement push(WrappedInvocationData wrappedData) {
        InvocationData data = wrappedData.getInvocationData();
        VirtualStackCursor cursor = (VirtualStackCursor)data.getVirtualCursor();
        if (cursor == null) {
            cursor = ThreadLocals.getStack();
        }
        if (cursor.transactionCache.isTransactionAborted()) {
            return AbortedStackElement.getInstance();
        }
        IStackElement previous = cursor.data;
        wrappedData.setParent(previous);
        cursor.data = wrappedData;
        if (WilyTransactionStructure.developmentDebug) {
            fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";WrappedInvocationData  Pushed to stack: " + data);
        }
        return previous;
    }

    public static final IStackElement push(InvocationData data) {
        VirtualStackCursor cursor = (VirtualStackCursor)data.getVirtualCursor();
        if (cursor == null) {
            cursor = ThreadLocals.getStack();
        }
        if (cursor.transactionCache.isTransactionAborted()) {
            return AbortedStackElement.getInstance();
        }
        IStackElement previous = cursor.data;
        if (previous != data && !data.setParent(previous)) {
            return VirtualStack.push(new WrappedInvocationData(data));
        }
        cursor.data = data;
        if (previous == null) {
            cursor.transactionCache.setRoot(data);
            data.setStartedTransaction();
        }
        if (WilyTransactionStructure.developmentDebug) {
            fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";InvocationData  Pushed to stack: " + data);
        }
        return previous == null ? StartTransactionStackElement.getInstance() : previous;
    }

    public static final void pushAppMap(CrossCorrelationStringParameterProvider provider, InvocationData data) {
        AppMapCursor cursor = ThreadLocals.getAppMapStack();
        InvocationData previous = cursor.data;
        CrossCorrelationStringParameterProvider previousProvider = cursor.provider;
        if (previous != data) {
            data.setAppMapParent(previousProvider, previous);
        }
        cursor.data = data;
        cursor.provider = provider;
    }

    private static void attemptIBlameStack_tearDown() {
        if (fAgent != null) {
            fAgent.IAgent_getComponentTracer().teardown();
        }
    }

    public static final void tearDown() {
        VirtualStack.tearDownMe();
        VirtualStack.attemptIBlameStack_tearDown();
    }

    private static final void tearDownMe() {
        VirtualStackCursor cursor = ThreadLocals.getStackOrNull();
        if (cursor == null) {
            return;
        }
        cursor.data = null;
        StallFeatureBase.removeStallPoint(cursor.getCurrentCache().getStallPoint(), cursor.data);
        cursor.decoration.clear();
        cursor.decorationClampHit = false;
        cursor.transactionCache.clear();
        AppMapCursor appCursor = ThreadLocals.getAppMapStackOrNull();
        if (appCursor != null) {
            appCursor.clear();
        }
        if (WilyTransactionStructure.developmentDebug) {
            fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";Virtual Stack has been reset ");
        }
    }

    public static final void pop(InvocationData data) {
        IStackElement parent = data.getParent();
        if (parent != data) {
            IStackElement element;
            VirtualStackCursor cursor = (VirtualStackCursor)data.getVirtualCursor();
            if (cursor == null) {
                cursor = ThreadLocals.getStack();
            }
            if ((element = cursor.data) != null && element instanceof WrappedInvocationData) {
                VirtualStack.pop((WrappedInvocationData)element);
                return;
            }
            cursor.data = parent;
            if (parent != null) {
                parent.setCursor(data.getCursor());
                if (parent.getCursor() instanceof IPlaceholderElement) {
                    VirtualStack.popPlaceholder("end", ((IPlaceholderElement)parent.getCursor()).getProvider());
                }
            }
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";InvocationData  Popped from stack: " + data);
            }
        }
    }

    private static final void pop(WrappedInvocationData wrappedData) {
        IStackElement parent = wrappedData.getParent();
        InvocationData data = wrappedData.getInvocationData();
        if (parent != wrappedData) {
            VirtualStackCursor cursor = (VirtualStackCursor)data.getVirtualCursor();
            if (cursor == null) {
                cursor = ThreadLocals.getStack();
            }
            cursor.data = parent;
            if (parent != null) {
                parent.setCursor(data.getCursor());
                if (parent.getCursor() instanceof IPlaceholderElement) {
                    VirtualStack.popPlaceholder("end", ((IPlaceholderElement)parent.getCursor()).getProvider());
                }
            }
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";WrappedInvocationData  Popped from stack: " + data);
            }
        }
    }

    public static final void popAppMap(InvocationData data) {
        AppMapCursor cursor = ThreadLocals.getAppMapStack();
        if (cursor.data == data) {
            cursor.data = data.getAppMapParent();
            cursor.provider = data.getCrossProcessStringParentProvider();
        }
    }

    public static final IStackElement peekIfNew(Object caller) {
        VirtualStackCursor cursor = ThreadLocals.getStack();
        if (!cursor.getCurrentCache().hasCallerSeenStackElement(caller, cursor.data)) {
            return cursor.data;
        }
        return null;
    }

    public static final IStackElement peek() {
        return ThreadLocals.getStack().data;
    }

    public static final InvocationData peekAppMap() {
        return ThreadLocals.getAppMapStack().data;
    }

    private static void addParamToDecoration(IComponentParameterCallback callback, IStackElement newTopElement, VirtualStackCursor cursor) {
        StackDecoration sd = cursor.decoration.get(newTopElement);
        if (sd == null) {
            sd = new StackDecoration();
        }
        sd.callbacks.offer(callback);
        VirtualStack.clampDecoration(cursor);
        StackDecoration alreadyExisting = cursor.decoration.putIfAbsent(cursor.data, sd);
        if (alreadyExisting != null) {
            alreadyExisting.callbacks.offer(callback);
        }
    }

    private static void addParamToDecoration(String paramName, String paramValue, IStackElement newTopElement, VirtualStackCursor cursor) {
        StackDecoration sd = cursor.decoration.get(newTopElement);
        if (sd == null) {
            sd = new StackDecoration();
        }
        sd.parameters.put(paramName, paramValue);
        VirtualStack.clampDecoration(cursor);
        StackDecoration alreadyExisting = cursor.decoration.putIfAbsent(cursor.data, sd);
        if (alreadyExisting != null) {
            alreadyExisting.parameters.put(paramName, paramValue);
        }
    }

    private void giveMixedModeWarning() {
        sIsMixedModeWarningGiven = true;
        fAgent.IAgent_getModuleFeedback().warn(kModule, "An agent tracer using legacy APIs has been detected.");
        fAgent.IAgent_getModuleFeedback().warn(kModule, "Running legacy tracers with the agent in new mode is not recommended.");
        fAgent.IAgent_getModuleFeedback().warn(kModule, "Please contact support who can refer you to documentation on how to upgrade your legacy tracers.");
        fAgent.IAgent_getModuleFeedback().warn(kModule, "In the interim, please configure the agent to use legacy mode or use the pre-configured version of the legacy agent package.");
        fAgent.IAgent_getModuleFeedback().warn(kModule, "For example, the legacy package for the Oracle WebLogic agent on UNIX is IntroscopeAgentFiles-Legacy-NoInstallerx.x.x.xweblogic.unix.tar");
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            fAgent.IAgent_getModuleFeedback().debug(kModule, Thread.currentThread().getStackTrace()[i].toString());
        }
    }

    @Override
    public void IBlameStack_addComponent(String component, IComponentParameterCallback callback) {
        if (!sIsMixedModeWarningGiven) {
            this.giveMixedModeWarning();
        }
        VirtualStack.pushFromOldAPI(component, callback);
    }

    @Override
    public void IBlameStack_addComponent(String component) {
        if (!sIsMixedModeWarningGiven) {
            this.giveMixedModeWarning();
        }
        VirtualStack.pushFromOldAPI(component);
    }

    @Override
    public void IBlameStack_addComponent(String component, String paramName, String paramValue) {
        if (!sIsMixedModeWarningGiven) {
            this.giveMixedModeWarning();
        }
        VirtualStack.pushFromOldAPI(component, paramName, paramValue);
    }

    @Override
    public void IBlameStack_addExtraParameter(String paramName, String paramValue) {
        VirtualStackCursor cursor = ThreadLocals.getStack();
        this.IBlameStack_addExtraParameter(paramName, paramValue, cursor.data);
    }

    public void IBlameStack_addExtraParameter(String paramName, String paramValue, IStackElement stackElement) {
        VirtualStackCursor cursor = ThreadLocals.getStack();
        if (cursor.data != null) {
            StackDecoration sd = cursor.decoration.get(stackElement);
            if (sd == null) {
                sd = new StackDecoration();
            }
            sd.parameters.put(paramName, paramValue);
            VirtualStack.clampDecoration(cursor);
            StackDecoration alreadyExisting = cursor.decoration.putIfAbsent(stackElement, sd);
            if (alreadyExisting != null) {
                alreadyExisting.parameters.put(paramName, paramValue);
            }
        }
    }

    @Override
    public BlameStackSnapshot IBlameStack_getSnapshot(String component) {
        return null;
    }

    @Override
    public boolean IBlameStack_isEmpty() {
        return ThreadLocals.getStack().data == null;
    }

    @Override
    public void IBlameStack_removeComponent(String component) {
        VirtualStack.popFromOldAPI(component);
    }

    @Override
    public void IBlameStack_tearDown() {
        VirtualStack.tearDownMe();
        VirtualStackCursor vcs = ThreadLocals.getStackOrNull();
        if (vcs == null) {
            return;
        }
        TransactionCache transactionCache = vcs.transactionCache;
        if (transactionCache.isVirtualElementEndedTxn() || transactionCache.isCrossCorrelationElementEndedTxn()) {
            CrossProcessCorrelationAdmin.invalidateCrossProcessDataCache();
            transactionCache.setfVirtualElementEndedTxn(false);
            transactionCache.setfCrossCorrelationElementEndedTxn(false);
        }
    }

    @Override
    public void addMapComponent(IStackType type, String component) {
        if (type == kStackType) {
            this.IBlameStack_addComponent(component);
        }
    }

    @Override
    public void addMapComponent(IStackType type, String component, String paramName, String paramVal) {
        if (type == kStackType) {
            this.IBlameStack_addComponent(component, paramName, paramVal);
        }
    }

    @Override
    public void addMapComponent(IStackType type, String component, HashMap<String, String> params) {
        if (type == kStackType) {
            if (!sIsMixedModeWarningGiven) {
                this.giveMixedModeWarning();
            }
            IStackElement newTopElement = VirtualStack.pushFromOldAPI(component);
            VirtualStackCursor cursor = ThreadLocals.getStack();
            StackDecoration sd = cursor.decoration.get(newTopElement);
            if (sd == null) {
                sd = new StackDecoration();
            }
            sd.parameters.putAll(params);
            VirtualStack.clampDecoration(cursor);
            StackDecoration alreadyExisting = cursor.decoration.putIfAbsent(cursor.data, sd);
            if (alreadyExisting != null) {
                alreadyExisting.parameters.putAll(params);
            }
        }
    }

    private static void clampDecoration(VirtualStackCursor cursor) {
        if (cursor.decoration.size() > VirtualStackCursor.sMaxDecorations && VirtualStackCursor.sMaxDecorations > 0) {
            String msg = "Clearing VirtualStackCursor.decoration which has " + cursor.decoration.size() + " elements, more than max allowed: " + VirtualStackCursor.sMaxDecorations;
            if (!cursor.decorationClampHit) {
                fAgent.IAgent_getModuleFeedback().info(kModule, msg);
                cursor.decorationClampHit = true;
            } else {
                fAgent.IAgent_getModuleFeedback().debug(kModule, msg);
            }
            cursor.decoration.clear();
        }
    }

    @Override
    public void addRootParameter(String key, String value) {
        VirtualStackCursor cursor = ThreadLocals.getStack();
        IStackElement dataComponent = cursor.transactionCache.getRoot();
        if (dataComponent != null) {
            StackDecoration sd = cursor.decoration.get(dataComponent);
            if (sd == null) {
                sd = new StackDecoration();
            }
            sd.parameters.put(key, value);
            VirtualStack.clampDecoration(cursor);
            StackDecoration alreadyExisting = cursor.decoration.putIfAbsent(dataComponent, sd);
            if (alreadyExisting != null) {
                alreadyExisting.parameters.put(key, value);
            }
        } else {
            throw new RuntimeException("Cannot add parameter to an empty virtual stack.");
        }
    }

    @Override
    public void endBoundaryPopped(String component) {
    }

    @Override
    public void frontBoundaryPopped(String component) {
    }

    @Override
    public String[] getDefaultBackendData() {
        return null;
    }

    @Override
    public BlameStackSnapshot getDefaultBackendSnapshot() {
        return null;
    }

    @Override
    public boolean getHeadFilteringStatus() {
        return FilterController.canCurrentTransactionBeMarkedForCollection(ThreadLocals.getStack().transactionCache);
    }

    @Override
    public boolean hasFrontBoundary() {
        return ThreadLocals.getStack().transactionCache.getFrontend() != null;
    }

    public static boolean staticHasFrontBoundary() {
        return ThreadLocals.getStack().transactionCache.getFrontend() != null;
    }

    @Override
    public boolean noteBoundaryError() {
        return false;
    }

    @Override
    public void popMapComponent(IStackType stackType, String component) {
        if (stackType == kStackType) {
            this.IBlameStack_removeComponent(component);
        }
    }

    @Override
    public void removeMapComponent(IStackType stackType, String component) {
        if (stackType == kStackType) {
            this.IBlameStack_removeComponent(component);
        }
    }

    @Override
    public void setDefaultBackendComponent(String componentToReplace, String backendComponent) {
    }

    @Override
    public void setEndBoundary(String component) {
    }

    public static boolean staticHasEndBoundary() {
        return ThreadLocals.getStack().transactionCache.getBackend() != null;
    }

    @Override
    public void setFrontBoundary(String component) {
    }

    @Override
    public boolean shouldCurrentTraceBePropagated() {
        return FilterController.shouldCurrentTraceBePropagated(ThreadLocals.getStack().transactionCache);
    }

    public static TransactionCollectStatus getTransactionCollectStatus() {
        return ThreadLocals.getStack().transactionCache.getTransactionCollectionStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IStackElement pushFromOldAPI(String component) {
        VirtualStackCursor cursor = ThreadLocals.getStack();
        if (cursor != null) {
            if (cursor.transactionCache.isTransactionAborted()) {
                return AbortedStackElement.kInstance;
            }
            IStackElement previous = cursor.data;
            VirtualElement data = new VirtualElement(component, previous, cursor.transactionCache);
            cursor.data = data;
            try {
                if (previous != null) {
                    ITransactionElement currentCursor = previous.getCursor();
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitNextStartTransaction((Object)component, currentCursor, 0, (IStackElement)data, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                    cursor.data.setCursor(newTransactionCursor);
                    ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
                } else {
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitStartTransaction((Object)component, 0, (IStackElement)data, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                    cursor.data.setCursor(newTransactionCursor);
                    ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
                }
                if (WilyTransactionStructure.fSuggestStallTraceProperty) {
                    StallFeatureBase.putStallPoint(data);
                }
            }
            finally {
                if (previous == null) {
                    cursor.transactionCache.setRoot(data);
                }
            }
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";VirtualElement  Pushed on to stack: " + component);
            }
            return previous == null ? StartTransactionStackElement.kInstance : previous;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IStackElement pushFromOldAPI(String component, IComponentParameterCallback callback) {
        VirtualStackCursor cursor = ThreadLocals.getStack();
        if (cursor != null) {
            if (cursor.transactionCache.isTransactionAborted()) {
                return AbortedStackElement.kInstance;
            }
            IStackElement previous = cursor.data;
            VirtualElement data = new VirtualElement(component, previous, cursor.transactionCache);
            cursor.data = data;
            VirtualStack.addParamToDecoration(callback, data, cursor);
            try {
                if (previous != null) {
                    ITransactionElement currentCursor = previous.getCursor();
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitNextStartTransaction((Object)component, currentCursor, 0, (IStackElement)data, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                    cursor.data.setCursor(newTransactionCursor);
                    ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
                } else {
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitStartTransaction((Object)component, 0, (IStackElement)data, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                    cursor.data.setCursor(newTransactionCursor);
                    ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
                }
                if (WilyTransactionStructure.fSuggestStallTraceProperty) {
                    StallFeatureBase.putStallPoint(data);
                }
            }
            finally {
                if (previous == null) {
                    cursor.transactionCache.setRoot(data);
                }
            }
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";VirtualElement  Pushed on to stack: " + component);
            }
            return previous == null ? StartTransactionStackElement.kInstance : previous;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IStackElement pushFromOldAPI(String component, String param, String value) {
        VirtualStackCursor cursor = ThreadLocals.getStack();
        if (cursor != null) {
            if (cursor.transactionCache.isTransactionAborted()) {
                return AbortedStackElement.kInstance;
            }
            IStackElement previous = cursor.data;
            VirtualElement data = new VirtualElement(component, previous, cursor.transactionCache);
            cursor.data = data;
            VirtualStack.addParamToDecoration(param, value, data, cursor);
            try {
                if (previous != null) {
                    ITransactionElement currentCursor = previous.getCursor();
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitNextStartTransaction((Object)component, currentCursor, 0, (IStackElement)data, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                    cursor.data.setCursor(newTransactionCursor);
                    ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
                } else {
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitStartTransaction((Object)component, 0, (IStackElement)data, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                    cursor.data.setCursor(newTransactionCursor);
                    ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
                }
                if (WilyTransactionStructure.fSuggestStallTraceProperty) {
                    StallFeatureBase.putStallPoint(data);
                }
            }
            finally {
                if (previous == null) {
                    cursor.transactionCache.setRoot(data);
                }
            }
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";VirtualElement  Pushed on to stack: " + component);
            }
            return previous == null ? StartTransactionStackElement.kInstance : previous;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void popFromOldAPI(String component) {
        VirtualStackCursor cursor = ThreadLocals.getStack();
        if (cursor != null) {
            boolean bAbortTransaction = false;
            try {
                IStackElement element = cursor.data;
                if (!cursor.transactionCache.isTransactionAborted() && element != null) {
                    ITransactionElement oldTransactionCursor;
                    if (element instanceof VirtualElement.Dummy) {
                        if ((element = ((VirtualElement.Dummy)element).getImmediateNonDummyParent()) == null) {
                            bAbortTransaction = true;
                            WilyTransactionStructure.getInstance().abortTransaction(new TransactionTransitionException("The stack is corrupted due to a tracer which removes component but does not add "), cursor.data);
                            return;
                        }
                        cursor.data = element;
                    }
                    if (!VirtualStack.checkStackRobustness(element, oldTransactionCursor = element.getCursor(), component)) {
                        if (VirtualStack.isTxnAbortedDueToInvalidCursor(oldTransactionCursor)) {
                            WilyTransactionStructure.getInstance().abortTransaction(new TransactionTransitionException("The cursor is invalid due to some reason " + element), element);
                        } else {
                            WilyTransactionStructure.getInstance().abortTransaction(new TransactionTransitionException("The stack is corrupted on element " + element), element);
                        }
                        bAbortTransaction = true;
                    } else {
                        ((VirtualElement)element).setWallClockFinishTime(MasterClock.currentTimeMillis());
                        VirtualStack.updateDefaultBackendMetrics(cursor, element);
                        if (cursor.transactionCache.getRoot() == cursor.data) {
                            WilyTransactionStructure.getInstance().submitNextEndTransaction(component, oldTransactionCursor, 0, element, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance, true);
                        } else {
                            ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitNextEndTransaction((Object)component, oldTransactionCursor, 0, element, (ITransactionElementProvider)ADefaultTransactionElementProvider.kInstance, ADefaultTransactionInstanceProvider.kInstance);
                            element.setCursor(newTransactionCursor);
                        }
                    }
                }
                if (WilyTransactionStructure.developmentDebug) {
                    fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";VirtualElement  Popped from stack: " + component);
                }
            }
            finally {
                if (bAbortTransaction || cursor.data != null && cursor.transactionCache.getRoot() == cursor.data) {
                    cursor.data.setCursor(null);
                    if (cursor.transactionCache.isTransactionAborted()) {
                        FilterController.updateTransactionCollectStatus(cursor.data, false, false, 0);
                    }
                    StallFeatureBase.removeStallPoint(cursor.data.getStallPoint(), cursor.data);
                    VirtualStack.tearDownMe();
                    cursor.transactionCache.setfVirtualElementEndedTxn(true);
                } else if (cursor.data != null) {
                    IStackElement parent = cursor.data.getParent();
                    if (parent != null) {
                        parent.setCursor(cursor.data.getCursor());
                    }
                    cursor.data = cursor.data.getParent();
                    if (parent.getCursor() instanceof IPlaceholderElement) {
                        VirtualStack.popPlaceholder("end", ((IPlaceholderElement)parent.getCursor()).getProvider());
                        parent = ((VirtualElement.Dummy)parent).getImmediateNonDummyParent();
                    }
                    if (parent != null) {
                        StallFeatureBase.putValidParentInStallPoint(cursor.data);
                    }
                }
            }
        }
    }

    private static boolean isTxnAbortedDueToInvalidCursor(ITransactionElement cursor) {
        StackRecursionHelper.staticSafeRecurseAccessParent(cursor, kTxnElementRecusrsionHelper, StackRecursionHelper.kMaxRecursive);
        return VirtualStack.getTransactionCache().isTransactionAborted();
    }

    private static void updateDefaultBackendMetrics(VirtualStackCursor cursor, IStackElement element) {
        Iterator i = cursor.data.getAppMapSocketCursors();
        if (i != null) {
            long elapsed = element.getWallClockElapsedTime();
            long endTime = element.getWallClockFinishTime();
            int hashcode = element.hashCode();
            while (i.hasNext()) {
                SocketTransactionElement socketCursor = (SocketTransactionElement)i.next();
                socketCursor.getTimerRepository().update(UpdaterFactory.getCombiningUpdater(), elapsed, endTime, hashcode);
                socketCursor.getPerIntervalRepository().update(UpdaterFactory.getIncreasingUpdater(), 0L, endTime, hashcode);
            }
        }
    }

    private static final boolean checkStackRobustness(IStackElement element, ITransactionElement oldTransactionCursor, String component) {
        if (element == null || element instanceof InvocationData) {
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";Stack is corrupt, element is null or is instance of Invocation data where it is expected to be popped from legacy mode");
            }
            return false;
        }
        if (oldTransactionCursor == null) {
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";Stack is corrupt, the element does not have a current transaction cursor");
            }
            return false;
        }
        if (oldTransactionCursor instanceof WilyTransactionElement) {
            boolean result = ((WilyTransactionElement)oldTransactionCursor).getBlameName().equals(component);
            if (WilyTransactionStructure.developmentDebug && !result) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";Stack is corrupt, attempting at popping " + component + " where in the stack there is a cursor with name: " + ((WilyTransactionElement)oldTransactionCursor).getBlameName());
            }
            return result;
        }
        if (WilyTransactionStructure.developmentDebug) {
            fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";Stack is corrupt, the transaction cursor is not a wily blame cursor but an instance of " + oldTransactionCursor.getClass().getName());
        }
        return false;
    }

    public static TransactionCache getTransactionCache() {
        return ThreadLocals.getStack().transactionCache;
    }

    public static void setAborted() {
    }

    public static final IStackElement pushPlaceholder(String component, ITransactionElementProvider provider, ITransactionInstanceProvider instanceProvider) {
        VirtualStackCursor cursor = ThreadLocals.getStack();
        if (cursor != null) {
            if (cursor.transactionCache.isTransactionAborted()) {
                return AbortedStackElement.kInstance;
            }
            IStackElement previous = cursor.data;
            if (previous != null) {
                ITransactionElement currentCursor = previous.getCursor();
                VirtualElement.Dummy data = new VirtualElement.Dummy(component, previous, cursor.transactionCache);
                ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitNextStartTransaction((Object)component, currentCursor, 0, (IStackElement)data, provider, instanceProvider);
                cursor.data = data;
                cursor.data.setCursor(newTransactionCursor);
                ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
            } else {
                VirtualElement.Dummy data = new VirtualElement.Dummy(component, null, cursor.transactionCache);
                ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitStartTransaction((Object)component, 0, (IStackElement)data, provider, instanceProvider);
                cursor.data = data;
                cursor.transactionCache.setRoot(data);
                cursor.data.setCursor(newTransactionCursor);
                ((VirtualElement)cursor.data).setStartCursor(newTransactionCursor);
            }
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";VirtualElementPushed on to stack by PlaceHolder: " + component);
            }
            cursor.transactionCache.setCorrelationIdWasInvoked();
            return previous;
        }
        return null;
    }

    public static final void popPlaceholder(String component, ITransactionElementProvider provider) {
        VirtualStackCursor cursor = ThreadLocals.getStack();
        if (cursor != null) {
            IStackElement element = cursor.data;
            IStackElement parent = null;
            if (element != null && !element.isTransactionAborted()) {
                ((VirtualElement)element).setWallClockFinishTime(MasterClock.currentTimeMillis());
                parent = element.getParent();
                if (parent != null) {
                    ITransactionElement newTransactionCursor = WilyTransactionStructure.getInstance().submitNextEndTransaction(component, element.getCursor(), 0, element, provider);
                    element.setCursor(newTransactionCursor);
                    parent.setCursor(element.getCursor());
                } else {
                    cursor.transactionCache.setfCrossCorrelationElementEndedTxn(true);
                    WilyTransactionStructure.getInstance().submitNextEndTransaction(component, element.getCursor(), 0, element, provider, ADefaultTransactionInstanceProvider.kInstance, true);
                    element.setCursor(null);
                    VirtualStack.tearDown();
                }
            } else if (element != null && element.isTransactionAborted() && (parent = element.getParent()) == null) {
                cursor.transactionCache.setfCrossCorrelationElementEndedTxn(true);
                element.setCursor(null);
                VirtualStack.tearDownMe();
            }
            cursor.data = parent;
            if (WilyTransactionStructure.developmentDebug) {
                fAgent.IAgent_getModuleFeedback().trace(WilyTransactionStructure.kStackModule, Thread.currentThread().getName() + ";VirtualElementPopped from stack by PlaceHolder: " + component);
            }
        }
    }

    public static void addParameterCallbacks(Map<String, ?> parameters, IStackElement element) {
        VirtualStackCursor cursor = ThreadLocals.getStack();
        StackDecoration sd = cursor.decoration.get(element);
        if (sd == null) {
            return;
        }
        parameters.putAll(sd.parameters);
        for (IComponentParameterCallback callback : sd.callbacks) {
            callback.IComponentParameterCallback_addParameters(parameters);
        }
    }

    public static void abortTransaction() {
        VirtualStack.getTransactionCache().setAborted();
    }

    @Override
    public IBoundaryBlameStackHelper getCurrentThreadHelper() {
        return ThreadLocals.getStack().transactionCache;
    }

    @Override
    public ITransactionCache getCurrentCache() {
        return ThreadLocals.getStack().transactionCache;
    }

    @Override
    public IStackElement getTopOfStack() {
        return ThreadLocals.getStack().data;
    }

    public static void clear() {
        VirtualStackCursor cursor = ThreadLocals.getStackOrNull();
        if (cursor == null) {
            return;
        }
        cursor.clear();
        AppMapCursor cursor1 = ThreadLocals.getAppMapStackOrNull();
        if (cursor1 != null) {
            cursor1.clear();
        }
    }

    static {
        kModule = new Module("VirtualStack");
        sIsMixedModeWarningGiven = false;
        kTxnElementRecusrsionHelper = new TxnElementRecursionHelper();
        kStackType = new IStackType(){};
        sCacheProviderFactory = ThreadLocals.sCacheProviderFactory;
    }

    private static class ADefaultTransactionInstanceProvider
    implements ITransactionInstanceProvider {
        static final ADefaultTransactionInstanceProvider kInstance = new ADefaultTransactionInstanceProvider();

        private ADefaultTransactionInstanceProvider() {
        }

        @Override
        public void offerNewTransactionInstanceElementOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
            List<ITransactionInstance> current = data.getTransactionInstanceList();
            int position = data.getStartInstancePositionAt(tracerIndex);
            if (position >= 0) {
                WilyStartTransactionInstance start = (WilyStartTransactionInstance)current.get(position);
                WilyEndTransactionInstance instance = new WilyEndTransactionInstance(data.getWallClockElapsedTime(), newElement, start);
                current.add(instance);
            }
        }

        @Override
        public void offerNewTransactionInstanceElementOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
            WilyStartTransactionInstance instance = new WilyStartTransactionInstance(data, newElement);
            List<ITransactionInstance> current = data.getTransactionInstanceList();
            data.setStartInstancePositionAt(current.size(), tracerIndex);
            current.add(instance);
        }

        @Override
        public void suggestEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
            if (WilyTransactionStructure.getInstance().shouldTraceTransactionInstances(data)) {
                TransactionHarvestHelper.doHarvest(WilyTransactionStructure.getInstance(), data);
            } else {
                TransactionHarvestHelper.submitTransactionToCache(data);
            }
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public ISamplingResult preSample(IStackElement data) {
            return ISamplingResult.NO;
        }
    }

    private static class ADefaultTransactionElementProvider
    implements ITransactionElementProvider {
        static final ADefaultTransactionElementProvider kInstance = new ADefaultTransactionElementProvider();

        private ADefaultTransactionElementProvider() {
        }

        @Override
        public ITransactionElement getElement(Object key, ITransactionElement parent) {
            return null;
        }

        @Override
        public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
            return new WilyBridgeTransactionElement(key.toString(), false, parent, null, (IBlameTransactionElement)data.getStartCursorAt(tracerIndex));
        }

        @Override
        public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
            return new WilyBridgeTransactionElement(key.toString(), true, parent, BlamePointTracer.getPreviousBlamePoint(parent), null);
        }
    }

    private static class WilyBridgeTransactionElement
    extends WilyTransactionElement {
        private WilyBridgeTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, Map agentMetrics, IRepository timerDataStructure, IRepository perIntervalDataStructure, IRepository concurrentInvocationDataStructure, IRepository errorsDataStructure, IRepository stallsDataStructure, ProbeInformation info, String nodeType, String ownerType, String appMapName, String btcMapName, String nodeLevel, String boundaryType) {
            super(key, componentName, blameStatus, isStartTrace, parent, previous, start, agentMetrics, timerDataStructure, perIntervalDataStructure, concurrentInvocationDataStructure, errorsDataStructure, stallsDataStructure, info, false, false, Long.MAX_VALUE);
        }

        public WilyBridgeTransactionElement(String component, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start) {
            this(component, component, 0, isStartTrace, parent, previous, start, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }

    public static class AppMapCursor {
        public volatile InvocationData data;
        public CrossCorrelationStringParameterProvider provider;

        AppMapCursor() {
        }

        public void clear() {
            this.data = null;
            this.provider = null;
        }
    }

    private static final class TxnElementRecursionHelper
    implements ITransactionElementCallbackOnRecursion {
        private TxnElementRecursionHelper() {
        }

        @Override
        public boolean doOnElement(ITransactionElement pivot) {
            if (pivot == null) {
                return true;
            }
            if (pivot.isNotValid()) {
                VirtualStack.abortTransaction();
                return true;
            }
            return false;
        }
    }
}

