/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.stalemetric;

import com.google.gson.Gson;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.stalemetric.ApmStaleMetricManager;
import com.wily.introscope.agent.stalemetric.StaleMetricLogger;
import com.wily.introscope.agent.stalemetric.StaleMetricService;
import com.wily.introscope.agent.stalemetric.model.StaleMetricDefinition;
import com.wily.introscope.agent.stalemetric.model.StaleMetricDefinitions;
import com.wily.util.properties.IndexedProperties;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class ApmStaleMetricService
implements StaleMetricService {
    private static final String staleMetriPrefixPropertyKey = "introscope.agent.stalemetrics.";
    private static final StaleMetricService INSTANCE = new ApmStaleMetricService();

    public static StaleMetricService getInstance() {
        return INSTANCE;
    }

    private ApmStaleMetricService() {
    }

    @Override
    public void registerStaleMetrics() {
        List<StaleMetricDefinitions> staleMetricDefinitionsList = ApmStaleMetricService.getStaleMetricDefinitions();
        for (StaleMetricDefinitions staleMetricDefinitions : staleMetricDefinitionsList) {
            for (StaleMetricDefinition staleMetric : staleMetricDefinitions.getStaleMetricDefinitionList()) {
                try {
                    staleMetric.updateOperatorAndValue();
                    if (staleMetric.getPollIntervalInSecs() > 0L && staleMetric.getExpiryAfterNumOfPoll() > 0L) {
                        ApmStaleMetricManager.getInstance().registerStaleMetric(staleMetric);
                        continue;
                    }
                    StaleMetricLogger.getLogger().warn(String.format("Ignoring stale metric definition for %s due to invalid values for pollIntervalInSecs/expiryAfterNumOfPoll", staleMetric.getStaleMetricRegex()));
                }
                catch (Exception exp) {
                    StaleMetricLogger.getLogger().warn("Error while processing stale metric definition. Exception: " + exp);
                }
            }
        }
    }

    private static List<StaleMetricDefinitions> getStaleMetricDefinitions() {
        ArrayList<StaleMetricDefinitions> staleMetricDefinitionsList = new ArrayList<StaleMetricDefinitions>();
        try {
            IndexedProperties properties = AgentShim.getAgent().IAgent_getIndexedProperties();
            for (String propkey : properties.getAllKeys()) {
                if (!propkey.startsWith(staleMetriPrefixPropertyKey)) continue;
                String staleMetricFilePath = properties.getProperty(propkey);
                StaleMetricLogger.getLogger().info("Processing property: " + propkey + " value: " + staleMetricFilePath);
                try {
                    File staleMetricFile = new File(staleMetricFilePath);
                    if (!staleMetricFile.exists()) continue;
                    StaleMetricDefinitions staleMetricDefinitions = (StaleMetricDefinitions)new Gson().fromJson((Reader)new FileReader(staleMetricFile), StaleMetricDefinitions.class);
                    StaleMetricLogger.getLogger().info("stale metric json file parsed succesfully - " + staleMetricFile);
                    staleMetricDefinitionsList.add(staleMetricDefinitions);
                }
                catch (Exception exp) {
                    StaleMetricLogger.getLogger().warn("Error while loading stale metric json file. Exception: " + exp);
                }
            }
        }
        catch (Exception exp) {
            StaleMetricLogger.getLogger().warn("Error while loading stale metric definitions. Exception: " + exp);
        }
        return staleMetricDefinitionsList;
    }
}

