/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlparamagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.sqlagent.StatementToSQLMappingTracer;
import com.wily.introscope.agent.sqlagent.hc2.StatementToConnectionMappingTracer;
import com.wily.introscope.agent.sqlparamagent.BucketHolder;
import com.wily.introscope.agent.sqlparamagent.SQLAgentConfiguration;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.introscope.agent.trace.jdbc.SQLNameFormatterUtilities;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class SQLExecuteTraceWithParams
extends ASingleInstanceTracerFactoryHC {
    public final IModuleFeedbackChannel fFeedback;
    public static final Module kModule = SQLAgentConfiguration.kModule;
    public static final String kSQLatInitPrepare = "SQL at Initial Prepare";
    public static final String kTruncatedSuffix = "...";
    public static final String kConnURLParamName = "Connection URL";
    protected final SQLAgentConfiguration fConfiguration;
    private final BucketHolder bucketHolder;
    private final boolean isShutOff;

    public SQLExecuteTraceWithParams(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fConfiguration = SQLAgentConfiguration.getInstance(agent);
        this.bucketHolder = BucketHolder.getInstance(this.fConfiguration);
        this.fFeedback = this.fConfiguration.fFeedback;
        this.isShutOff = !this.fConfiguration.shouldShowSQLParams();
    }

    public boolean ITracerFactory_isShutoff() {
        return this.isShutOff;
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kInstance;
    }

    private Map<String, String> getStatementParameters(PreparedStatement prepStmt, Map<String, String> paramList) {
        String connectionURL;
        Connection conn;
        String sqlString = StatementToSQLMappingTracer.getRawSQL(prepStmt);
        if (paramList == null) {
            paramList = new HashMap<String, String>();
            if (this.fFeedback.isDebugEnabled(kModule)) {
                this.fFeedback.debug(kModule, "Prepared statement has no parameter bindings: " + sqlString);
            }
        }
        if (sqlString != null) {
            if (sqlString.length() < this.fConfiguration.getNormalizedMaxSQLLength()) {
                paramList.put(kSQLatInitPrepare, sqlString);
            } else {
                paramList.put(kSQLatInitPrepare, String.valueOf(sqlString.substring(0, this.fConfiguration.getNormalizedMaxSQLLength())) + kTruncatedSuffix);
            }
        } else if (this.fFeedback.isDebugEnabled(kModule)) {
            this.fFeedback.debug(kModule, "Prepared statement has no raw SQL mapping, class:  " + prepStmt.getClass().getCanonicalName());
        }
        if (this.fConfiguration.shouldShowConnUrl() && (conn = StatementToConnectionMappingTracer.getConnection(prepStmt)) != null && conn != null && (connectionURL = SQLNameFormatterUtilities.getSafeCachedURL(this.fFeedback, conn)) != null) {
            paramList.put(kConnURLParamName, connectionURL);
        }
        return paramList;
    }

    private Map<String, String> handlePreparedStatement(PreparedStatement prepStmt, Map<String, String> params) throws SQLException {
        String sqlStatement;
        Map<String, String> paramList = this.getStatementParameters(prepStmt, params);
        if (params == null) {
            return paramList;
        }
        if (this.fConfiguration.resolveBindParams() && (sqlStatement = paramList.get(kSQLatInitPrepare)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(sqlStatement, "?");
            StringBuilder resolvedPreparedStatement = new StringBuilder();
            int statementCounter = 0;
            while (stringTokenizer.hasMoreTokens()) {
                resolvedPreparedStatement.append(stringTokenizer.nextToken());
                String param = paramList.get("SQL Bind Param" + ++statementCounter);
                if (param == null) continue;
                resolvedPreparedStatement.append((Object)param);
            }
            paramList.put("SQL Resolved", resolvedPreparedStatement.toString());
        }
        return paramList;
    }

    public void ITracer_startTrace(int i, InvocationData invocationdata) {
        final Object fInvObj = invocationdata.getInvocationObject();
        final Map<String, String> paramList = this.bucketHolder.getParamListFromBucket(fInvObj);
        IStackElement previousElement = VirtualStack.peek();
        if (fInvObj instanceof PreparedStatement && previousElement != null) {
            previousElement.setParameterCallback(new IInvocationDataParameterCallback(){

                public void IInvocationDataParameterCallback_addParameters(InvocationData invocationdata, Map map) {
                    try {
                        PreparedStatement prepStmt = (PreparedStatement)fInvObj;
                        Map params = SQLExecuteTraceWithParams.this.handlePreparedStatement(prepStmt, paramList);
                        map.putAll(params);
                        if (map.containsKey(SQLExecuteTraceWithParams.kSQLatInitPrepare)) {
                            map.remove("SQL:");
                        }
                    }
                    catch (SQLException exc) {
                        SQLExecuteTraceWithParams.this.fFeedback.error(kModule, "Caught SQLException while resolving parameters");
                        if (SQLExecuteTraceWithParams.this.fFeedback.isDebugEnabled()) {
                            SQLExecuteTraceWithParams.this.fFeedback.debug(kModule, "SQLException:", (Throwable)exc);
                        }
                    }
                    catch (Error e) {
                        SQLExecuteTraceWithParams.this.fFeedback.error(kModule, "Caught Exception while resolving parameters");
                        if (SQLExecuteTraceWithParams.this.fFeedback.isDebugEnabled()) {
                            SQLExecuteTraceWithParams.this.fFeedback.debug(kModule, "Exception:", (Throwable)e);
                        }
                        throw e;
                    }
                }
            });
        } else if (this.fFeedback.isDebugEnabled(kModule)) {
            this.fFeedback.debug(kModule, "SQLExecuteTraceWithParams no previous element to decorate on invocation " + invocationdata.getProbeInformation().getProbeIdentification().getProbeClassName());
        }
    }

    public void ITracer_finishTrace(int i, InvocationData invocationdata) {
    }

    public void doOnStartTrace(int i, IStackElement istackelement, ITransactionElement itransactionelement) {
    }

    public void doOnEndTrace(int i, IStackElement istackelement, ITransactionElement itransactionelement) {
    }

    protected void doOnAbortedTransactionEndTrace(int i, IStackElement istackelement) {
    }
}

