/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feature;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorReportingService;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.VirtualStackFeatureHelper;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.WrappedInvocationData;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IFaultSubscriber;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.StackRecursionHelper;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.FaultedBlameTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import java.util.Map;

public class FaultFeature {
    private static String kFaultsAttr = "SOAP Faults Per Interval";
    private static String faultsAttrSuffix = ":" + kFaultsAttr;

    public static TransactionComponentData fetchFaultSnapshot(InvocationData data, String faultMessage) {
        Thread t = Thread.currentThread();
        return VirtualStackFeatureHelper.getTransactionSnapshotFromStack(data, t, null, faultMessage);
    }

    public static void constructAndSendFaultSnapshotToServer(InvocationData data, String faultMsg, IAgent agent) {
        if (!FaultFeature.evalErrorQualificationForCurrTxn(faultMsg)) {
            return;
        }
        TransactionComponentData tcdata = FaultFeature.fetchFaultSnapshot(data, faultMsg);
        if (tcdata != null) {
            agent.IAgent_queueEvent(tcdata);
        } else if (agent.IAgent_getModuleFeedback().isDebugEnabled()) {
            agent.IAgent_getModuleFeedback().debug("FaultFeature: constructAndSendFaultSnapshotToServer failed since the fault snapshot was null");
        }
    }

    public static void decorateTransactionsWithFault(InvocationData data, String faultMsg) {
        if (!FaultFeature.evalErrorQualificationForCurrTxn(faultMsg)) {
            return;
        }
        if (WilyTransactionStructure.getInstance().shouldTraceTransactionInstances(data)) {
            data.put("Extra Error Message", faultMsg);
            data.setParameterCallback(new IInvocationDataParameterCallback(){

                @Override
                public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
                    parameters.put("Extra Error Message", data.get("Extra Error Message"));
                }
            });
        }
    }

    public static void incrementFaultMetric(InvocationData data) {
        String faultMsg = ErrorFeature.fetchErrorMessage(data);
        if (ErrorReportingService.shouldIgnore(faultMsg)) {
            return;
        }
        FaultFeature.incrementSelfRepository(data);
        FaultFeature.incrementUpstreamRepositories(data);
    }

    public static void incrementFaultMetric(FaultedBlameTransactionElement faultElement, IStackElement stackData) {
        IRepository sds;
        String faultMsg;
        if (stackData instanceof InvocationData && ErrorReportingService.shouldIgnore(faultMsg = ErrorFeature.fetchErrorMessage((InvocationData)stackData))) {
            return;
        }
        IFaultSubscriber faultSub = faultElement.getFaultSubscriber();
        if (faultSub != null && (sds = faultSub.getLocalFaultRepository()) != null) {
            int hashcode = stackData.hashCode();
            sds.update(BlamePointTracer.getIncreaser(), 0L, stackData.getWallClockFinishTime(), hashcode);
        }
    }

    private static void incrementSelfRepository(InvocationData data) {
        int i = 0;
        while (i < data.getStartCursorsCount()) {
            IRepository sds;
            IFaultSubscriber faultSub;
            ITransactionElement te = data.getStartCursorAt(i);
            if (te != null && (faultSub = te.getFaultSubscriber()) != null && (sds = faultSub.getLocalFaultRepository()) != null) {
                int hashcode = data.hashCode();
                sds.update(BlamePointTracer.getIncreaser(), 0L, data.getWallClockFinishTime(), hashcode);
            }
            ++i;
        }
    }

    private static void incrementUpstreamRepositories(InvocationData data) {
        IStackElement cursorData = data.getParent();
        int stackRecursionCounter = 0;
        while (cursorData != null) {
            if (cursorData instanceof WrappedInvocationData) {
                cursorData = cursorData.getParent();
                continue;
            }
            int i = 0;
            while (i < cursorData.getStartCursorsCount()) {
                IRepository sds;
                IFaultSubscriber faultSub;
                ITransactionElement te = cursorData.getStartCursorAt(i);
                if (te != null && (faultSub = te.getFaultSubscriber()) != null && faultSub.subscribeToDownstreamFaults() && (sds = faultSub.getLocalFaultRepository()) != null) {
                    int hashcode = data.hashCode();
                    sds.update(BlamePointTracer.getIncreaser(), 0L, data.getWallClockFinishTime(), hashcode);
                }
                ++i;
            }
            if (stackRecursionCounter++ > StackRecursionHelper.kMaxRecursive) {
                throw new TransactionTransitionException("Exceeded depth of stack, most likely because the stack is corrupted.");
            }
            cursorData = cursorData.getParent();
        }
    }

    public static FaultedBlameTransactionElement createFaultedBlameTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, Map agentMetrics, IRepository fTimerDataStructure, IRepository fPerIntervalDataStructure, IRepository fConcurrentInvocationDataStructure, IRepository fErrorsDataStructure, IRepository fStallsDataStructure, ProbeInformation info, AgentMetric[] faultMetric) {
        IRepository faultsDataStructure = BlamePointTracer.getCountQueuedRepository(true);
        agentMetrics.put(faultsDataStructure, faultMetric);
        FaultedBlameTransactionElement wte = new FaultedBlameTransactionElement(key, componentName, blameStatus, isStartTrace, parent, previous, start, agentMetrics, fTimerDataStructure, fPerIntervalDataStructure, fConcurrentInvocationDataStructure, fErrorsDataStructure, fStallsDataStructure, faultsDataStructure, info, false, false, false);
        return wte;
    }

    public static FaultedBlameTransactionElement createFaultedBlameTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, Map agentMetrics, IRepository fTimerDataStructure, IRepository fPerIntervalDataStructure, IRepository fConcurrentInvocationDataStructure, IRepository fErrorsDataStructure, IRepository fStallsDataStructure, ProbeInformation info, AgentMetric[] faultMetric, boolean subscribeToDownstreamErrors, boolean subscribeToDownstreamStalls, boolean subscribeToDownstreamFaults, long filterBit) {
        IRepository faultsDataStructure = BlamePointTracer.getCountQueuedRepository(true);
        agentMetrics.put(faultsDataStructure, faultMetric);
        FaultedBlameTransactionElement wte = new FaultedBlameTransactionElement(key, componentName, blameStatus, isStartTrace, parent, previous, start, agentMetrics, fTimerDataStructure, fPerIntervalDataStructure, fConcurrentInvocationDataStructure, fErrorsDataStructure, fStallsDataStructure, faultsDataStructure, info, subscribeToDownstreamErrors, subscribeToDownstreamStalls, subscribeToDownstreamFaults, filterBit);
        return wte;
    }

    public static FaultedBlameTransactionElement createFaultedBlameTransactionElement(Object key, String componentName, int blameStatus, boolean isStartTrace, ITransactionElement parent, IBlameTransactionElement previous, IBlameTransactionElement start, Map agentMetrics, IRepository fTimerDataStructure, IRepository fPerIntervalDataStructure, IRepository fConcurrentInvocationDataStructure, IRepository fErrorsDataStructure, IRepository fStallsDataStructure, ProbeInformation info, AgentMetric[] faultMetric, boolean subscribeToDownstreamErrors, boolean subscribeToDownstreamStalls, boolean subscribeToDownstreamFaults) {
        IRepository faultsDataStructure = BlamePointTracer.getCountQueuedRepository(true);
        agentMetrics.put(faultsDataStructure, faultMetric);
        FaultedBlameTransactionElement wte = new FaultedBlameTransactionElement(key, componentName, blameStatus, isStartTrace, parent, previous, start, agentMetrics, fTimerDataStructure, fPerIntervalDataStructure, fConcurrentInvocationDataStructure, fErrorsDataStructure, fStallsDataStructure, faultsDataStructure, info, subscribeToDownstreamErrors, subscribeToDownstreamStalls, subscribeToDownstreamFaults);
        return wte;
    }

    public static String getFaultsMetricName(String component) {
        return String.valueOf(component) + faultsAttrSuffix;
    }

    public static boolean evalErrorQualificationForCurrTxn(String faultMsg) {
        boolean isErrorQualified = false;
        if (ErrorReportingService.fIsSnapshotEnabled && !ErrorReportingService.shouldIgnore(faultMsg)) {
            isErrorQualified = true;
        }
        return isErrorQualified;
    }
}

