/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.transactiontrace.ABaseCorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.server.transactiontrace.SequenceId;
import com.wily.isengard.util.SerializationUtils;
import java.io.IOException;
import java.util.HashMap;

public class ThreadCorrelationId
extends ABaseCorrelationId {
    public ThreadCorrelationId() {
        this.initializeAgent();
        this.initializeCache();
        this.cache.setIsCrossThreadId(true);
    }

    public ThreadCorrelationId(SharedCrossProcessData initialValue, boolean override) {
        this.initializeAgent();
        String correlationId = null;
        correlationId = initialValue.getCorrelationID();
        if (correlationId == null) {
            this.initializeCache();
        } else {
            if (!override) {
                this.cache.setCorrelationID(correlationId);
            } else {
                this.cache.overrideCorrelationId(correlationId);
            }
            this.cache.setIsCrossThreadId(true);
            this.cache.setDependencyPropagationFlag(initialValue.getDependencyPropagationFlag());
            this.cache.setIncomingCalledByNodeId(initialValue.getOutgoingCallerNodeId());
            this.cache.setIncomingCalledByNodeType(initialValue.getOutgoingCallerNodeType());
            this.cache.createSeqID(initialValue.getSeqID());
            this.cache.setPropagationFlag(initialValue.getPropagationFlag());
            this.cache.setIncomingPropagationFlag(initialValue.getPropagationFlag());
            this.cache.copyOptionalParamsIn(initialValue);
        }
    }

    public ThreadCorrelationId(SharedCrossProcessData initialValue) {
        this(initialValue, false);
    }

    public ThreadCorrelationId(String initialValue) {
        this(initialValue, false);
    }

    public ThreadCorrelationId(String initialValue, boolean override) {
        this.initializeAgent();
        String optionalParam = null;
        optionalParam = this.resolveFixedParams(initialValue, override);
        this.resolveOptionalParams(optionalParam);
    }

    public SharedCrossProcessData getOutgoingNonSerializedCrossProcessData() {
        SharedCrossProcessData outgoingCache = null;
        this.cache.setIsCrossThreadId(true);
        outgoingCache = this.cache.getOutgoingNonSerializedInstance();
        this.cache.doPostCrossProcessCleanup();
        outgoingCache.setPropagationFlag(this.componentTracer.shouldCurrentTraceBePropagated() ? 1 : 0);
        int correlationCount = this.cache.incrementCorrelationCount();
        if (correlationCount == 0) {
            SequenceId seqid = this.cache.getSeqID();
            if (seqid != null) {
                outgoingCache.createSeqID(seqid.incrementOutgoingLevel());
            } else {
                outgoingCache.createSeqID();
            }
            outgoingCache.setOutgoingCallerNodeId(this.cache.getOutgoingCallerNodeId());
            outgoingCache.setOutgoingCallerNodeType(this.cache.getOutgoingCallerNodeType());
        } else {
            outgoingCache.createSeqID(this.cache.getSeqID());
            outgoingCache.setOutgoingCallerNodeId(this.cache.getOutgoingCallerNodeId());
            outgoingCache.setOutgoingCallerNodeType(this.cache.getOutgoingCallerNodeType());
        }
        return outgoingCache;
    }

    public String getOutgoingStringFromInstance() {
        String result = null;
        String params = null;
        this.cache.setPropagationFlag(this.componentTracer.shouldCurrentTraceBePropagated() ? 1 : 0);
        SharedCrossProcessData.SerializableSharedCrossProcessData serObj = this.cache.getOutgoingSerializableInstance();
        if (serObj.optionalParams.size() > 0) {
            try {
                params = SerializationUtils.serializableObjectToString(serObj.optionalParams);
            }
            catch (IOException iOException) {}
        }
        this.cache.doPostCrossProcessCleanup();
        int correlationCount = this.cache.incrementCorrelationCount();
        result = correlationCount == 0 ? String.valueOf(this.getOutGoingFixedParams()) + "," + params : String.valueOf(this.getCurrentOutGoingFixedParams()) + "," + params;
        return result;
    }

    @Override
    protected void resolveOptionalParams(String optionalParams) {
        HashMap params = null;
        if (optionalParams != null) {
            try {
                params = (HashMap)SerializationUtils.getSerializableObjectFromString(optionalParams);
            }
            catch (IOException e) {
                this.getAgentLogger().error(kModule, e.getMessage(), e);
            }
            catch (ClassNotFoundException e) {
                this.getAgentLogger().error(kModule, e.getMessage(), e);
            }
            catch (Exception e) {
                this.getAgentLogger().error(kModule, "Exception while resolving optional parameters", e);
            }
            if (params != null) {
                this.cache.copyOptionalParamsIn(params);
            }
        }
    }
}

