/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.api;

import com.wily.isengard.IsengardException;
import com.wily.isengard.api.ServerInstanceLocatorPropertiesParser;
import com.wily.isengard.postofficehub.link.net.DefaultSocketFactory;
import com.wily.isengard.postofficehub.link.net.IHTTPSocketFactory;
import com.wily.isengard.postofficehub.link.net.ISSLSocketFactory;
import com.wily.isengard.postofficehub.link.net.ISocketFactory;
import com.wily.isengard.util.parameter.CheckParameter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;

public final class ServerInstanceLocator {
    public static final String kDefaultLocalHostName = "localhost";
    public static final int kDefaultLocalPort = 0;
    private static final String kDisplaySocketCreationProperties = "com.wily.isengard.print.socket.creation.properties";
    private final String fHostName;
    private final int fPort;
    private final ISocketFactory fSocketFactory;
    private String fLocalHostName;
    private int fLocalPort;
    private int fSocketSendBufferSize;
    private int fSocketReceiveBufferSize;
    private boolean fTryIPAddress;
    private IndexedProperties fSocketCreationProperties;
    private IModuleFeedbackChannel fFeedback;

    public ServerInstanceLocator(String hostName, int port, IModuleFeedbackChannel feedback) {
        this(hostName, port, new DefaultSocketFactory(feedback));
        this.fFeedback = feedback;
    }

    public ServerInstanceLocator(String hostName, int port, ISocketFactory socketFactory) {
        CheckParameter.notNull("Server Host Name", hostName);
        CheckParameter.notNull("Socket Factory", socketFactory);
        this.checkPortRange(port);
        this.fHostName = hostName.trim();
        this.fPort = port;
        this.fLocalHostName = kDefaultLocalHostName;
        this.fLocalPort = 0;
        this.fSocketSendBufferSize = 32768;
        this.fSocketReceiveBufferSize = 32768;
        this.fSocketFactory = socketFactory;
        this.fSocketCreationProperties = new IndexedProperties();
    }

    public boolean isHttpTunnelingRequested() {
        return this.getSocketFactory() instanceof IHTTPSocketFactory;
    }

    public SSLContext getSSLContext() {
        if (this.getSocketFactory() instanceof ISSLSocketFactory) {
            ISSLSocketFactory factory = (ISSLSocketFactory)this.getSocketFactory();
            return factory.getSSLContext();
        }
        return null;
    }

    public boolean shouldValidateHostname() {
        if (this.getSocketFactory() instanceof ISSLSocketFactory) {
            ISSLSocketFactory factory = (ISSLSocketFactory)this.getSocketFactory();
            return factory.shouldValidateHostname();
        }
        return false;
    }

    public String[] getCipherSuites() {
        if (this.getSocketFactory() instanceof ISSLSocketFactory) {
            ISSLSocketFactory factory = (ISSLSocketFactory)this.getSocketFactory();
            return factory.getCipherSuites();
        }
        return null;
    }

    public String[] getProtocols() {
        if (this.getSocketFactory() instanceof ISSLSocketFactory) {
            ISSLSocketFactory factory = (ISSLSocketFactory)this.getSocketFactory();
            return factory.getProtocols();
        }
        return null;
    }

    public boolean isSSLRequested() {
        return this.getSocketFactory() instanceof ISSLSocketFactory;
    }

    public String getHostName() {
        return this.fHostName;
    }

    public int getPort() {
        return this.fPort;
    }

    public String getLocalHostName() {
        return this.fLocalHostName;
    }

    public void setLocalHostName(String hostName) {
        if (hostName != null) {
            hostName = hostName.trim();
        }
        if (!kDefaultLocalHostName.equals(hostName)) {
            try {
                InetAddress.getByName(hostName);
            }
            catch (UnknownHostException unknownHostException) {
                throw new IllegalArgumentException("No IP address can be found for the host name: " + hostName);
            }
        }
        this.fLocalHostName = hostName;
    }

    public int getLocalPort() {
        return this.fLocalPort;
    }

    public void setLocalPort(int port) {
        this.checkPortRange(port);
        this.fLocalPort = port;
    }

    public int getSocketReceiveBufferSize() {
        return this.fSocketReceiveBufferSize;
    }

    public void setSocketReceiveBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("illegal buffer size: " + bufferSize);
        }
        this.fSocketReceiveBufferSize = bufferSize;
    }

    public boolean getTryIPAddressFlag() {
        return this.fTryIPAddress;
    }

    public void setTryIPAddressFlag(boolean tryIPAddr) {
        this.fTryIPAddress = tryIPAddr;
    }

    public int getSocketSendBufferSize() {
        return this.fSocketSendBufferSize;
    }

    public void setSocketSendBufferSize(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("illegal buffer size: " + bufferSize);
        }
        this.fSocketSendBufferSize = bufferSize;
    }

    public String getSocketType() {
        return this.getSocketFactory().getSocketType();
    }

    /*
     * Unable to fully structure code
     */
    public Socket createSocket() throws IOException {
        thrownException = null;
        try {
            socket = this.createSocket2(this.getHostName());
            return socket;
        }
        catch (IOException e) {
            thrownException = e;
            addresses = new InetAddress[]{};
            try {
                addresses = InetAddress.getAllByName(this.getHostName());
            }
            catch (UnknownHostException v0) {}
            if (addresses.length < 1 || !this.fTryIPAddress) {
                throw thrownException;
            }
            i = 0;
            ** while (i < addresses.length)
        }
lbl-1000:
        // 1 sources

        {
            ipAddress = addresses[i].getHostAddress();
            try {
                socket = this.createSocket2(ipAddress);
                return socket;
            }
            catch (IOException e) {
                thrownException = e;
                ++i;
            }
            continue;
        }
lbl24:
        // 1 sources

        throw thrownException;
    }

    private Socket createSocket2(String host) throws IOException {
        Socket socket = null;
        socket = this.getLocalHostName().equals(kDefaultLocalHostName) && this.getLocalPort() == 0 ? this.getSocketFactory().createSocket(host, this.getPort()) : this.getSocketFactory().createSocket(host, this.getPort(), InetAddress.getByName(this.getLocalHostName()), this.getLocalPort());
        if (socket != null && this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
            this.fFeedback.debug("Do not set Send/Receive Buffer Size. Keep original values: " + socket.getSendBufferSize() + "/" + socket.getReceiveBufferSize());
        }
        return socket;
    }

    public IndexedProperties getSocketCreationProperties() {
        return this.getDefensiveCopy(this.fSocketCreationProperties);
    }

    public void setSocketCreationProperties(IndexedProperties properties) {
        CheckParameter.notNull("Properties", properties);
        this.fSocketCreationProperties = this.getDefensiveCopy(properties);
        if (Boolean.getBoolean(kDisplaySocketCreationProperties)) {
            System.out.println("Isengard socket creation properties: " + this.fSocketCreationProperties);
        }
    }

    public static ServerInstanceLocator valueOf(String hostPortAndSocketFactory, IndexedProperties properties, IModuleFeedbackChannel feedback) {
        CheckParameter.notNull("String Representation of Socket Factory", hostPortAndSocketFactory);
        CheckParameter.notNull("Properties", properties);
        CheckParameter.notNull("Feedback Channel", feedback);
        int index1 = hostPortAndSocketFactory.indexOf(58);
        int index2 = hostPortAndSocketFactory.indexOf(44);
        String host = hostPortAndSocketFactory.substring(0, index1);
        int port = Integer.parseInt(hostPortAndSocketFactory.substring(index1 + 1, index2));
        String className = hostPortAndSocketFactory.substring(index2 + 1);
        ServerInstanceLocatorPropertiesParser.setServerHostNameProperty(properties, host);
        ServerInstanceLocatorPropertiesParser.setServerPortProperty(properties, port);
        ServerInstanceLocatorPropertiesParser.setSocketFactoryProperty(properties, className);
        ServerInstanceLocatorPropertiesParser parser = null;
        try {
            parser = new ServerInstanceLocatorPropertiesParser(properties, false, null, feedback);
        }
        catch (IsengardException isengardException) {
            throw new RuntimeException("Unable to parse Isengard client properties file.");
        }
        return parser.getServerInstanceLocator();
    }

    public static ServerInstanceLocator copyOf(String host, int port, ServerInstanceLocator original) {
        CheckParameter.notNull("HostName", host);
        CheckParameter.notNull("ServerInstanceLocator", original);
        ServerInstanceLocator locator = new ServerInstanceLocator(host, port, original.getSocketFactory());
        locator.setLocalHostName(original.getLocalHostName());
        locator.setLocalPort(original.getLocalPort());
        locator.setSocketSendBufferSize(original.getSocketSendBufferSize());
        locator.setSocketReceiveBufferSize(original.getSocketReceiveBufferSize());
        locator.setSocketCreationProperties(original.getSocketCreationProperties());
        return locator;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getHostName() != null && this.getHostName().indexOf(58) != -1 ? "[" + this.getHostName() + "]" : this.getHostName()).append(":").append(this.getPort()).append(",").append(this.getSocketFactory().getClass().getName());
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerInstanceLocator)) {
            return false;
        }
        ServerInstanceLocator compareTo = (ServerInstanceLocator)o;
        return this.getHostName().equals(compareTo.getHostName()) && this.getPort() == compareTo.getPort() && this.getLocalHostName().equals(compareTo.getLocalHostName()) && this.getLocalPort() == compareTo.getLocalPort() && this.isHttpTunnelingRequested() == compareTo.isHttpTunnelingRequested() && this.getSocketSendBufferSize() == compareTo.getSocketSendBufferSize() && this.getSocketReceiveBufferSize() == compareTo.getSocketReceiveBufferSize() && this.getSocketFactory().getClass().getName().equals(compareTo.getSocketFactory().getClass().getName());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getHostName().hashCode();
        result = 37 * result + this.getPort();
        result = 37 * result + this.getLocalHostName().hashCode();
        result = 37 * result + this.getLocalPort();
        result = 37 * result + (this.isHttpTunnelingRequested() ? 1 : 0);
        result = 37 * result + this.getSocketSendBufferSize();
        result = 37 * result + this.getSocketReceiveBufferSize();
        result = 37 * result + this.getSocketFactory().getClass().getName().hashCode();
        return result;
    }

    private ISocketFactory getSocketFactory() {
        return this.fSocketFactory;
    }

    private IndexedProperties getDefensiveCopy(IndexedProperties properties) {
        return IndexedProperties.newInstance(properties);
    }

    private void checkPortRange(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
    }
}

