/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.lockable;

import com.wily.util.properties.lockable.LockableFileManager;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResourceReader;
import com.wily.util.resource.IResourceWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;

public class LockableFileBasedResource
extends FileBasedResource {
    private LockableFileManager fLockManager;
    private static final int kNumberFileOpenRetries = 5;

    public LockableFileBasedResource(String source, LockableFileManager manager) {
        super(source);
        this.fLockManager = manager;
    }

    @Override
    public InputStream IResource_getContents() throws IOException {
        int i = 1;
        while (i <= 5) {
            try {
                if (this.fLockManager.getUpdatingLockFile().exists()) {
                    FileBasedResource backup = new FileBasedResource(this.fLockManager.getBackupFileLocation());
                    return backup.IResource_getContents();
                }
                return super.IResource_getContents();
            }
            catch (IOException e) {
                if (i == 5) {
                    throw e;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public FileReader IResource_getSourceContents() throws IOException {
        int i = 1;
        while (i <= 5) {
            try {
                if (this.fLockManager.getUpdatingLockFile().exists()) {
                    FileBasedResource backup = new FileBasedResource(this.fLockManager.getBackupFileLocation());
                    return backup.IResource_getSourceContents();
                }
                return super.IResource_getSourceContents();
            }
            catch (IOException e) {
                if (i == 5) {
                    throw e;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public IResourceReader IResource_getResourceReader() {
        return null;
    }

    @Override
    public IResourceWriter IResource_getResourceWriter() {
        return null;
    }
}

