/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;

public class Logger {
    private static final Module MODULE = new Module("IntelligentInstrumentation");
    private static IAgent agent = null;
    private static ILoggingHandler delegate = new NoOpLoggingHandler();

    static {
        IAgent agent = Logger.getAgent();
        if (agent != null) {
            delegate = new LoggingHandler(MODULE, agent);
        }
    }

    public static void logException(Exception e) {
        delegate.logException(e);
    }

    public static void logException(String message, Exception e) {
        delegate.logException(message, e);
    }

    public static void logWarningMessage(String message) {
        delegate.logWarningMessage(message);
    }

    public static void logInfoMessage(String message) {
        delegate.logInfoMessage(message);
    }

    public static void logDebugMessage(String message) {
        delegate.logDebugMessage(message);
    }

    public static void logDebugMessage(String message, Throwable e) {
        delegate.logDebugMessage(message, e);
    }

    public static void logTraceMessage(String message) {
        delegate.logTraceMessage(message);
    }

    public static void logTraceMessage(String message, Throwable e) {
        delegate.logTraceMessage(message, e);
    }

    public static void logMessage(String message, SeverityLevel level) {
        delegate.logMessage(message, level);
    }

    public static boolean isWarningEnabled() {
        return delegate.isWarningEnabled();
    }

    public static boolean isInfoEnabled() {
        return delegate.isInfoEnabled();
    }

    public static boolean isDebugEnabled() {
        return delegate.isDebugEnabled();
    }

    public static boolean isTraceEnabled() {
        return delegate.isTraceEnabled();
    }

    public static IAgent getAgent() {
        if (agent == null) {
            try {
                agent = AgentShim.getAgent();
            }
            catch (AgentNotAvailableException e) {
                AgentShim.handleError("Error while getting Agent instance for Intelligent Instrumentation Logger", e);
            }
        }
        return agent;
    }

    public static Module getModule() {
        return MODULE;
    }

    public static interface ILoggingHandler {
        public void logException(Exception var1);

        public void logException(String var1, Exception var2);

        public void logError(String var1);

        public void logWarningMessage(String var1);

        public void logInfoMessage(String var1);

        public void logDebugMessage(String var1);

        public void logDebugMessage(String var1, Throwable var2);

        public void logTraceMessage(String var1);

        public void logTraceMessage(String var1, Throwable var2);

        public void logMessage(String var1, SeverityLevel var2);

        public boolean isWarningEnabled();

        public boolean isInfoEnabled();

        public boolean isDebugEnabled();

        public boolean isTraceEnabled();

        public Module getModule();
    }

    public static class LoggingHandler
    implements ILoggingHandler {
        private Module fModule = null;
        private IAgent fAgent = null;

        public LoggingHandler(String moduleName, IAgent agent) {
            if (moduleName != null) {
                this.fModule = new Module(moduleName);
            }
            this.fAgent = agent;
        }

        public LoggingHandler(Module module, IAgent agent) {
            this.fModule = module;
            this.fAgent = agent;
        }

        @Override
        public void logException(Exception e) {
            this.fAgent.IAgent_getModuleFeedback().error(this.fModule, "An unexpected error occurred", e);
        }

        @Override
        public void logException(String message, Exception e) {
            this.fAgent.IAgent_getModuleFeedback().error(this.fModule, message, e);
        }

        @Override
        public void logError(String message) {
            this.fAgent.IAgent_getModuleFeedback().error(this.fModule, message);
        }

        private void logExceptionDebugLevel(Exception e) {
            if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled(this.fModule)) {
                this.fAgent.IAgent_getModuleFeedback().debug(this.fModule, e.toString(), e);
            }
        }

        @Override
        public void logWarningMessage(String message) {
            this.fAgent.IAgent_getModuleFeedback().warn(this.fModule, message);
        }

        @Override
        public void logInfoMessage(String message) {
            this.fAgent.IAgent_getModuleFeedback().info(this.fModule, message);
        }

        @Override
        public void logDebugMessage(String message) {
            this.fAgent.IAgent_getModuleFeedback().debug(this.fModule, message);
        }

        @Override
        public void logDebugMessage(String message, Throwable e) {
            this.fAgent.IAgent_getModuleFeedback().debug(this.fModule, message);
            this.fAgent.IAgent_getModuleFeedback().debug(this.fModule, e.toString(), e);
        }

        @Override
        public void logTraceMessage(String message) {
            this.fAgent.IAgent_getModuleFeedback().trace(this.fModule, message);
        }

        @Override
        public void logTraceMessage(String message, Throwable e) {
            this.fAgent.IAgent_getModuleFeedback().trace(this.fModule, message);
            this.fAgent.IAgent_getModuleFeedback().trace(this.fModule, e.toString(), e);
        }

        @Override
        public void logMessage(String message, SeverityLevel level) {
            if (level.compareTo(SeverityLevel.ERROR) == 0) {
                this.fAgent.IAgent_getModuleFeedback().error(this.fModule, message);
            } else if (level.compareTo(SeverityLevel.WARN) == 0) {
                this.fAgent.IAgent_getModuleFeedback().warn(this.fModule, message);
            } else if (level.compareTo(SeverityLevel.INFO) == 0) {
                this.fAgent.IAgent_getModuleFeedback().info(this.fModule, message);
            } else if (level.compareTo(SeverityLevel.VERBOSE) == 0) {
                this.fAgent.IAgent_getModuleFeedback().verbose(this.fModule, message);
            } else if (level.compareTo(SeverityLevel.DEBUG) == 0) {
                this.fAgent.IAgent_getModuleFeedback().debug(this.fModule, message);
            } else if (level.compareTo(SeverityLevel.TRACE) == 0) {
                this.fAgent.IAgent_getModuleFeedback().trace(this.fModule, message);
            }
        }

        @Override
        public boolean isWarningEnabled() {
            return this.fAgent.IAgent_getModuleFeedback().isWarningEnabled(this.fModule);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.fAgent.IAgent_getModuleFeedback().isInfoEnabled(this.fModule);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.fAgent.IAgent_getModuleFeedback().isDebugEnabled(this.fModule);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.fAgent.IAgent_getModuleFeedback().isTraceEnabled(this.fModule);
        }

        @Override
        public Module getModule() {
            return this.fModule;
        }
    }

    public static class NoOpLoggingHandler
    implements ILoggingHandler {
        @Override
        public void logException(Exception e) {
        }

        @Override
        public void logException(String message, Exception e) {
        }

        @Override
        public void logError(String message) {
        }

        @Override
        public void logWarningMessage(String message) {
        }

        @Override
        public void logInfoMessage(String message) {
        }

        @Override
        public void logDebugMessage(String message) {
        }

        @Override
        public void logDebugMessage(String message, Throwable e) {
        }

        @Override
        public void logTraceMessage(String message) {
        }

        @Override
        public void logTraceMessage(String message, Throwable e) {
        }

        @Override
        public void logMessage(String message, SeverityLevel level) {
        }

        @Override
        public boolean isWarningEnabled() {
            return false;
        }

        @Override
        public boolean isInfoEnabled() {
            return false;
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public Module getModule() {
            return new Module("noop");
        }
    }
}

