/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.connector;

import com.wily.introscope.autoprobe.connector.AutoProbeConnectorCreatorEnvironment;
import com.wily.util.commandline.ACommandLineParser;
import com.wily.util.commandline.CommandLine;
import com.wily.util.commandline.ICommandLineParser;
import com.wily.util.commandline.ParsingException;
import com.wily.util.text.IStringLocalizer;
import java.io.PrintWriter;
import java.util.ArrayList;

public final class AutoProbeConnectorCreatorCommandLine
extends CommandLine {
    private static final String[] kHelpOptions = new String[]{"-help", "-h", "-?"};
    private static final String[] kCurrentJVMOptions = new String[]{"-current"};
    private static final String[] kJVMDirectoryOptions = new String[]{"-jvm"};
    private static final String[] kOutputLocationOptions = new String[]{"-output"};
    private final IStringLocalizer fStringLocalizer;
    private final AutoProbeConnectorCreatorEnvironment fAutoProbeConnectorCreatorEnvironment;

    public AutoProbeConnectorCreatorCommandLine(String[] commandLineStrings, IStringLocalizer localizer) throws ParsingException {
        super(commandLineStrings);
        this.fStringLocalizer = localizer;
        this.fAutoProbeConnectorCreatorEnvironment = new AutoProbeConnectorCreatorEnvironment(localizer);
        ArrayList<ACommandLineParser> parserList = new ArrayList<ACommandLineParser>();
        parserList.add(new HelpParser());
        parserList.add(new CurrentJVMParser());
        parserList.add(new JVMDirectoryParser());
        parserList.add(new OutputLocationParser());
        ICommandLineParser[] parsers = parserList.toArray(new ICommandLineParser[parserList.size()]);
        this.setParsers(parsers);
        this.parse();
    }

    public final AutoProbeConnectorCreatorEnvironment getAutoProbeConnectorCreatorEnvironment() {
        return this.fAutoProbeConnectorCreatorEnvironment;
    }

    public final IStringLocalizer getStringLocalizer() {
        return this.fStringLocalizer;
    }

    public void printHelp(PrintWriter output) {
        output.println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Help_Body"));
        output.println(this.getStringLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Options_Header"));
        this.iterateParserHelp(output);
        output.flush();
    }

    private class CurrentJVMParser
    extends ACommandLineParser {
        public CurrentJVMParser() {
            super(kCurrentJVMOptions);
        }

        @Override
        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            AutoProbeConnectorCreatorEnvironment env = AutoProbeConnectorCreatorCommandLine.this.getAutoProbeConnectorCreatorEnvironment();
            if (env.useCurrentJVM()) {
                AutoProbeConnectorCreatorCommandLine.this.throwParsingException(AutoProbeConnectorCreatorCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Specified_Only_Once", currentCommand));
            }
            env.setUseCurrentJVM(true);
        }

        @Override
        public String ISingleCommandHelpProvider_getHelpText() {
            return AutoProbeConnectorCreatorCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Help_Current_JVM_Command");
        }
    }

    private class HelpParser
    extends ACommandLineParser {
        public HelpParser() {
            super(kHelpOptions);
        }

        @Override
        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) {
            AutoProbeConnectorCreatorCommandLine.this.getAutoProbeConnectorCreatorEnvironment().setShowHelp(true);
        }

        @Override
        public String ISingleCommandHelpProvider_getHelpText() {
            return AutoProbeConnectorCreatorCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Help_Help_Command");
        }
    }

    private class JVMDirectoryParser
    extends ACommandLineParser {
        public JVMDirectoryParser() {
            super(kJVMDirectoryOptions);
        }

        @Override
        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String jvmDirectory = AutoProbeConnectorCreatorCommandLine.this.consumeNextCommand(AutoProbeConnectorCreatorCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Missing_Argument", currentCommand));
            AutoProbeConnectorCreatorEnvironment env = AutoProbeConnectorCreatorCommandLine.this.getAutoProbeConnectorCreatorEnvironment();
            if (env.hasJVMDirectory()) {
                AutoProbeConnectorCreatorCommandLine.this.throwParsingException(AutoProbeConnectorCreatorCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Specified_Only_Once", currentCommand));
            }
            env.setJVMDirectory(jvmDirectory);
        }

        @Override
        public String ISingleCommandHelpProvider_getArgumentPrompt() {
            return AutoProbeConnectorCreatorCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Help_Directory_Argument");
        }

        @Override
        public String ISingleCommandHelpProvider_getHelpText() {
            return AutoProbeConnectorCreatorCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Help_JVM_Directory_Command");
        }
    }

    private class OutputLocationParser
    extends ACommandLineParser {
        public OutputLocationParser() {
            super(kOutputLocationOptions);
        }

        @Override
        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String outputLocation = AutoProbeConnectorCreatorCommandLine.this.consumeNextCommand(AutoProbeConnectorCreatorCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Missing_Argument", currentCommand));
            AutoProbeConnectorCreatorEnvironment env = AutoProbeConnectorCreatorCommandLine.this.getAutoProbeConnectorCreatorEnvironment();
            if (env.hasOutputLocation()) {
                AutoProbeConnectorCreatorCommandLine.this.throwParsingException(AutoProbeConnectorCreatorCommandLine.this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Specified_Only_Once", currentCommand));
            }
            env.setOutputLocation(outputLocation);
        }

        @Override
        public String ISingleCommandHelpProvider_getArgumentPrompt() {
            return AutoProbeConnectorCreatorCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Help_Output_Location_Argument");
        }

        @Override
        public String ISingleCommandHelpProvider_getHelpText() {
            return AutoProbeConnectorCreatorCommandLine.this.getStringLocalizer().IStringLocalizer_getLocalizedString("Auto_Probe_Connector_Creator_Command_Line_Help_Output_Location_Command");
        }
    }
}

