/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.ext.agent.pcf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IEventListener;
import com.wily.introscope.agent.blame.ApplicationNameInfo;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.introscope.ext.agent.pcf.PCFConstants;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public class PCFService
extends ASimpleService
implements PCFConstants {
    IAgent fAgent = null;
    private static Module kModule = new Module("PCFService");
    private ScheduledExecutorService fExecutor;
    private Module fModule = new Module("PCFService");
    private CloudFoundryTraceEventListerner fTraceEventListener;
    private static PCFService fService = null;
    public static boolean fEnabled = true;
    public static long fWorkerPeriod = 60L;
    public static boolean fIsJavaAgentExtension = true;
    public static Integer fMaxTCDSearchCount = 5000;
    private static final String KPCFExtensionEnabled = "com.wily.introscope.agent.pcf.enabled";
    private static final Boolean KPCFExtensionEnabledDefaultValue = true;
    private static final String KPCFWorkerPeriod = "com.wily.introscope.agent.pcf.worker.interval";
    private static final Integer KPCFWorkerPeriodDefaultValue = 60;
    private static final String KPCFIsJavaAgentExtension = "com.wily.introscope.agent.pcf.isjavaagent";
    private static final Boolean KPCFIsJavaAgentExtensionDefaultValue = true;
    private static final String KPCFMaxTCDSearchCount = "com.wily.introscope.agent.pcf.max.tcdsearch.count";
    private static final Integer KKPCFMaxTCDSearchCountDefaultValue = 5000;

    public PCFService() {
        this("PCFService");
    }

    public PCFService(String name) {
        super(name);
        fService = this;
    }

    protected void doStartService(IAgent agent, Map parameters) throws Exception {
        this.fAgent = agent;
        this.fAgent.IAgent_getModuleFeedback().debug("Starting PCFService...");
        this.fAgent.IAgent_getConfigurationManager().add((ConfigurationProperty)new PCFExtensionEnabledProperty(this.fAgent), true);
        this.fAgent.IAgent_getConfigurationManager().add((ConfigurationProperty)new PCFWorkerPeriod(this.fAgent), true);
        this.fAgent.IAgent_getConfigurationManager().add((ConfigurationProperty)new PCFMaxTCDSearchCount(this.fAgent), true);
        if (this.startPCFWorker()) {
            this.fAgent.IAgent_getModuleFeedback().debug("Done Starting PCFService");
        } else {
            this.fAgent.IAgent_getModuleFeedback().debug("Shutting down PCFService as this process is not running within a cloudfoundry container");
        }
    }

    private boolean startPCFWorker() {
        block7: {
            int instanceIndex;
            String vcap;
            block6: {
                this.fExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = Executors.defaultThreadFactory().newThread(r);
                        thread.setDaemon(true);
                        return thread;
                    }
                });
                Map<String, String> env = System.getenv();
                String indexStr = env.get("CF_INSTANCE_INDEX");
                vcap = env.get("VCAP_APPLICATION");
                instanceIndex = -1;
                try {
                    if (indexStr != null && vcap != null) {
                        instanceIndex = Integer.parseInt(indexStr);
                        break block6;
                    }
                    return false;
                }
                catch (Exception exception) {
                    this.fAgent.IAgent_getModuleFeedback().error("Unable to get  CF_INSTANCE_INDEX property for container!!");
                    this.fAgent.IAgent_getModuleFeedback().error("Cloud Foundry Application Container Daemon did not start !!");
                }
            }
            String applicationID = "DefaultAppID";
            String applicationName = "DefaultApp";
            try {
                applicationID = this.getCFEnvironmentVariable(vcap, "application_id");
                applicationName = this.getCFEnvironmentVariable(vcap, "application_name");
                if (applicationID != null && applicationName != null) {
                    ApplicationNameInfo.setGlobalApplicationName((String)applicationName, (String)"Pivotal Cloud Foundry");
                    this.fTraceEventListener = new CloudFoundryTraceEventListerner(this.fAgent, applicationID, applicationName, instanceIndex);
                    this.fAgent.addTransactionTraceEventPostProcessor((IEventListener)this.fTraceEventListener);
                    this.fAgent.IAgent_getModuleFeedback().info("Cloud Foundry Application Container trace event listener registered successfully");
                    break block7;
                }
                return false;
            }
            catch (Exception exception) {
                this.fAgent.IAgent_getModuleFeedback().error("Could not get Application ID and name");
                return false;
            }
        }
        return false;
    }

    private String getCFEnvironmentVariable(String vcap, String CF_VAR) {
        int beginIndex;
        String cfValue = null;
        int endIndex = -1;
        if (vcap != null && (beginIndex = vcap.indexOf(CF_VAR)) > -1) {
            this.fAgent.IAgent_getModuleFeedback().debug("VCAP Begin index:" + beginIndex + " of -" + vcap);
            endIndex = vcap.indexOf(44, beginIndex + CF_VAR.length());
            this.fAgent.IAgent_getModuleFeedback().debug("VCAP AppID End index:" + endIndex);
            if (endIndex > beginIndex) {
                cfValue = vcap.substring(beginIndex + CF_VAR.length() + 3, endIndex - 1);
                this.fAgent.IAgent_getModuleFeedback().debug("Retreived application ID, prefixing " + cfValue);
            } else {
                this.fAgent.IAgent_getModuleFeedback().debug("Failed to get application ID, prefixing " + cfValue);
            }
        }
        return cfValue;
    }

    public static PCFService getService() {
        return fService;
    }

    public static class CloudFoundryTraceEventListerner
    implements IEventListener {
        private String fContainerID;
        private String fApplicationID;
        private String fApplicationName;
        IAgent fAgent;

        public CloudFoundryTraceEventListerner(IAgent agent, String applicationID, String applicationName, int containerIndex) {
            this.fAgent = agent;
            this.fApplicationID = applicationID;
            this.fApplicationName = applicationName;
            this.fContainerID = String.valueOf(this.fApplicationID) + ":" + applicationName + ":" + String.valueOf(containerIndex);
        }

        public void noticeEvent(TransactionComponentData root) {
            if (this.fAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                this.fAgent.IAgent_getModuleFeedback().trace("CF Container trace event:");
            }
            root.setParameterValue("ATTR_cf_container_index", this.fContainerID);
            root.setParameterValue("TTPlugin.globalAttribute.cf_container_index", this.fContainerID);
            if (this.fAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                this.fAgent.IAgent_getModuleFeedback().trace("CF Container trace event: root - " + this.fContainerID);
            }
            TransactionComponentData urlTcd = root;
            String url = urlTcd.getParameterValue("URL");
            int tcdCount = 0;
            while (tcdCount < fMaxTCDSearchCount && urlTcd != null && (url == null || url.length() < 1)) {
                url = urlTcd.getParameterValue("URL");
                if (urlTcd == null || urlTcd.getSubNodeCount() <= 0) break;
                urlTcd = (TransactionComponentData)urlTcd.getSubNode(0);
                if (this.fAgent.IAgent_getModuleFeedback().isTraceEnabled()) {
                    this.fAgent.IAgent_getModuleFeedback().info("CF Container trace event: tcdCount - " + tcdCount + url);
                }
                ++tcdCount;
            }
            if (urlTcd != null) {
                String paramName = "TTPlugin.globalAttribute.cor.cf_container_index.contains.to";
                urlTcd.setParameterValue("ATTR_cf_container_index", this.fContainerID);
                urlTcd.setParameterValue(paramName, this.fContainerID);
            }
        }
    }

    private static class PCFExtensionEnabledProperty
    extends BooleanConfigurationProperty {
        public PCFExtensionEnabledProperty(IAgent agent) {
            super(PCFService.KPCFExtensionEnabled, KPCFExtensionEnabledDefaultValue, "PCF Worker period", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fEnabled = (Boolean)newValue;
        }
    }

    private static class PCFMaxTCDSearchCount
    extends IntegerConfigurationProperty {
        public PCFMaxTCDSearchCount(IAgent agent) {
            super(PCFService.KPCFMaxTCDSearchCount, KKPCFMaxTCDSearchCountDefaultValue, "PCF Max TCD Search Count", null, true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fMaxTCDSearchCount = (Integer)newValue;
        }
    }

    private static class PCFWorkerPeriod
    extends IntegerConfigurationProperty {
        public PCFWorkerPeriod(IAgent agent) {
            super(PCFService.KPCFWorkerPeriod, KPCFWorkerPeriodDefaultValue, "Summary Trace Delivery period", null, true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fWorkerPeriod = ((Integer)newValue).intValue();
        }
    }
}

