/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.launch.core;

import com.wily.introscope.agent.launch.core.BaseAgentParamValidator;
import com.wily.introscope.agent.launch.core.BootstrapAgentLogger;
import com.wily.introscope.agent.launch.core.Logger;
import com.wily.introscope.agent.launch.util.BootstrapAgentConstants;
import com.wily.introscope.agent.launch.util.BootstrapAgentUtil;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;

public class AgentProfileHandler
extends BaseAgentParamValidator
implements BootstrapAgentConstants {
    private static final Logger LOGGER = BootstrapAgentLogger.getLogger();

    public AgentProfileHandler(String key) {
        super(key);
    }

    public static void handleAgentProfile(Map<String, String> startupParams) {
        String profileParam = System.getProperty("com.wily.introscope.agentProfile");
        if (profileParam != null) {
            LOGGER.fine("Found agent profile system property: " + profileParam);
            String profileAbsoluteLocn = profileParam;
            String jarLocation = startupParams.get("core.agent.jar.location");
            String pathToAgentCoreDir = new File(jarLocation).getParentFile().getAbsolutePath();
            startupParams.put("agent.core.dir.path", pathToAgentCoreDir);
            if (BootstrapAgentUtil.isProfileLocationAbsolute(profileParam)) {
                boolean useProfileFromConfigDir;
                LOGGER.fine("Profile being passed is an absolute profile location");
                String useProfileFromConfigDirParam = startupParams.get("UseProfileFromConfigDirIfMatch".toLowerCase());
                boolean bl = useProfileFromConfigDir = useProfileFromConfigDirParam != null && Boolean.parseBoolean(useProfileFromConfigDirParam);
                if (useProfileFromConfigDir) {
                    LOGGER.fine("Parameter UseProfileFromConfigDirIfMatch set to true. Looking for a matching profile inside the config directory");
                    profileAbsoluteLocn = AgentProfileHandler.useProfileFromConfigDir(profileAbsoluteLocn, pathToAgentCoreDir);
                }
            } else {
                profileAbsoluteLocn = AgentProfileHandler.createFullProfilePath(pathToAgentCoreDir, profileParam);
                LOGGER.fine("Inside AgentProfileHandler.handleAgentProfile() absolute location of Agent profile is :" + profileAbsoluteLocn);
            }
            if (BootstrapAgentUtil.fileExists(profileAbsoluteLocn)) {
                startupParams.put("absolute.profile.location", profileAbsoluteLocn);
            } else {
                LOGGER.warning(String.format("Agent profile %s does not exist", profileAbsoluteLocn));
            }
        }
    }

    private static String useProfileFromConfigDir(String profileAbsoluteLocn, String pathToAgentCoreDir) {
        String matchingLocation = AgentProfileHandler.findAMatchingConfigDirProfile(profileAbsoluteLocn, pathToAgentCoreDir);
        if (matchingLocation != null) {
            LOGGER.info("Found a matching profile inside config directory. Agent will use the profile" + matchingLocation);
            profileAbsoluteLocn = matchingLocation;
        } else {
            LOGGER.info("Unable to find a matching profile inside config directory. Agent will use the specified profile location " + profileAbsoluteLocn);
        }
        return profileAbsoluteLocn;
    }

    @Override
    public boolean handleNoValueFound(Map<String, String> startupParams) {
        String jarLocation = startupParams.get("core.agent.jar.location");
        if (jarLocation != null) {
            String pathToAgentCoreDir = new File(jarLocation).getParentFile().getAbsolutePath();
            startupParams.put("agent.core.dir.path", pathToAgentCoreDir);
            boolean agentNoRedefBeingUsed = BootstrapAgentUtil.isAgentNoReDefUsed(startupParams);
            String profileAbsoluteLocn = AgentProfileHandler.createFullProfilePath(pathToAgentCoreDir, "IntroscopeAgent.profile");
            if (!new File(profileAbsoluteLocn).exists() && agentNoRedefBeingUsed) {
                profileAbsoluteLocn = AgentProfileHandler.createFullProfilePath(pathToAgentCoreDir, "IntroscopeAgent.NoRedef.profile");
            }
            startupParams.put("absolute.profile.location", profileAbsoluteLocn);
            LOGGER.fine("Could not find valid profile passed as system property. So using the default profile: " + profileAbsoluteLocn);
        }
        return true;
    }

    public static String findAMatchingConfigDirProfile(String profileAbsoluteLocn, String pathToAgentCoreDir) {
        String pattern = Pattern.quote(FILE_SEPARATOR);
        String[] tokens = profileAbsoluteLocn.split(pattern);
        String profileName = tokens[tokens.length - 1];
        String matchingProfileInsideConfigDir = AgentProfileHandler.createFullProfilePath(pathToAgentCoreDir, profileName);
        if (BootstrapAgentUtil.fileExists(matchingProfileInsideConfigDir)) {
            return matchingProfileInsideConfigDir;
        }
        return null;
    }

    private static String createFullProfilePath(String pathToCoreAgent, String profileName) {
        return String.valueOf(pathToCoreAgent) + FILE_SEPARATOR + "core" + FILE_SEPARATOR + "config" + FILE_SEPARATOR + profileName;
    }
}

