/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.jmx.CompositeDataJMXDataView;
import com.wily.introscope.agent.jmx.IntJMXDataView;
import com.wily.introscope.agent.jmx.JMXClamp;
import com.wily.introscope.agent.jmx.JMXDelegatingService;
import com.wily.introscope.agent.jmx.LongJMXDataView;
import com.wily.introscope.agent.jmx.RateCounterJMXDataView;
import com.wily.introscope.agent.jmx.StringJMXDataView;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public final class DataViewFactory {
    static final int kIntViewType = 1;
    static final int kLongViewType = 2;
    static final int kStringViewType = 3;
    static final int kConpositeDataViewType = 4;

    public static AJMXDataView createView(IAgent agent, ObjectName mbeanName, String jmxAttributeType, String jmxAttributeName, MBeanServer server, String fullIntroscopeMetricName, boolean excludeStringMetrics, boolean includeRateCounterMetrics, Object attKey) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        if (JMXClamp.getInstance(agent).isClampHit()) {
            JMXClamp.getInstance(agent).printClampWarning();
            return null;
        }
        JMXClamp.getInstance(agent).incrementMetricCounter();
        int viewType = DataViewFactory.getViewType(jmxAttributeType);
        if (includeRateCounterMetrics) {
            if (viewType == 1 || viewType == 2) {
                return new RateCounterJMXDataView(agent, mbeanName, server, jmxAttributeName, fullIntroscopeMetricName, attKey);
            }
            return null;
        }
        switch (viewType) {
            case 1: {
                return new IntJMXDataView(agent, mbeanName, server, jmxAttributeName, fullIntroscopeMetricName, attKey);
            }
            case 2: {
                return new LongJMXDataView(agent, mbeanName, server, jmxAttributeName, fullIntroscopeMetricName, attKey);
            }
            case 4: {
                if (JMXDelegatingService.sIsJMXCompositeDataEnabled) {
                    return new CompositeDataJMXDataView(agent, mbeanName, server, jmxAttributeName, fullIntroscopeMetricName, attKey);
                }
                return null;
            }
            case 3: {
                if (!excludeStringMetrics) {
                    return new StringJMXDataView(agent, mbeanName, server, jmxAttributeName, fullIntroscopeMetricName, attKey);
                }
                return null;
            }
        }
        return null;
    }

    public static AJMXDataView createView(IAgent agent, ObjectName mbeanName, String jmxAttributeType, String jmxAttributeName, MBeanServer server, String fullIntroscopeMetricName, boolean excludeStringMetrics, boolean includeRateCounterMetrics) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return DataViewFactory.createView(agent, mbeanName, jmxAttributeType, jmxAttributeName, server, fullIntroscopeMetricName, excludeStringMetrics, includeRateCounterMetrics, null);
    }

    public static int getViewType(String inputType) {
        String type = inputType.replace('/', '.');
        if (DataViewFactory.isLongType(type)) {
            return 2;
        }
        if (DataViewFactory.isIntType(type)) {
            return 1;
        }
        if (DataViewFactory.isCompositeType(type)) {
            return 4;
        }
        return 3;
    }

    private static boolean isLongType(String type) {
        return type.equals(Long.TYPE.getName()) || type.equals(Long.class.getName()) || type.equals(Double.TYPE.getName()) || type.equals(Double.class.getName()) || type.equals(Float.TYPE.getName()) || type.equals(Float.class.getName()) || type.equals(Number.class.getName());
    }

    private static boolean isIntType(String type) {
        return type.equals(Short.TYPE.getName()) || type.equals(Short.class.getName()) || type.equals(Integer.TYPE.getName()) || type.equals(Integer.class.getName()) || type.equals(Byte.TYPE.getName()) || type.equals(Byte.class.getName());
    }

    private static boolean isCompositeType(String type) {
        return type.equals(CompositeData.class.getName());
    }
}

