/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.IMBeanServerLocator;
import com.wily.introscope.agent.webappsupport.weblogic.WebLogicMBeanHelper;
import javax.management.MBeanServer;

public class WebLogicMBeanServerLocator
implements IMBeanServerLocator {
    public static final String kDelayConfigProperty = "introscope.agent.jmx.weblogic.startup.poll.delay";
    public static final int kDelayConfigPropertyDefault = 60000;
    private final long fStartPollingTime;

    public WebLogicMBeanServerLocator(IAgent agent) {
        int delay = agent.IAgent_getIndexedProperties().safeGetIntProperty(kDelayConfigProperty, 60000, agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer());
        this.fStartPollingTime = System.currentTimeMillis() + (long)delay;
    }

    public MBeanServer locateWebLogicMBeanServer() {
        MBeanServer mbs = WebLogicMBeanHelper.getWebLogic9MBeanServer();
        if (mbs == null && (mbs = WebLogicMBeanHelper.getWebLogic7Or8MBeanServer()) == null) {
            mbs = WebLogicMBeanHelper.getWebLogic61MBeanServer();
        }
        return mbs;
    }

    @Override
    public MBeanServer[] IMBeanServerLocator_locate() {
        try {
            if (this.fStartPollingTime > System.currentTimeMillis()) {
                return new MBeanServer[0];
            }
            MBeanServer s = this.locateWebLogicMBeanServer();
            if (s == null) {
                return new MBeanServer[0];
            }
            MBeanServer[] result = new MBeanServer[]{s};
            return result;
        }
        catch (Exception exception) {
            return new MBeanServer[0];
        }
    }
}

