/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.netweaver;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;
import com.wily.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NWS6Formatter
extends ANameFormatter {
    private static final String kInput = "input";
    private static final String kOperationName = "operationName";
    private static final String kEndpointUrl = "endpointUrl";
    private static final String kBindingConfig = "bindingConfig";
    private static final String kFeatureConfig = "featureConfig";
    private static final String kTypeMapping = "typeMapping";
    private static final String kNamespace = "namespace";
    private static final String kStyle = "style";
    private static final String kWriteTo = "writeTo";
    private static final String kEnvelope = "Envelope";
    private static final String kBody = "Body";
    private static final String kDocument = "document";
    private static final String kRPC = "rpc";
    private static final String kInitDeserializationMode = "initDeserializationMode";
    private static final String kGetSoapBody = "getSoapBody";

    public NWS6Formatter(IAgent agent) {
        super(agent);
    }

    private Object getBindingConfig(InvocationData data) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object invObj = data.getInvocationParameterAsObject(0);
        Method m = WSMUtils.getMethodForObject(invObj, "getSubContext", new Class[]{String.class});
        Object configObj = m.invoke(invObj, kBindingConfig);
        return configObj;
    }

    @Override
    public String getOperationName(InvocationData data) {
        String name = null;
        try {
            if (data.getInvocationParameterCount() == 3) {
                name = this.queryBindingConfig(data, kOperationName);
            } else if (data.getInvocationParameterCount() == 2) {
                name = this.getOperationKey(data, kOperationName);
            }
        }
        catch (Throwable throwable) {}
        return StringUtils.isEmpty(name) ? "UnknownOperationName" : name;
    }

    @Override
    public String getServiceName(InvocationData data) {
        String name = null;
        try {
            Object configObj = this.getBindingConfig(data);
            Method m = WSMUtils.getMethodForObject(configObj, "getProperty", new Class[]{String.class});
            name = (String)m.invoke(configObj, kEndpointUrl);
            name = WSMUtils.formatURLToBeResourceSafe(name);
        }
        catch (Throwable e) {
            name = "UnknownService";
            WSMUtils.getLogger().error("NWS6Formatter.getServiceName().Unable to get Servicename:" + e);
        }
        return StringUtils.isEmpty((String)name) ? "UnknownService" : name;
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespace = null;
        Object configObj = null;
        try {
            if (data.getInvocationParameterCount() == 3) {
                String style = this.getWSDLStyle(data);
                if (style != null && style.equalsIgnoreCase(kDocument)) {
                    int nSlash;
                    configObj = this.getFeatureConfig(data);
                    Method method = WSMUtils.getMethodForObject(configObj, "getProperty", new Class[]{String.class});
                    Object inputObj = method.invoke(configObj, kTypeMapping);
                    method = WSMUtils.getMethodForObject(inputObj, "getRegisteredElements", null);
                    Enumeration enum_uri = (Enumeration)(inputObj = method.invoke(inputObj, null));
                    namespace = this.getUriFromKey(enum_uri);
                    if (namespace != null && (nSlash = namespace.indexOf("/")) != -1) {
                        int nColIndex = namespace.indexOf(":");
                        namespace = String.valueOf(namespace.substring(0, nColIndex + 1)) + namespace.substring(nSlash + 1);
                    }
                } else if (style != null && style.equalsIgnoreCase(kRPC)) {
                    namespace = this.queryBindingConfig(data, kNamespace);
                }
            } else if (data.getInvocationParameterCount() == 2) {
                namespace = this.getOperationKey(data, kNamespace);
            }
            namespace = WSMUtils.formatURLToBeResourceSafe(namespace);
        }
        catch (Throwable e) {
            WSMUtils.getLogger().error("NWS6Formatter::getNamespace.Unable to getNamespace:" + e);
        }
        return StringUtils.isEmpty((String)namespace) ? "UnknownNamespace" : namespace;
    }

    private Object getFeatureConfig(InvocationData data) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object invObj = data.getInvocationParameterAsObject(0);
        Method m = WSMUtils.getMethodForObject(invObj, "getSubContext", new Class[]{String.class});
        Object configObj = m.invoke(invObj, kFeatureConfig);
        return configObj;
    }

    private String getUriFromKey(Enumeration e) {
        String namespace = "UnknownNamespace";
        try {
            if (e != null) {
                while (e.hasMoreElements()) {
                    Method method;
                    Object key = e.nextElement();
                    if (key == null || (namespace = (String)(method = WSMUtils.getMethodForObject(key, "getNamespaceURI", null)).invoke(key, null)) == null) continue;
                    return namespace;
                }
            }
        }
        catch (Exception ex) {
            WSMUtils.getLogger().error("NWS6Formatter::getUriFromKey.Unable to getUriFromKey:" + ex);
        }
        return namespace == null ? "UnknownNamespace" : namespace;
    }

    private String getWSDLStyle(InvocationData data) {
        String style = null;
        try {
            Object configObj = this.getBindingConfig(data);
            Method method = WSMUtils.getMethodForObject(configObj, "getProperty", new Class[]{String.class});
            style = (String)method.invoke(configObj, kStyle);
        }
        catch (Exception e) {
            WSMUtils.getLogger().error("NWS6Formatter::getWSDLStyle.Unable to getWSDLStyle:" + e);
        }
        return style == null ? kDocument : style;
    }

    private String queryBindingConfig(InvocationData data, String name) {
        try {
            Object configObj = this.getBindingConfig(data);
            Method method = WSMUtils.getMethodForObject(configObj, "getSubContext", new Class[]{String.class});
            Object inputObj = method.invoke(configObj, kInput);
            method = WSMUtils.getMethodForObject(inputObj, "getProperty", new Class[]{String.class});
            if (name != null && name.equalsIgnoreCase(kOperationName)) {
                name = (String)method.invoke(inputObj, kOperationName);
            } else if (name != null && name.equalsIgnoreCase(kNamespace)) {
                name = (String)method.invoke(inputObj, kNamespace);
            }
        }
        catch (Exception e) {
            WSMUtils.getLogger().error("NWS6Formatter::queryBindingConfig.Unable to queryBindingConfig:" + e);
        }
        return name;
    }

    private String getSOAPRequestMessage(InvocationData data) {
        String message;
        block11: {
            ByteArrayOutputStream soapStream = null;
            message = null;
            try {
                try {
                    soapStream = new ByteArrayOutputStream();
                    Object invObj = data.getInvocationParameterAsObject(0);
                    Method method = WSMUtils.getMethodForObject(invObj, kWriteTo, new Class[]{OutputStream.class});
                    method.invoke(invObj, soapStream);
                    message = soapStream.toString();
                }
                catch (Exception e) {
                    WSMUtils.getLogger().error("NWS6Formatter::getSOAPRequestMessage.Unable to getSOAPRequestMessage:" + e);
                    try {
                        soapStream.close();
                    }
                    catch (IOException iOException) {}
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    soapStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                soapStream.close();
            }
            catch (IOException iOException) {}
        }
        return message;
    }

    private String getOperationKey(InvocationData data, String type) {
        String opNS;
        String opName;
        block13: {
            opName = null;
            opNS = null;
            InputStream input = null;
            Object soapObject = null;
            Class<?> readerImplClass = null;
            Method mthdInitDeserMode = null;
            Method mthdGetSoapBody = null;
            try {
                try {
                    input = new ByteArrayInputStream(this.getSOAPRequestMessage(data).getBytes());
                    soapObject = data.getInvocationParameterAsObject(0).getClass().newInstance();
                    readerImplClass = soapObject.getClass();
                    mthdInitDeserMode = readerImplClass.getDeclaredMethod(kInitDeserializationMode, InputStream.class);
                    mthdGetSoapBody = readerImplClass.getDeclaredMethod(kGetSoapBody, null);
                    mthdInitDeserMode.invoke(soapObject, input);
                    Element soapBody = (Element)mthdGetSoapBody.invoke(soapObject, null);
                    Node operationNode = soapBody.getFirstChild();
                    opName = operationNode.getLocalName();
                    opNS = operationNode.getNamespaceURI();
                }
                catch (Exception e) {
                    WSMUtils.getLogger().error("NWS6Formatter::getOperationKey.Unable to getOperationKey:" + e);
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
        if (type != null && type.equalsIgnoreCase(kOperationName)) {
            return opName;
        }
        if (type != null && type.equalsIgnoreCase(kNamespace)) {
            return opNS;
        }
        return null;
    }
}

