/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.nameformatter.websphere;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.ANameFormatter;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class WebsphereClientOutIn2NameFormatter
extends ANameFormatter {
    protected IModuleFeedbackChannel logger = null;

    public WebsphereClientOutIn2NameFormatter(IAgent agent) {
        super(agent);
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    @Override
    public String getServiceName(InvocationData data) {
        String serviceURI = (String)data.get("com.wily.powerpack.webservices.trace.ServiceNameKey");
        if (serviceURI != null) {
            return serviceURI;
        }
        Object call = null;
        try {
            call = data.getInvocationObject();
            if (call != null && (call = WSMUtils.invokeMethodOnObject(call, "getOptions")) != null && (call = WSMUtils.invokeMethodOnObject(call, "getTo")) != null) {
                serviceURI = (String)WSMUtils.invokeMethodOnObject(call, "getAddress");
            }
        }
        catch (Throwable bomb) {
            String message = Thread.currentThread() + " Caught unexpected exception while resolving web service operation namespace URI from " + call.getClass() + " " + bomb;
            WSMUtils.handleException(this.getAgent(), message, bomb);
        }
        if (serviceURI == null || serviceURI.equals("")) {
            serviceURI = "UnknownService";
        }
        data.put("com.wily.powerpack.webservices.trace.ServiceNameKey", (Object)serviceURI);
        return serviceURI;
    }

    public Object getChild(InvocationData data) throws Exception {
        Object messageContext = data.getInvocationParameterAsObject(0);
        Object soapEnvelope = WSMUtils.invokeMethodOnObject(messageContext, "getEnvelope");
        Object soapBody = WSMUtils.invokeMethodOnObject(soapEnvelope, "getBody");
        return WSMUtils.invokeMethodOnObject(soapBody, "getFirstOMChild");
    }

    @Override
    public String getNamespace(InvocationData data) {
        String namespaceURI = (String)data.get("com.wily.powerpack.webservices.trace.NamespaceKey");
        if (namespaceURI != null) {
            return namespaceURI;
        }
        try {
            Object child = this.getChild(data);
            Object qName = WSMUtils.invokeMethodOnObject(child, "getQName");
            this.logger.debug("WebsphereClientOutIn2NameFormatter:: QName= " + qName);
            namespaceURI = (String)WSMUtils.invokeMethodOnObject(qName, "getNamespaceURI");
            this.logger.debug("WebsphereClientOutIn2NameFormatter:: namespaceURI= " + namespaceURI);
        }
        catch (Throwable bomb) {
            try {
                String message = Thread.currentThread() + " Caught unexpected exception while resolving web service operation namespace URI from " + data.getInvocationObject().getClass() + " " + bomb;
                WSMUtils.handleException(this.getAgent(), message, bomb);
            }
            catch (Exception exception) {
                WSMUtils.handleException(this.getAgent(), "Caught unexpected exception while resolving web service operation namespace URI", bomb);
            }
        }
        if (namespaceURI == null || namespaceURI.equals("")) {
            namespaceURI = "UnknownService";
        }
        data.put("com.wily.powerpack.webservices.trace.NamespaceKey", (Object)namespaceURI);
        return namespaceURI;
    }

    @Override
    public String getOperationName(InvocationData data) {
        String operationName = (String)data.get("com.wily.powerpack.webservices.trace.OperationNameKey");
        if (operationName != null) {
            return operationName;
        }
        try {
            operationName = (String)WSMUtils.invokeMethodOnObject(this.getChild(data), "getLocalName");
            this.logger.debug("WebsphereClientOutIn2NameFormatter:: getOperationName operationName= " + operationName);
        }
        catch (Throwable bomb) {
            try {
                String message = " Caught unexpected exception while resolving web service operation namespace URI from " + data.getInvocationObject().getClass() + " " + bomb;
                WSMUtils.handleError(this.getAgent(), message, bomb);
            }
            catch (Exception exception) {
                WSMUtils.handleError(this.getAgent(), "Caught unexpected exception while resolving web service operation name", bomb);
            }
        }
        if (operationName == null || operationName.equals("")) {
            operationName = "UnknownOperationName";
        }
        data.put("com.wily.powerpack.webservices.trace.OperationNameKey", (Object)operationName);
        return operationName;
    }
}

