/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.handlers;

import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.nameformatter.WSNameCache;
import com.wily.powerpack.webservices.handlers.SimpleServiceDeserializer;
import com.wily.powerpack.webservices.handlers.WsdmHandlerUtil;
import com.wily.powerpack.webservices.handlers.WsdmLogger;
import com.wily.powerpack.webservices.handlers.WsdmMessageContext;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.xml.sax.SAXException;

public class WsdmGenericHandler
extends GenericHandler {
    public static final String CORRELATION_ID_NAME = "WSCorIDSOAPHeader";
    public static final String CORRELATION_NAMESPACE = "http://www.ca.com/apm";
    public static final String CORRELATION_ATTR_NAME = "CorID";
    public static final String CORRELATION_ID_KEY = "CorIDForSOAPInvocation";
    protected static final String KEY_TRANS_ID = "WSDM_TRANSID";
    public static WsdmLogger log = new WsdmLogger();
    public WsdmHandlerUtil wsdmHandlerUtil = null;
    private Object observationType = 1;
    private final Object observationTypeLock = new Object();
    private static final String CONFIG_OBSERVATION_TYPE = "observationType";

    public boolean handleRequest(MessageContext context) {
        return true;
    }

    public String generateCorrelationId() {
        return "correlation id generated";
    }

    public boolean isAgentServletCorrelationIdSet() {
        return true;
    }

    public String getAgentServletCorrelationIdSet() {
        return "correlation id agent servlet";
    }

    public void mapDependency() {
    }

    protected boolean processSoapFault(SOAPMessage soapMess, WsdmMessageContext wsdmMessageContext) {
        if (log.isDebugLogging().booleanValue()) {
            log.debug("WsdmGenericHandler::processSoapFault");
        }
        if (soapMess != null) {
            wsdmMessageContext.setResponseSOAPMessage(soapMess);
            SOAPPart soapPart = soapMess.getSOAPPart();
            if (soapPart != null) {
                SOAPEnvelope soapEnv = null;
                try {
                    soapEnv = soapPart.getEnvelope();
                }
                catch (SOAPException sOAPException) {
                    if (log.isDebugLogging().booleanValue()) {
                        log.debug("WsdmGenericHandler::processSoapFault SOAPException soapEnv == null");
                    }
                    soapEnv = null;
                }
                if (soapEnv != null) {
                    SOAPFault soapFault;
                    SOAPBody soapBody = null;
                    try {
                        soapBody = soapEnv.getBody();
                    }
                    catch (SOAPException sOAPException) {
                        if (log.isDebugLogging().booleanValue()) {
                            log.debug("WsdmGenericHandler::processSoapFault soapBody == null");
                        }
                        soapBody = null;
                    }
                    if (soapBody != null && (soapFault = soapBody.getFault()) != null) {
                        this.sendoutSoapFaultInfo(soapFault, wsdmMessageContext);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void destroy() {
        if (log.isDebugLogging().booleanValue()) {
            log.debug("destroy");
        }
    }

    protected String dumpStackTrace(Throwable t) {
        return t.getMessage();
    }

    public QName[] getHeaders() {
        if (log.isDebugLogging().booleanValue()) {
            log.debug("getHeaders");
        }
        return null;
    }

    public void setNameCache(String operationName, String namespace) {
        WSNameCache.setOperationName(operationName);
        WSNameCache.setNamespaceURI(namespace);
    }

    protected String getOperationNamespaceFromSoapBody(String inputString) {
        String operationNamespace = null;
        if (WSMUtils.xmlParsingEnabled()) {
            if (log.isDebugLogging().booleanValue()) {
                log.debug("WsdmGenericHandler: xml parsing is enabled, attempting to getOperationNamespaceFromSoapBody");
            }
            operationNamespace = "";
            if (log.isDebugLogging().booleanValue()) {
                log.debug("getServiceOperationNameFromSoapBody(" + inputString + ",...)");
            }
            SimpleServiceDeserializer ssd = new SimpleServiceDeserializer(inputString);
            try {
                ssd.parse();
                operationNamespace = ssd.getServiceName();
            }
            catch (SAXException e) {
                log.error("WsdmGenericHandler::getServiceOperationNameFromSoapBody" + e);
            }
            catch (Exception e) {
                log.error("WsdmGenericHandler::getServiceOperationNameFromSoapBody)" + e);
            }
        } else if (log.isDebugLogging().booleanValue()) {
            log.debug("WsdmGenericHandler: xml parsing is disabled, will NOT attempt to getOperationNamespaceFromSoapBody");
        }
        return operationNamespace;
    }

    protected void sendoutSoapFaultInfo(SOAPFault soapFault, WsdmMessageContext context) {
        if (soapFault == null) {
            return;
        }
        String[] sarr = null;
        try {
            Detail detail;
            if (soapFault.getDetail() != null && (detail = soapFault.getDetail()) != null) {
                Iterator it = detail.getDetailEntries();
                ArrayList<String> listDetailEntries = new ArrayList<String>();
                if (it != null) {
                    while (it.hasNext()) {
                        Object anObject = it.next();
                        if (anObject instanceof DetailEntry) {
                            DetailEntry entry = (DetailEntry)anObject;
                            if (entry == null) continue;
                            listDetailEntries.add(entry.getValue());
                            continue;
                        }
                        log.debug("Object is not an instance of soap.DetailEntry:" + anObject);
                    }
                }
                sarr = listDetailEntries.toArray(new String[listDetailEntries.size()]);
            }
        }
        catch (Error e) {
            log.debug("WsdmGenericHandler::sendoutSoapFaultInfo " + WSMUtils.dumpStackTrace(e));
        }
        this.wsdmHandlerUtil.spoolFault(context, soapFault.getFaultActor(), soapFault.getFaultCode().toString(), soapFault.getFaultString(), sarr);
    }

    protected void setPortName(HttpServletRequest req, WsdmMessageContext wsdmMessageContext) {
        if (req != null) {
            if (req.getServerPort() == 80) {
                wsdmMessageContext.setPortName("http://" + req.getServerName() + req.getRequestURI());
            } else {
                wsdmMessageContext.setPortName("http://" + req.getServerName() + ":" + req.getServerPort() + req.getRequestURI());
            }
        }
    }

    protected WsdmMessageContext setupTransactionId(MessageContext context) {
        WsdmMessageContext wsdmMessageContext = null;
        if (context.containsProperty(KEY_TRANS_ID)) {
            wsdmMessageContext = (WsdmMessageContext)context.getProperty(KEY_TRANS_ID);
        }
        if (wsdmMessageContext != null) {
            this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
        }
        return wsdmMessageContext;
    }

    protected WsdmMessageContext wsdmHandleResponse(MessageContext context) {
        WsdmMessageContext wsdmMessageContext = (WsdmMessageContext)context.getProperty(KEY_TRANS_ID);
        if (wsdmMessageContext == null) {
            wsdmMessageContext = new WsdmMessageContext(this.getObservationType());
        } else {
            this.setNameCache(wsdmMessageContext.getOperationName(), wsdmMessageContext.getOperationNameSpace());
        }
        return wsdmMessageContext;
    }

    public boolean hasSOAPHeader(MessageContext context, String headerName) {
        return false;
    }

    public void addSOAPHeader(MessageContext context, String headerName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getObservationType() {
        Object object = this.observationTypeLock;
        synchronized (object) {
            return (Integer)this.observationType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservationType(int oType) {
        Object object = this.observationTypeLock;
        synchronized (object) {
            this.observationType = oType;
        }
    }

    public void wsdmInit(HandlerInfo config) {
        this.setObservationType(WsdmHandlerUtil.getObservationType(config));
        this.wsdmHandlerUtil = WsdmHandlerUtil.getWsdmHandlerUtil();
    }
}

