/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.text;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.AStringLocalizer;
import com.wily.util.text.Utf8ResourceBundle;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MultipleResourceBundleStringLocalizer
extends AStringLocalizer {
    private final IModuleFeedbackChannel fFeedback;
    private boolean fLogMissingKeys;
    private ClassLoader fClassLoaderToUse;
    private Map fLocalizedStringsBundleListMap;
    private Map fCacheMap;
    private Map fBundleLoadersMap;

    public MultipleResourceBundleStringLocalizer(IModuleFeedbackChannel moduleFeedback, ClassLoader classLoaderToUse, String[] fullyQualifiedNames) {
        this(moduleFeedback, classLoaderToUse, fullyQualifiedNames, true);
    }

    public MultipleResourceBundleStringLocalizer(IModuleFeedbackChannel moduleFeedback, ClassLoader classLoaderToUse, String[] fullyQualifiedNames, boolean logMissingKeys) {
        this.fFeedback = moduleFeedback;
        this.fLogMissingKeys = logMissingKeys;
        this.fClassLoaderToUse = classLoaderToUse == null ? ClassLoader.getSystemClassLoader() : classLoaderToUse;
        this.fLocalizedStringsBundleListMap = Collections.synchronizedMap(new HashMap());
        this.fCacheMap = Collections.synchronizedMap(new HashMap());
        this.fBundleLoadersMap = new HashMap();
        this.loadBundleMap(fullyQualifiedNames);
        this.makeResourceBundles(classLoaderToUse, fullyQualifiedNames, Locale.getDefault());
    }

    public IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    public boolean shouldLogMissingKeys() {
        return this.fLogMissingKeys;
    }

    public void setLogMissingKeys(boolean shouldLog) {
        this.fLogMissingKeys = shouldLog;
    }

    public void addResourceBundle(String fullyQualifiedName, ClassLoader classLoaderToUse) {
        this.addResourceBundle(fullyQualifiedName, classLoaderToUse, Locale.getDefault());
    }

    public void addResourceBundle(String fullyQualifiedName, ClassLoader classLoaderToUse, Locale locale) {
        ClassLoader bundleLoader = null;
        if (this.fBundleLoadersMap.containsKey(fullyQualifiedName) && this.fBundleLoadersMap.get(fullyQualifiedName) != null) {
            bundleLoader = (ClassLoader)this.fBundleLoadersMap.get(fullyQualifiedName);
        } else {
            bundleLoader = classLoaderToUse;
            this.fBundleLoadersMap.put(fullyQualifiedName, bundleLoader);
        }
        ResourceBundle newBundle = this.getResourceBundle(fullyQualifiedName, bundleLoader, locale);
        if (newBundle != null) {
            Map<String, ResourceBundle> localeBundlesMap = (Map<String, ResourceBundle>)this.fLocalizedStringsBundleListMap.get(locale);
            if (localeBundlesMap == null) {
                localeBundlesMap = Collections.synchronizedMap(new HashMap(this.fBundleLoadersMap.keySet().size()));
                this.fLocalizedStringsBundleListMap.put(locale, localeBundlesMap);
            }
            localeBundlesMap.put(fullyQualifiedName, newBundle);
        }
    }

    private ResourceBundle getResourceBundle(String fullyQualifiedName, ClassLoader classLoaderToUse, Locale locale) {
        ResourceBundle newBundle = null;
        try {
            newBundle = classLoaderToUse != null ? Utf8ResourceBundle.getBundle(fullyQualifiedName, locale, classLoaderToUse) : Utf8ResourceBundle.getBundle(fullyQualifiedName, locale);
        }
        catch (MissingResourceException missingResourceException) {
            this.fFeedback.error("Can't find localization resource: \"" + fullyQualifiedName + "\". Using defaults...");
        }
        return newBundle;
    }

    private void makeResourceBundles(ClassLoader classLoaderToUse, String[] fullyQualifiedNames, Locale locale) {
        int x = 0;
        while (x < fullyQualifiedNames.length) {
            this.addResourceBundle(fullyQualifiedNames[x], classLoaderToUse, locale);
            ++x;
        }
        Map cache = Collections.synchronizedMap(new HashMap());
        this.fCacheMap.put(locale, cache);
    }

    private void makeMissingResourceBundles(Locale locale) {
        Map<String, ResourceBundle> localeBundlesMap = (Map<String, ResourceBundle>)this.fLocalizedStringsBundleListMap.get(locale);
        if (localeBundlesMap == null) {
            localeBundlesMap = Collections.synchronizedMap(new HashMap(this.fBundleLoadersMap.keySet().size()));
            this.fLocalizedStringsBundleListMap.put(locale, localeBundlesMap);
        }
        if (localeBundlesMap.size() >= this.fBundleLoadersMap.size()) {
            return;
        }
        for (String fullyQualifiedName : this.fBundleLoadersMap.keySet()) {
            ResourceBundle newBundle;
            if (localeBundlesMap.get(fullyQualifiedName) != null || (newBundle = this.getResourceBundle(fullyQualifiedName, (ClassLoader)this.fBundleLoadersMap.get(fullyQualifiedName), locale)) == null) continue;
            localeBundlesMap.put(fullyQualifiedName, newBundle);
        }
    }

    @Override
    protected String getLocalizedString(String key) {
        return this.getLocalizedString(Locale.getDefault(), key);
    }

    @Override
    protected String getLocalizedString(Locale locale, String key) {
        Map cache = (Map)this.fCacheMap.get(locale);
        if (cache == null || cache.isEmpty()) {
            String[] bundleNames = this.fBundleLoadersMap.keySet().toArray(new String[0]);
            this.makeResourceBundles(this.fClassLoaderToUse, bundleNames, locale);
            cache = (Map)this.fCacheMap.get(locale);
        } else {
            this.makeMissingResourceBundles(locale);
        }
        String userString = (String)cache.get(key);
        if (userString == null) {
            userString = this.getUserString(key, locale, cache);
        }
        if (userString == null) {
            if (this.shouldLogMissingKeys()) {
                this.getModuleFeedback().warn("Can't find localized string: \"" + key + "\".");
                if (this.getModuleFeedback().isDebugEnabled()) {
                    Thread.dumpStack();
                }
            }
            cache.put(key, key);
            return key;
        }
        return userString;
    }

    private String getUserString(String key, Locale locale, Map cache) {
        String userString = null;
        Map localeBundlesMap = (Map)this.fLocalizedStringsBundleListMap.get(locale);
        if (localeBundlesMap != null) {
            for (ResourceBundle bundle : localeBundlesMap.values()) {
                try {
                    userString = bundle.getString(key);
                    cache.put(key, userString);
                    return userString;
                }
                catch (MissingResourceException missingResourceException) {}
            }
        }
        return userString;
    }

    @Override
    public String getFormattedLocalizedString(String key, String[] arguments) {
        return this.getFormattedLocalizedString(Locale.getDefault(), key, arguments);
    }

    @Override
    public String getFormattedLocalizedString(Locale locale, String key, String[] arguments) {
        String userString = null;
        String userMessage = this.getLocalizedString(locale, key);
        try {
            userString = MessageFormat.format(userMessage, arguments);
        }
        catch (IllegalArgumentException iae) {
            this.getModuleFeedback().verbose(iae);
        }
        if (userString == null) {
            userString = key;
        }
        return userString;
    }

    private void loadBundleMap(String[] fullyQualifiedNames) {
        int index = 0;
        while (index < fullyQualifiedNames.length) {
            this.fBundleLoadersMap.put(fullyQualifiedNames[index], this.fClassLoaderToUse);
            ++index;
        }
    }
}

