/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.jboss;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.properties.AttributeListing;

public class JBossClientSOAPCorrelationTracer
extends ASingleInstanceTracerFactory {
    private final IAgent agent;
    private IModuleFeedbackChannel logger = null;

    public JBossClientSOAPCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.agent = agent;
        this.logger = agent.IAgent_getModuleFeedback();
        WSMUtils.refreshLogLevels();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (!WSMUtils.correlationSOAPInsertionEnabled()) {
            return;
        }
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("JBossClientSOAPCorrelationTracer.ITracer_startTrace()");
        }
        try {
            Object soapMessage = data.getInvocationParameterAsObject(0);
            Object soapPart = WSMUtils.invokeMethodOnObject(soapMessage, "getSOAPPart");
            Object sOAPEnvelope = WSMUtils.invokeMethodOnObject(soapPart, "getEnvelope");
            Object attrName = WSMUtils.invokeMethodOnObject(sOAPEnvelope, "createName", new Class[]{String.class}, new Object[]{"CorID"});
            Object sOAPHeader = WSMUtils.invokeMethodOnObject(sOAPEnvelope, "getHeader");
            if (sOAPHeader == null) {
                sOAPHeader = WSMUtils.invokeMethodOnObject(sOAPEnvelope, "addHeader");
            }
            String correlationString = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("JBossClientSOAPCorrelationTracer ITracer_startTrace correlationString  =" + correlationString);
            }
            Object sOAPElement = WSMUtils.invokeMethodOnObject(sOAPHeader, "addChildElement", new Class[]{String.class, String.class, String.class}, new Object[]{"WSCorIDSOAPHeader", "", "http://www.ca.com/apm"});
            ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
            WSMUtils.invokeMethodOnObject(sOAPElement, "addAttribute", new Class[]{Class.forName("javax.xml.soap.Name", false, threadClassLoader), String.class}, new Object[]{attrName, correlationString});
            WSMUtils.invokeMethodOnObject(sOAPElement, "addNamespaceDeclaration", new Class[]{String.class, String.class}, new Object[]{"", "http://www.ca.com/apm"});
        }
        catch (Exception e) {
            this.logger.info("JBossClientSOAPCorrelationTracer Error " + WSMUtils.dumpStackTrace(e));
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public void ITracer_finishTrace(int arg0, InvocationData arg1) {
        try {
            if (!WSMUtils.correlationSOAPInsertionEnabled()) {
                return;
            }
            new CorrelationId().decrementCorrelationCount();
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.getAgent().IAgent_getModuleFeedback().debug("JBossClientSOAPCorrelationTracer::FinishTrace.");
            }
        }
        catch (Throwable bomb) {
            String message = Thread.currentThread() + "JBossClientSOAPCorrelationTracer ITracer_finishTrace exception: " + " " + bomb;
            WSMUtils.handleError(this.getAgent(), message, bomb);
        }
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

