/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.regex;

import com.wily.util.regex.RegexException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SafeMatcher {
    public static Matcher withTimeout(String stringToMatch, Pattern regularExpressionPattern, int timeoutMillis) {
        return SafeMatcher.withTimeout(stringToMatch, regularExpressionPattern, timeoutMillis, null);
    }

    public static <T> Matcher withTimeout(String stringToMatch, Pattern regularExpressionPattern, int timeoutMillis, T origin) {
        assert (stringToMatch != null);
        RegexOrigin regexOrigin = new RegexOrigin(regularExpressionPattern, stringToMatch, origin);
        TimeoutLimitedCharSequence charSequence = new TimeoutLimitedCharSequence((CharSequence)stringToMatch, regexOrigin, (long)timeoutMillis);
        return regularExpressionPattern.matcher(charSequence);
    }

    public static Matcher withReadOpsLimited(String stringToMatch, Pattern regularExpressionPattern, int maxReadOps) {
        return SafeMatcher.withReadOpsLimited(stringToMatch, regularExpressionPattern, maxReadOps, null);
    }

    public static <T> Matcher withReadOpsLimited(String stringToMatch, Pattern regularExpressionPattern, int maxReadOps, T origin) {
        assert (stringToMatch != null);
        RegexOrigin regexOrigin = new RegexOrigin(regularExpressionPattern, stringToMatch, origin);
        ReadOpsLimitedCharSequence charSequence = new ReadOpsLimitedCharSequence((CharSequence)stringToMatch, regexOrigin, maxReadOps);
        return regularExpressionPattern.matcher(charSequence);
    }

    private static abstract class LimitedCharSequence<T>
    implements CharSequence {
        final CharSequence inner;
        final RegexOrigin<T> origin;

        private LimitedCharSequence(CharSequence stringToMatch, RegexOrigin<T> origin) {
            this.inner = stringToMatch;
            this.origin = origin;
        }

        @Override
        public char charAt(int index) {
            this.throwExceptionIfLimitReached();
            return this.inner.charAt(index);
        }

        @Override
        public int length() {
            return this.inner.length();
        }

        @Override
        public abstract CharSequence subSequence(int var1, int var2);

        abstract void throwExceptionIfLimitReached();

        @Override
        public String toString() {
            return this.inner.toString();
        }
    }

    private static class ReadOpsLimitedCharSequence<T>
    extends LimitedCharSequence<T> {
        private final int originalLimit;
        private int readLimit;

        private ReadOpsLimitedCharSequence(CharSequence stringToMatch, RegexOrigin<T> origin, int readLimit) {
            this(stringToMatch, origin, readLimit, readLimit);
        }

        private ReadOpsLimitedCharSequence(CharSequence stringToMatch, RegexOrigin<T> origin, int readLimit, int originalLimit) {
            super(stringToMatch, origin);
            this.readLimit = readLimit;
            this.originalLimit = originalLimit;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ReadOpsLimitedCharSequence<T>(this.inner.subSequence(start, end), this.origin, this.readLimit, this.originalLimit);
        }

        @Override
        void throwExceptionIfLimitReached() {
            if (--this.readLimit < 0) {
                throw new RegexException(String.format("Max allowed read ops, %d, reached", this.originalLimit), this.origin);
            }
        }
    }

    static class RegexOrigin<T> {
        final Pattern regex;
        final String stringToMatch;
        final T source;

        private RegexOrigin(Pattern regex, String stringToMatch, T source) {
            this.regex = regex;
            this.stringToMatch = stringToMatch;
            this.source = source;
        }
    }

    private static class TimeoutLimitedCharSequence<T>
    extends LimitedCharSequence<T> {
        private final long timeoutTime;
        private final long originalTimeout;

        private TimeoutLimitedCharSequence(CharSequence stringToMatch, RegexOrigin<T> origin, long timeoutMillis) {
            this(stringToMatch, origin, timeoutMillis, System.currentTimeMillis() + timeoutMillis);
        }

        private TimeoutLimitedCharSequence(CharSequence stringToMatch, RegexOrigin<T> origin, long timeoutMillis, long timeoutTime) {
            super(stringToMatch, origin);
            this.timeoutTime = timeoutTime;
            this.originalTimeout = timeoutMillis;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new TimeoutLimitedCharSequence<T>(this.inner.subSequence(start, end), this.origin, this.originalTimeout, this.timeoutTime);
        }

        @Override
        void throwExceptionIfLimitReached() {
            if (System.currentTimeMillis() > this.timeoutTime) {
                throw new RegexException(String.format("Timeout %d ms reached", this.originalTimeout), this.origin);
            }
        }
    }
}

