/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.soap;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.powerpack.webservices.extension.agent.trace.soap.WSDMEventCache;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;

public class NWClientSOAPHeaderTracer
extends ASingleInstanceTracerFactory {
    private static final String HANDLER_HANDLE_REQUEST = "handleRequest";
    private static final String HANDLER_HANDLE_RESPONSE = "handleResponse";
    private static final String HANDLER_HANDLE_FAULT = "handleFault";
    private static String kstTracerName = "NWClientSOAPHeaderTracer";
    private ReentrancyLevel fReEntryLeveL = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public NWClientSOAPHeaderTracer(IAgent agent, AttributeListing attributeListing, ProbeIdentification probeIdentification, Object sample) {
        super(agent, attributeListing, probeIdentification, sample);
    }

    public void ITracer_startTrace(int arg0, InvocationData data) {
        String methodName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
        if (methodName.endsWith(HANDLER_HANDLE_REQUEST)) {
            try {
                Object handler = data.getInvocationObject();
                Object message = NWClientSOAPHeaderTracer.getParameter(data, 0);
                Object propertyContext = NWClientSOAPHeaderTracer.getParameter(data, 1);
                ClassLoader classLoader = handler.getClass().getClassLoader();
                Class<?> argStringClass = Class.forName("java.lang.String", true, classLoader);
                Class<?> argCtxClass1 = Class.forName("com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractMessage", true, classLoader);
                Class<?> argCtxClass2 = Class.forName("com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext", true, classLoader);
                Class[] argClassArray = new Class[]{argCtxClass1, argCtxClass2, argStringClass};
                Object[] argsArrayTT = new Object[]{message, propertyContext, "INTROSCOPE_TT_SOAP_HEADER"};
                Object[] argsArrayER = new Object[]{message, propertyContext, "INTROSCOPE_ER_SOAP_HEADER"};
                Boolean hasTTSOAPHeader = (Boolean)WSMUtils.invokeMethodOnObject(handler, "hasSOAPHeader", argClassArray, argsArrayTT);
                Boolean hasERSOAPHeader = (Boolean)WSMUtils.invokeMethodOnObject(handler, "hasSOAPHeader", argClassArray, argsArrayER);
                if (hasTTSOAPHeader.booleanValue()) {
                    WSDMEventCache.setTransactionTraceEvent();
                }
                if (hasERSOAPHeader.booleanValue()) {
                    WSDMEventCache.setErrorSnapshotEvent();
                }
            }
            catch (InvocationTargetException ite) {
                AgentShim.handleError((String)("NWClientSOAPHeaderTracer#Error: " + kstTracerName), (Throwable)ite.getTargetException());
            }
            catch (Exception e) {
                AgentShim.handleError((String)("NWClientSOAPHeaderTracer#Error: " + kstTracerName), (Throwable)e);
            }
        }
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        String methodName = data.getProbeInformation().getProbeIdentification().getProbeMethodName();
        if (methodName.endsWith(HANDLER_HANDLE_RESPONSE) || methodName.endsWith(HANDLER_HANDLE_FAULT)) {
            boolean hasTTSOAPFlag = WSDMEventCache.getTransactionTraceEvent();
            boolean hasERSOAPFlag = WSDMEventCache.getErrorSnapshotEvent();
            try {
                Object handler = data.getInvocationObject();
                Object message = NWClientSOAPHeaderTracer.getParameter(data, 0);
                Object propertyContext = NWClientSOAPHeaderTracer.getParameter(data, 1);
                ClassLoader classLoader = handler.getClass().getClassLoader();
                Class<?> argStringClass = Class.forName("java.lang.String", true, classLoader);
                Class<?> argCtxClass1 = Class.forName("com.sap.engine.services.webservices.jaxrpc.wsdl2java.AbstractMessage", true, classLoader);
                Class<?> argCtxClass2 = Class.forName("com.sap.engine.services.webservices.jaxrpc.wsdl2java.PropertyContext", true, classLoader);
                Class[] argClassArray = new Class[]{argCtxClass1, argCtxClass2, argStringClass};
                if (hasTTSOAPFlag) {
                    Object[] argsArrayTT = new Object[]{message, propertyContext, "INTROSCOPE_TT_SOAP_HEADER"};
                    WSMUtils.invokeMethodOnObject(handler, "addSOAPHeader", argClassArray, argsArrayTT);
                }
                if (hasERSOAPFlag) {
                    Object[] argsArrayER = new Object[]{message, propertyContext, "INTROSCOPE_ER_SOAP_HEADER"};
                    WSMUtils.invokeMethodOnObject(handler, "addSOAPHeader", argClassArray, argsArrayER);
                }
                WSDMEventCache.clearEventCache();
            }
            catch (InvocationTargetException ite) {
                AgentShim.handleError((String)("NWClientSOAPHeaderTracer# Error: " + kstTracerName), (Throwable)ite.getTargetException());
            }
            catch (Exception e) {
                AgentShim.handleError((String)("NWClientSOAPHeaderTracer# Error: " + kstTracerName), (Throwable)e);
            }
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReEntryLeveL;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public static final Object getParameter(InvocationData data, int paramPos) {
        if (!data.hasInvocationParametersAvailable()) {
            AgentShim.handleError((String)("Error: " + kstTracerName + ": no parameters available.  Have you used the right tracer?"), null);
            return null;
        }
        if (data.getInvocationParameterCount() <= paramPos) {
            AgentShim.handleError((String)("Error: " + kstTracerName + ": there aren't that many parameters"), null);
            return null;
        }
        Object result = data.getInvocationParameterAsObject(paramPos);
        if (result == null) {
            AgentShim.handleError((String)("Error: " + kstTracerName + ": param " + paramPos + " is null"), null);
            return null;
        }
        return result;
    }
}

