/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extensions.transactiontrace;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.CompoundComponentParameterCallback;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.blame.ParameterGatheringCallback;
import com.wily.introscope.agent.blame.PreformedCallback;
import com.wily.introscope.agent.extensions.KIntroscopeExtensionConstants;
import com.wily.introscope.agent.transactiontrace.ITransactionTraceListener;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.server.beans.event.IEventDataNode;
import com.wily.introscope.spec.server.transactiontrace.BoundaryOnlyTransactionData;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.feedback.DelegatingFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BoundaryOnlyBlameStack
implements IBlameStack {
    public static final IStackType kStackType = new IStackType(){};
    private ITransactionTraceListener fListener;
    private StackLinkedList fComponentStack = new StackLinkedList();
    private IModuleFeedbackChannel fFeedback;
    private IStringLocalizer fLocalizer;
    private int fBundledTraceClampSize;
    private long fCacheFlushFrequency;
    private boolean fTouchedBackend = false;
    private boolean fFoundUniqueCrossProcessEdge = false;
    private boolean fFoundUniqueDependency = false;
    private ArrayList fDependencyArray;
    private static final String kDependencyArrayMaxSizeProperty = "com.wily.soa.dependencyarray.maxsize";
    private static final int kDefaultDependencyArrayMaxSize = 1000;
    private static volatile int sDependencyArrayMaxSize = 1000;
    private static IAgent agent = null;
    private static ThreadLocal fTimeOfLastCacheFlush;
    private static ThreadLocal fCrossProcessEdgeMap;
    private static ThreadLocal fNoticedDependenciesMap;

    static {
        try {
            agent = AgentShim.getAgent();
            agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new DependencyArrayMaxSizeProperty(agent, agent.IAgent_getModuleFeedback()), true);
        }
        catch (Exception exception) {}
        fTimeOfLastCacheFlush = new ThreadLocal(){

            protected Object initialValue() {
                return System.currentTimeMillis();
            }
        };
        fCrossProcessEdgeMap = new ThreadLocal(){

            protected Object initialValue() {
                return new HashSet();
            }
        };
        fNoticedDependenciesMap = new ThreadLocal(){

            protected Object initialValue() {
                return new HashSet();
            }
        };
    }

    private void addToDependencyArray(BoundaryOnlyTransactionData dependencyData) {
        if (this.fFeedback.isTraceEnabled()) {
            this.fFeedback.trace("[" + Thread.currentThread() + "] addToDependencyArray: dependencyData=" + this.getStringRepresentation(dependencyData));
        }
        if (sDependencyArrayMaxSize > 0 && this.fDependencyArray.size() > sDependencyArrayMaxSize) {
            if (this.fFeedback.isTraceEnabled()) {
                this.dumpDependencyArray();
            }
            this.clearDependencyArray();
        }
        this.fDependencyArray.add(dependencyData);
    }

    private void clearDependencyArray() {
        if (!this.fDependencyArray.isEmpty()) {
            if (this.fFeedback.isTraceEnabled()) {
                this.fFeedback.trace("[" + Thread.currentThread() + "] clearDependencyArray");
            }
            this.fDependencyArray.clear();
        }
    }

    private void dumpDependencyArray() {
        String debugPrefix = "[" + Thread.currentThread() + "] ";
        this.fFeedback.info(String.valueOf(debugPrefix) + "dumpDependencyArray, sDependencyArrayMaxSize=" + sDependencyArrayMaxSize);
        this.fFeedback.info(String.valueOf(debugPrefix) + "this: " + this);
        this.fFeedback.info(String.valueOf(debugPrefix) + "fDependencyArray[" + this.fDependencyArray.size() + "]: ");
        int i = 0;
        while (i < this.fDependencyArray.size()) {
            this.fFeedback.info(String.valueOf(debugPrefix) + "[" + i + "] " + this.getStringRepresentation((BoundaryOnlyTransactionData)this.fDependencyArray.get(i)));
            ++i;
        }
        this.fFeedback.info(String.valueOf(debugPrefix) + "fTimeOfLastCacheFlush: " + fTimeOfLastCacheFlush.get());
        Object[] map = ((HashSet)fCrossProcessEdgeMap.get()).toArray();
        this.fFeedback.info(String.valueOf(debugPrefix) + "fCrossProcessEdgeMap[" + map.length + "]: ");
        int i2 = 0;
        while (i2 < map.length) {
            this.fFeedback.info(String.valueOf(debugPrefix) + "[" + i2 + "] " + map[i2]);
            ++i2;
        }
        map = ((HashSet)fNoticedDependenciesMap.get()).toArray();
        this.fFeedback.info(String.valueOf(debugPrefix) + "fNoticedDependenciesMap[" + map.length + "]: ");
        i2 = 0;
        while (i2 < map.length) {
            this.fFeedback.info(String.valueOf(debugPrefix) + "[" + i2 + "] " + map[i2]);
            ++i2;
        }
    }

    public BoundaryOnlyBlameStack(IModuleFeedbackChannel feedback, IStringLocalizer localizer, ITransactionTraceListener listener, Integer bundledTraceClampSize, Long cacheFlushFrequency) {
        this.fListener = listener;
        this.fFeedback = new DelegatingFeedbackChannel(feedback, new Module("SOA"));
        this.fLocalizer = localizer;
        this.fBundledTraceClampSize = bundledTraceClampSize;
        this.fCacheFlushFrequency = cacheFlushFrequency;
        this.fDependencyArray = new ArrayList();
        try {
            this.flushCacheIfNeccessary();
        }
        catch (Exception exception) {}
    }

    public void setEndBoundary(String component) {
    }

    public void setFrontBoundary(String component) {
    }

    public void endBoundaryPopped(String component) {
    }

    public void frontBoundaryPopped(String component) {
    }

    public void IBlameStack_addComponent(String component) {
    }

    public void IBlameStack_addComponent(String component, String paramName, String paramValue) {
    }

    public void IBlameStack_addComponent(String component, IComponentParameterCallback callback) {
    }

    public void IBlameStack_addExtraParameter(String paramName, String paramValue) {
        TransactionStackElement top = this.peek();
        if (top != null) {
            top.addCallbackParams(paramName, paramValue);
        }
    }

    public void addRootParameter(String key, String value) {
        TransactionStackElement root;
        if (this.fComponentStack != null && (root = this.fComponentStack.getHead()) != null) {
            root.addCallbackParams(key, value);
        }
    }

    private void addCallbackParameters(IComponentParameterCallback callback, HashMap map) {
        try {
            if (callback != null) {
                callback.IComponentParameterCallback_addParameters((Map)map);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                this.fFeedback.verbose(AgentShim.getAgent().IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Transaction_Trace_Error_Accessing_Parameters"));
                this.fFeedback.verbose(t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
    }

    private void evaluateCrossProcessUniqueness(String component) {
        String calledByNodeId;
        String crossProcessEdge = null;
        SharedCrossProcessData cache = agent.IAgent_getComponentTracer().getCrossProcessDataCache();
        if (cache != null && (calledByNodeId = cache.getIncomingCalledByNodeId()) != null) {
            crossProcessEdge = String.valueOf(calledByNodeId) + component;
            HashSet edgeMap = (HashSet)fCrossProcessEdgeMap.get();
            if (edgeMap.add(crossProcessEdge)) {
                cache.setDependencyPropagationFlag(1);
                this.fFoundUniqueCrossProcessEdge = true;
                if (this.fFeedback.isDebugEnabled()) {
                    this.fFeedback.debug("BoundaryOnlyBlameStack: evalXProcessUniqueness passd " + crossProcessEdge);
                }
            }
        }
    }

    private boolean evaluateDependencyUniqueness(String component) {
        SharedCrossProcessData cache = agent.IAgent_getComponentTracer().getCrossProcessDataCache();
        if (cache != null) {
            HashSet noticedDependencies = (HashSet)fNoticedDependenciesMap.get();
            if (noticedDependencies.add(component)) {
                cache.setDependencyPropagationFlag(1);
                this.fFoundUniqueDependency = true;
                if (this.fFeedback.isDebugEnabled()) {
                    this.fFeedback.debug("BoundaryOnlyBlameStack: evalDependencyUniqueness passd " + component);
                }
                return true;
            }
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("BoundaryOnlyBlameStack: evalDependencyUniqueness failed " + component);
            }
            return false;
        }
        return false;
    }

    private boolean evaluateLogicalEdgeUniqueness(String logicalEdge) {
        HashSet edgeMap = (HashSet)fCrossProcessEdgeMap.get();
        if (edgeMap.add(logicalEdge)) {
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("BoundaryOnlyBlameStack: evalLogicalEdgeUniqueness passd " + logicalEdge);
            }
            return true;
        }
        if (this.fFeedback.isDebugEnabled()) {
            this.fFeedback.debug("BoundaryOnlyBlameStack: evalLogicalEdgeUniqueness failed " + logicalEdge);
        }
        return false;
    }

    private void flushCacheIfNeccessary() {
        long lastCacheFlush = (Long)fTimeOfLastCacheFlush.get();
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCacheFlush > this.fCacheFlushFrequency) {
            fCrossProcessEdgeMap.set(new HashSet());
            fNoticedDependenciesMap.set(new HashSet());
            fTimeOfLastCacheFlush.set(currentTime);
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("Flushing the cache since " + this.fCacheFlushFrequency + " millisecs have passed after last cache flush ");
            }
        }
    }

    private boolean handleAdd(String component, IComponentParameterCallback callback, String outgoingNode) {
        TransactionStackElement parent = this.peek();
        TransactionStackElement curEle = new TransactionStackElement(this, component, callback);
        curEle.getParameters().put(KIntroscopeExtensionConstants.kOutgoingNode, outgoingNode);
        this.push(curEle);
        this.doLogicalEdgeProcessing();
        if (parent == null) {
            this.evaluateCrossProcessUniqueness(component);
            this.evaluateDependencyUniqueness(component);
        } else {
            BoundaryOnlyTransactionData current = this.peek().markDependency(false);
            parent.addSubElement(current);
            BoundaryOnlyTransactionData tcdata = parent.markDependency(true);
            if (tcdata.getResource().equals(current.getResource())) {
                if (this.fFeedback.isDebugEnabled()) {
                    this.fFeedback.debug("BoundaryOnlyBlameStack: found chained implementation  where a component/node calls iteself.Not reporting this edge for component " + tcdata.getResource());
                }
            } else if (this.evaluateDependencyUniqueness(this.getStringRepresentation(tcdata))) {
                this.fTouchedBackend = true;
                this.addToDependencyArray(tcdata);
            }
        }
        return true;
    }

    private void doLogicalEdgeProcessing() {
        String logicalEdge = null;
        BoundaryOnlyTransactionData currentNode = this.peek().markDependency(false);
        String logicalCaller = currentNode.getParameterValue("LogicalCaller");
        String logicalCallerNodeType = currentNode.getParameterValue("LogicalCallerNodeType");
        if (logicalCaller == null) {
            return;
        }
        logicalEdge = String.valueOf(logicalCaller) + currentNode.getResource();
        if (this.evaluateLogicalEdgeUniqueness(logicalEdge)) {
            Map parameters = currentNode.getParameters();
            parameters.put("CallerName", logicalCaller);
            parameters.put("CallerNodeType", logicalCallerNodeType);
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("BoundaryOnlyBlameStack: reporting logical edge " + currentNode.getResource());
            }
            this.reportTransactions(new BoundaryOnlyTransactionData[]{currentNode});
        }
    }

    public void IBlameStack_removeComponent(String component) {
    }

    public void handleRemove(String component) {
        Assertion.wilyAssert((boolean)false);
        if (!this.fComponentStack.isEmpty()) {
            TransactionStackElement element = this.pop();
            Assertion.wilyAssert((boolean)false);
            boolean empty = this.fComponentStack.isEmpty();
            BoundaryOnlyTransactionData data = element.finish(empty);
            if (data != null) {
                if (empty) {
                    if (!this.fTouchedBackend) {
                        this.includeCorParams(data.getParameters());
                        this.addHeadNodeToReportingQueue(data);
                    } else {
                        new HashMap();
                        if (this.fFoundUniqueCrossProcessEdge) {
                            this.includeCorParams(data.getParameters());
                            if (this.evaluateDependencyUniqueness(this.getStringRepresentation(data))) {
                                this.addToDependencyArray(data);
                            }
                            if (this.fFeedback.isDebugEnabled()) {
                                this.fFeedback.debug("BoundaryOnlyBlameStack: adding correlation parameters to the first noticed edge " + this.getStringRepresentation(data));
                            }
                        }
                        this.addDependencyEdgesToReportingQueue(this.fDependencyArray);
                    }
                } else {
                    TransactionStackElement tail = this.fComponentStack.getTail();
                    if (tail != null) {
                        String outgoingNode = (String)tail.getParameters().get(KIntroscopeExtensionConstants.kOutgoingNode);
                        SharedCrossProcessData cache = agent.IAgent_getComponentTracer().getCrossProcessDataCache();
                        cache.setOutgoingCallerNodeId(outgoingNode);
                    }
                }
            }
        }
    }

    private void reportTransactions(BoundaryOnlyTransactionData[] data) {
        if (this.fFeedback.isDebugEnabled() && data != null) {
            int i = 0;
            while (i < data.length) {
                this.fFeedback.debug("BoundaryOnlyBlameStack: reporting edge " + this.getStringRepresentation(data[i]));
                ++i;
            }
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Trace Type", "BundledTrace");
        BoundaryOnlyTransactionData finalTBatch = new BoundaryOnlyTransactionData(data, params);
        if (this.fFeedback.isTraceEnabled()) {
            this.fFeedback.trace(this.debug_formatBlameStacks((IEventDataNode)finalTBatch));
        }
        this.fListener.ITransactionTraceListener_reportTransaction((TransactionComponentData)finalTBatch);
    }

    private String debug_formatBlameStacks(IEventDataNode root) {
        String s = "Start of Transaction Bundle: \n";
        int count = root.getSubNodeCount();
        int i = 0;
        while (i < count) {
            s = String.valueOf(s) + "Blame Stack " + (i + 1) + ": ";
            IEventDataNode node = root.getSubNode(i);
            s = String.valueOf(s) + this.debug_formatBlamStackNode(node);
            while (node.getSubNodeCount() >= 1) {
                node = node.getSubNode(0);
                s = String.valueOf(s) + this.debug_formatBlamStackNode(node);
            }
            s = String.valueOf(s) + "End Blame Stack " + (i + 1) + "\n";
            ++i;
        }
        s = String.valueOf(s) + "End of Transaction Bundle";
        return s;
    }

    private String debug_formatBlamStackNode(IEventDataNode node) {
        String operationName = node.getResource();
        String s = "[" + operationName + "]\n";
        Map params = node.getParameters();
        Object[] entries = params.entrySet().toArray();
        int i = 0;
        while (i < entries.length) {
            Map.Entry entry = (Map.Entry)entries[i];
            s = String.valueOf(s) + "  [" + entry.getKey() + "=" + entry.getValue() + "]\n";
            ++i;
        }
        return s;
    }

    private void addDependencyEdgesToReportingQueue(List edgeArray) {
        SharedCrossProcessData cache = agent.IAgent_getComponentTracer().getCrossProcessDataCache();
        if (cache != null && cache.getDependencyPropagationFlag() == 1) {
            Iterator iter = edgeArray.iterator();
            int arrayLen = edgeArray.size();
            BoundaryOnlyTransactionData[] btDataArray = new BoundaryOnlyTransactionData[arrayLen];
            int i = 0;
            while (iter.hasNext()) {
                BoundaryOnlyTransactionData data;
                btDataArray[i] = data = (BoundaryOnlyTransactionData)iter.next();
                ++i;
            }
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("BoundaryOnlyBlameStack: depPropFlag was 1, reporting Txns");
            }
            this.reportTransactions(btDataArray);
        }
    }

    private void addHeadNodeToReportingQueue(BoundaryOnlyTransactionData data) {
        SharedCrossProcessData cache = agent.IAgent_getComponentTracer().getCrossProcessDataCache();
        if (cache != null && cache.getDependencyPropagationFlag() == 1) {
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug("BoundaryOnlyBlameStack: depPropFlag was 1, reporting Txns" + this.getStringRepresentation(data));
            }
            this.reportTransactions(new BoundaryOnlyTransactionData[]{data});
        }
    }

    private String getStringRepresentation(BoundaryOnlyTransactionData data) {
        String stringData = "";
        if (data.getSubNodeCount() > 0) {
            StringBuilder buf = new StringBuilder(data.getResource());
            if (data.getSubNode(0) != null) {
                buf.append(data.getSubNode(0).getResource());
                if (buf != null) {
                    stringData = buf.toString();
                    stringData = stringData.toLowerCase().trim();
                }
                return stringData;
            }
        }
        return data.getResource();
    }

    public BlameStackSnapshot IBlameStack_getSnapshot(String component) {
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    public boolean IBlameStack_isEmpty() {
        return this.fComponentStack.isEmpty();
    }

    public void IBlameStack_tearDown() {
        this.fComponentStack.clear();
        this.clearDependencyArray();
        this.fTouchedBackend = false;
        this.fFoundUniqueCrossProcessEdge = false;
        this.fFoundUniqueDependency = false;
    }

    public boolean noteBoundaryError() {
        return false;
    }

    private TransactionStackElement peek() {
        return this.fComponentStack.getTail();
    }

    private boolean push(TransactionStackElement component) {
        boolean result = this.fComponentStack.isEmpty();
        boolean doAdd = true;
        if (doAdd) {
            this.fComponentStack.add(component);
        }
        return result;
    }

    private TransactionStackElement pop() {
        Assertion.wilyAssert((boolean)false);
        return this.fComponentStack.removeLast();
    }

    public void debug_reportTransactions(BoundaryOnlyTransactionData data) {
    }

    public String[] getDefaultBackendData() {
        return null;
    }

    public void setDefaultBackendComponent(String componentToReplace, String backendComponent) {
    }

    public BlameStackSnapshot getDefaultBackendSnapshot() {
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    public int getSize() {
        return this.fComponentStack.getSize();
    }

    public void removeMapComponent(IStackType type, String component) {
        if (type == BoundaryOnlyBlameStack.getStackType()) {
            this.handleRemove(component);
        }
    }

    public void addMapComponent(IStackType type, String component) {
        if (type == BoundaryOnlyBlameStack.getStackType()) {
            this.handleAdd(component, null, null);
        }
    }

    public void addMapComponent(IStackType type, String component, String paramName, String paramVal) {
        if (type == BoundaryOnlyBlameStack.getStackType()) {
            this.handleAdd(component, (IComponentParameterCallback)new PreformedCallback(paramName, paramVal), null);
        }
    }

    public boolean getHeadFilteringStatus() {
        return false;
    }

    public boolean shouldCurrentTraceBePropagated() {
        return false;
    }

    private void includeCorParams(Map parameters) {
        String corid;
        SharedCrossProcessData cache = agent.IAgent_getComponentTracer().getCrossProcessDataCache();
        if (cache != null && (corid = cache.getCorrelationID()) != null) {
            String calledByNodeId = cache.getIncomingCalledByNodeId();
            String calledByNodeType = cache.getIncomingCalledByNodeType();
            parameters.put("CallerName", calledByNodeId);
            parameters.put("CallerNodeType", calledByNodeType);
        }
    }

    public void addMapComponent(IStackType type, String component, HashMap params) {
        String currentOutgoingNode = (String)params.remove(KIntroscopeExtensionConstants.kOutgoingNode);
        if (type == BoundaryOnlyBlameStack.getStackType()) {
            this.handleAdd(component, (IComponentParameterCallback)new PreformedCallback(params), currentOutgoingNode);
        }
    }

    public static final IStackType getStackType() {
        return kStackType;
    }

    public boolean hasFrontBoundary() {
        return false;
    }

    public String toString() {
        String head = null;
        String tail = null;
        TransactionStackElement headEle = this.fComponentStack.getHead();
        TransactionStackElement tailEle = this.fComponentStack.getTail();
        if (headEle != null) {
            head = headEle.getComponent();
        }
        if (tailEle != null) {
            tail = tailEle.getComponent();
        }
        return "[DependencyMapStack: head=" + head + ", tail=" + tail + "]";
    }

    public void popMapComponent(IStackType stackType, String component) {
    }

    public static class DependencyArrayMaxSizeProperty
    extends IntegerConfigurationProperty {
        private DependencyArrayMaxSizeProperty(IAgent agent, IModuleFeedbackChannel feedback) {
            super(BoundaryOnlyBlameStack.kDependencyArrayMaxSizeProperty, Integer.valueOf(1000), feedback, null, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sDependencyArrayMaxSize = (Integer)newValue;
        }
    }

    private static class StackLinkedList {
        private TransactionStackElement head;
        private TransactionStackElement tail;
        private int size;

        StackLinkedList() {
            this.init();
        }

        private void init() {
            this.tail = null;
            this.head = null;
            this.size = 0;
        }

        void clear() {
            this.init();
        }

        void add(TransactionStackElement e) {
            Assertion.wilyAssert((this.head == null && this.tail == null && this.size == 0 || this.head != null && this.tail != null && this.size > 0 ? 1 : 0) != 0);
            if (this.tail == null) {
                this.head = this.tail = e;
            } else {
                e.addAfter(this.tail);
            }
            this.tail = e;
            ++this.size;
        }

        TransactionStackElement getHead() {
            return this.head;
        }

        TransactionStackElement getTail() {
            Assertion.wilyAssert((this.head == null && this.tail == null && this.size == 0 || this.head != null && this.tail != null && this.size > 0 ? 1 : 0) != 0);
            return this.tail;
        }

        public int getSize() {
            return this.size;
        }

        TransactionStackElement removeLast() {
            Assertion.wilyAssert((this.head == null && this.tail == null && this.size == 0 || this.head != null && this.tail != null && this.size > 0 ? 1 : 0) != 0);
            TransactionStackElement result = this.tail;
            if (result != null) {
                this.tail = result.fPrevious;
                if (this.tail != null) {
                    this.tail.fNext = null;
                } else {
                    this.head = null;
                }
                --this.size;
            }
            return result;
        }

        boolean isEmpty() {
            Assertion.wilyAssert((this.head == null && this.tail == null && this.size == 0 || this.head != null && this.tail != null && this.size > 0 ? 1 : 0) != 0);
            return this.size == 0;
        }

        int size() {
            Assertion.wilyAssert((this.head == null && this.tail == null && this.size == 0 || this.head != null && this.tail != null && this.size > 0 ? 1 : 0) != 0);
            return this.size;
        }
    }

    protected static class TransactionStackElement {
        private final BoundaryOnlyBlameStack fParent;
        final String fComponent;
        private List fSubElements;
        public IComponentParameterCallback fCallback;
        public ParameterGatheringCallback fParamCallback;
        HashMap fParams;
        TransactionStackElement fPrevious;
        TransactionStackElement fNext;

        public TransactionStackElement(BoundaryOnlyBlameStack parent, String component, IComponentParameterCallback callback) {
            this.fParent = parent;
            this.fComponent = component;
            this.fCallback = callback;
            this.fParamCallback = null;
            this.fSubElements = null;
            this.fNext = null;
            this.fPrevious = null;
        }

        public void setParameters(HashMap parameters) {
            this.fParams = parameters;
        }

        public HashMap getParameters() {
            if (this.fParams == null) {
                this.fParams = new HashMap();
            }
            return this.fParams;
        }

        public String getComponent() {
            return this.fComponent;
        }

        public void addSubElement(BoundaryOnlyTransactionData elementData) {
            if (this.fSubElements == null) {
                this.fSubElements = new ArrayList();
            }
            this.fSubElements.add(elementData);
        }

        void addAfter(TransactionStackElement oldTail) {
            oldTail.fNext = this;
            this.fPrevious = oldTail;
            this.fNext = null;
        }

        TransactionStackElement getPrevious() {
            return this.fPrevious;
        }

        public BoundaryOnlyTransactionData markDependency(boolean resetSubElements) {
            BoundaryOnlyTransactionData[] subElements = null;
            if (this.fSubElements != null) {
                subElements = new BoundaryOnlyTransactionData[this.fSubElements.size()];
                subElements = this.fSubElements.toArray(subElements);
            }
            if (resetSubElements) {
                this.fSubElements = null;
            }
            HashMap parameters = new HashMap(3);
            this.fParent.addCallbackParameters(this.fCallback, parameters);
            return new BoundaryOnlyTransactionData(this.fComponent, parameters, subElements);
        }

        public BoundaryOnlyTransactionData finish(boolean shouldIncludeOneTimeParams) {
            BoundaryOnlyTransactionData[] subElements = null;
            if (this.fSubElements != null) {
                subElements = new BoundaryOnlyTransactionData[this.fSubElements.size()];
                subElements = this.fSubElements.toArray(subElements);
            }
            HashMap parameters = new HashMap(3);
            this.fParent.addCallbackParameters(this.fCallback, parameters);
            return new BoundaryOnlyTransactionData(this.fComponent, parameters, subElements);
        }

        public void addCallbackParams(String paramName, String paramValue) {
            if (this.fParamCallback == null) {
                this.fParamCallback = new ParameterGatheringCallback();
                this.fCallback = new CompoundComponentParameterCallback(this.fCallback, (IComponentParameterCallback)this.fParamCallback);
            }
            this.fParamCallback.addParameter(paramName, paramValue);
        }
    }
}

