/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.util.AgentResourceClassLoader;
import com.wily.isengard.IsengardException;
import com.wily.isengard.api.IIsengardClient;
import com.wily.isengard.api.IsengardClient;
import com.wily.isengard.api.ServerInstanceLocator;
import com.wily.isengard.api.TransportConfiguration;
import com.wily.isengard.container.BeanActivationException;
import com.wily.isengard.container.BeanContainerCore;
import com.wily.isengard.container.beans.IsengardBeanDescriptor;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.thread.IThreadFactory;
import java.io.IOException;

public class IsengardClientConnection {
    private final IModuleFeedbackChannel fFeedback;
    private final IsengardClient fIsengardClient;
    private final IIsengardClient fConnectionListener;
    private final String fClientTransportString;

    public IsengardClientConnection(TransportConfiguration transportConfig, ServerInstanceLocator serverLocator, String credential, IThreadFactory threadFactory, IModuleFeedbackChannel feedback, IIsengardClient connectionListener) throws IOException, IsengardException {
        this.fFeedback = feedback;
        this.fConnectionListener = connectionListener;
        this.fIsengardClient = this.createClient(transportConfig, serverLocator, threadFactory, credential);
        this.fClientTransportString = String.valueOf(serverLocator.getHostName()) + ":" + serverLocator.getPort();
    }

    public void connect() throws IOException {
        this.fIsengardClient.setCacheRegistry(false);
        this.fIsengardClient.connect();
    }

    public PostOffice getPostOffice() {
        return this.fIsengardClient.getMainPO();
    }

    public void tearDownConnection() {
        this.fIsengardClient.close();
    }

    public String getClientTransportString() {
        return this.fClientTransportString;
    }

    public void addBean(Class beanClass, Object param) throws BeanActivationException {
        IsengardBeanDescriptor des = IsengardBeanDescriptor.getInitialBeanDescriptor("controller", beanClass);
        des.setInstanceData(param);
        IsengardClient client = this.fIsengardClient;
        BeanContainerCore core = client.getBeanContainer();
        core.addBean(des);
    }

    private IsengardClient createClient(TransportConfiguration transportConfig, ServerInstanceLocator serverLocator, IThreadFactory threadFactory, String credential) throws IsengardException {
        if (credential == null || credential.length() == 0) {
            credential = "WilyAgent1234";
        }
        return new IsengardClient(this.getFeedbackChannel(), "Agent", credential, transportConfig, serverLocator, this.fConnectionListener, AgentResourceClassLoader.getInstance(), threadFactory);
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    public boolean isConnected() {
        return this.fIsengardClient != null && this.fIsengardClient.isConnected();
    }
}

