/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizdef.patternDef;

import com.wily.apm.spec.tess.beans.bizdefinition.TransactionComponent;
import com.wily.introscope.agent.bizdef.IBizParameterSet;
import com.wily.introscope.agent.bizdef.IBizRulePattern;
import com.wily.introscope.agent.bizdef.constants.KBizConstants;
import com.wily.introscope.agent.bizdef.parameters.BizParameterSet;
import com.wily.introscope.agent.bizdef.patternDef.BizHttpRulePattern;
import com.wily.introscope.agent.bizdef.types.BizDefType;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.UnsupportedEncodingException;

public final class BizRulePatternSet {
    private IBizRulePattern[] patternArray;
    private boolean fContainsPostParams;
    private int length;
    private long fBizId;
    private String fString;
    private transient int fHashcode;
    private String fBTName;
    private boolean fIdentifying;

    public BizRulePatternSet(TransactionComponent transactionComponent) {
        this.initialize(transactionComponent);
    }

    private void initialize(TransactionComponent trxComponent) {
        this.fBizId = trxComponent.getId();
        this.patternArray = new IBizRulePattern[0];
        this.fContainsPostParams = false;
        this.fString = this.privateToString();
        this.length = this.fString.length();
        this.fHashcode = this.fString.hashCode();
        this.fBTName = trxComponent.getBusinessTransactionName();
        this.fIdentifying = trxComponent.getIsIdentifying();
    }

    public String getBusinessTxnName() {
        return this.fBTName;
    }

    public boolean isIdentifying() {
        return this.fIdentifying;
    }

    public void addPatternAtStart(IBizRulePattern bizRulePattern) {
        int patternSize = this.patternArray.length;
        IBizRulePattern[] patternList = new IBizRulePattern[patternSize + 1];
        System.arraycopy(this.patternArray, 0, patternList, 1, patternSize);
        patternList[0] = bizRulePattern;
        this.patternArray = patternList;
        if (bizRulePattern.getType().equals("POST")) {
            this.fContainsPostParams = true;
        }
        this.fString = this.privateToString();
        this.length = this.fString.length();
        this.fHashcode = this.fString.hashCode();
    }

    public void addPatternAtEnd(IBizRulePattern bizRulePattern) {
        int patternSize = this.patternArray.length;
        IBizRulePattern[] patternList = new IBizRulePattern[patternSize + 1];
        System.arraycopy(this.patternArray, 0, patternList, 0, this.patternArray.length);
        patternList[patternList.length - 1] = bizRulePattern;
        this.patternArray = patternList;
        if (bizRulePattern.getType().equals("POST")) {
            this.fContainsPostParams = true;
        }
        this.fString = this.privateToString();
        this.length = this.fString.length();
        this.fHashcode = this.fString.hashCode();
    }

    public int indexOf(Object o) {
        if (o == null) {
            int i = 0;
            while (i < this.length) {
                if (this.patternArray[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.length) {
                if (o.equals(this.patternArray[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean contains(BizParameterSet bizParameterSet) {
        return this.indexOf(bizParameterSet) >= 0;
    }

    public boolean matches(IBizParameterSet bizParameterSet, IModuleFeedbackChannel feedback, int postFlag, boolean isVerboseEnabled) throws UnsupportedEncodingException {
        if (this.fContainsPostParams && postFlag == 1) {
            if (isVerboseEnabled) {
                feedback.verbose(KBizConstants.kBizDefModule, "Business Pattern Rule Set Contains Post Parameter that needs to be excluded from matching.");
            }
            return false;
        }
        int index = 0;
        boolean continueChecking = true;
        while (index < this.patternArray.length) {
            IBizRulePattern rulePattern;
            if ((rulePattern = this.patternArray[index++]).getType() == BizDefType.kBizHttpPostParamType && postFlag == 2) {
                if (!isVerboseEnabled) continue;
                feedback.verbose(KBizConstants.kBizDefModule, "Business Pattern Rule Set Contains Post Parameter that needs to be matched later.");
                continue;
            }
            if (isVerboseEnabled) {
                feedback.verbose(KBizConstants.kBizDefModule, "Business Pattern Rule Set Contains the Following Parameters: " + rulePattern.toString());
            }
            if (((BizHttpRulePattern)rulePattern).matches(bizParameterSet)) continue;
            if (isVerboseEnabled) {
                feedback.verbose(KBizConstants.kBizDefModule, "Business Parameter Set did not find a match");
            }
            continueChecking = false;
            break;
        }
        return index != 0 && continueChecking;
    }

    public boolean containsPostParameters() {
        return this.fContainsPostParams;
    }

    public int getLength() {
        return this.length;
    }

    public int numOfParams() {
        return this.patternArray.length;
    }

    public int hashCode() {
        return this.fHashcode;
    }

    public String toString() {
        return this.fString;
    }

    private String privateToString() {
        int patternSize = this.patternArray.length;
        StringBuilder buffer = new StringBuilder(patternSize * 256);
        buffer.append("[").append(this.fBizId).append("]");
        int i = 0;
        while (i < patternSize) {
            IBizRulePattern pattern = this.patternArray[i];
            buffer.append(pattern.toString());
            buffer.append(" ");
            ++i;
        }
        return buffer.toString();
    }

    public boolean equals(Object arg0) {
        if (arg0 != null) {
            return this.fString.equals(arg0.toString());
        }
        return false;
    }
}

