/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.classmatcher.DGDeepInheritedClassMatcher;
import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.IExportDirectiveCallback;
import com.wily.diagnos.cmp.directives.IExportableDirective;
import com.wily.diagnos.cmp.directives.TracerName;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.methodmatcher.NamedMethodMatcher;
import com.wily.diagnos.cmp.tracer.builder.DynamicMethodTracerBuilder;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;

public final class TraceOneMethodIfInheritsLabeledDirective
extends ADirective
implements IExportableDirective {
    private final IClassName fSuperClassOrInterfaceName;
    private final IMethodName fMethodName;
    private final TracerName fTracerName;
    private final FlagName fTracerFlag;
    private final String fNameParameter;
    private final String fLabel;

    public TraceOneMethodIfInheritsLabeledDirective(String source, int lineNumber, IClassName className, IMethodName methodName, TracerName tracerName, String nameParameter, String label, FlagName tracerGroup) {
        super(source, lineNumber);
        this.fSuperClassOrInterfaceName = className;
        this.fMethodName = methodName;
        this.fTracerName = tracerName;
        this.fNameParameter = nameParameter;
        this.fLabel = label;
        this.fTracerFlag = tracerGroup;
    }

    private IClassName getClassName() {
        return this.fSuperClassOrInterfaceName;
    }

    private IMethodName getMethodName() {
        return this.fMethodName;
    }

    private TracerName getTracerName() {
        return this.fTracerName;
    }

    private String getNameParameter() {
        return this.fNameParameter;
    }

    private String getLabel() {
        return this.fLabel;
    }

    @Override
    protected void applyToSettings(CompilerSettingsBuilder builder) {
        TracerGroupBuilder flag = null;
        if (this.fTracerFlag != null) {
            flag = builder.getTracerGroupBuilder(this.fTracerFlag);
            flag.setDeclared(true);
            flag.setEnabled(true);
            flag.setSource(this.getSource());
        }
        builder.addTracer(new DynamicMethodTracerBuilder(this.IDirective_getSource(), this.IDirective_getLineNumber(), DGDeepInheritedClassMatcher.getInstance(this.getClassName()), NamedMethodMatcher.getInstance(this.getMethodName()), this.getTracerName(), this.getNameParameter(), flag, this.getLabel(), false, true, this.fSuperClassOrInterfaceName));
    }

    @Override
    public void IExportableDirective_export(IExportDirectiveCallback callback) {
        callback.export(this.getSource(), this.fTracerFlag, this.getClassName(), this.getMethodName(), this.getTracerName(), this.getNameParameter(), this.getLabel(), true, null, null);
    }
}

