/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agentmgr.agent;

import com.ca.apm.agentmgr.common.AgentMgrPropertyListener;
import com.ca.apm.agentmgr.common.IAgentPropertyService;
import com.ca.apm.agentmgr.core.result.PropertyAgentMgrResult;
import com.wily.introscope.agent.IAgent;
import com.wily.isengard.container.beans.AIsengardBean;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.util.INameChangeListener;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.properties.hot.PositiveLongConfigurationProperty;
import com.wily.util.properties.lockable.ILockableProfileWriter;
import com.wily.util.properties.lockable.IPropertyChangeEventNotifier;
import com.wily.util.properties.lockable.LockableFileManager;
import com.wily.util.properties.lockable.ProfileWriter;
import java.util.HashMap;
import java.util.Map;

public class AgentPropertyServiceBean
extends AIsengardBean
implements IAgentPropertyService {
    private IAgent fAgent;
    private IModuleFeedbackChannel fFeedback;
    private String fAgentHost;
    private String fAgentProcess;
    private String fQualifiedAgentName;
    private AgentMgrPropertyListener fPropertyChangeListener;
    private ILockableProfileWriter fProfileWriter = null;
    private final Module kModule = new Module("Agent Manger Property Service");

    public void activate() throws Exception {
        this.fAgent = (IAgent)this.getBeanDescriptor().getInstanceData();
        this.fFeedback = this.getFeedbackChannel();
        this.fFeedback.info("Activated Agent Propertty Service bean.");
        String[] hostProcessAgent = this.fAgent.IAgent_getHostProcessAgentTriplet();
        this.fAgentHost = hostProcessAgent[0];
        this.fAgentProcess = hostProcessAgent[1];
        String name = hostProcessAgent[2];
        this.registerBean(this.fAgentHost, this.fAgentProcess, name);
        this.fPropertyChangeListener = new AgentMgrPropertyListener(this.getFeedbackChannel(), this.kModule, this.getPostOffice());
        this.fAgent.IAgent_addNegotiatedNameChangeListener(this.createChangeListener());
    }

    public void passivate() {
        if (this.fPropertyChangeListener != null) {
            this.fPropertyChangeListener.teardownListener();
        }
        if (this.fProfileWriter != null) {
            this.fProfileWriter.shutdown();
        }
    }

    protected Class getServiceClass() {
        return IAgentPropertyService.class;
    }

    private INameChangeListener createChangeListener() {
        return new INameChangeListener(){

            public void INameChangeListener_nameChanged(String newName) {
                try {
                    if (AgentPropertyServiceBean.this.fQualifiedAgentName != null) {
                        AgentPropertyServiceBean.this.destroyMessageService(IAgentPropertyService.class, AgentPropertyServiceBean.this.fQualifiedAgentName);
                    }
                    AgentPropertyServiceBean.this.registerBean(AgentPropertyServiceBean.this.fAgentHost, AgentPropertyServiceBean.this.fAgentProcess, newName);
                }
                catch (Exception exception) {
                    AgentPropertyServiceBean.this.fAgent.IAgent_getModuleFeedback().error("Failed to re-register IAgentPropertyService on Agent name change event.");
                    AgentPropertyServiceBean.this.fQualifiedAgentName = null;
                }
            }
        };
    }

    private void registerBean(String host, String process, String name) throws Exception {
        this.fQualifiedAgentName = String.valueOf(host) + "|" + process + "|" + name;
        this.getPostOffice().getPostOfficeHub().registerClassLoader(IAgentPropertyService.class.getClassLoader(), "AgentPropertyService");
        this.createMessageService2(IAgentPropertyService.class, this.fQualifiedAgentName, new String[]{"Workstation", "Server"});
        this.getFeedbackChannel().info("Registering IIAgentPropertyService for new agent name : " + this.fQualifiedAgentName);
    }

    public Map getProperties() throws ConnectionException {
        this.fFeedback.debug("Got a request to get Agent properties");
        return this.fAgent.IAgent_getIndexedProperties();
    }

    public String getProperty(String property) throws ConnectionException {
        this.fFeedback.debug("Got a request to get Agent property [" + property + "]");
        ConfigurationManager configMgr = this.fAgent.IAgent_getConfigurationManager();
        return configMgr.getProperty(property);
    }

    public PropertyAgentMgrResult changeProperty(String propertyName, String newPropertyValue) throws ConnectionException {
        this.fFeedback.debug("Got a request to change Agent property: " + propertyName);
        if (this.fProfileWriter != null) {
            HashMap<String, String> changedProperties = new HashMap<String, String>();
            changedProperties.put(propertyName, newPropertyValue);
            this.fProfileWriter.profileChanged(changedProperties);
        }
        return null;
    }

    public void setProfileWriter(ILockableProfileWriter profileWriter) {
        this.fProfileWriter = profileWriter;
    }

    private void initializeProfileLockManager(LockableFileManager manager, IPropertyChangeEventNotifier notifier) {
        PositiveLongConfigurationProperty prop = new PositiveLongConfigurationProperty("introscope.agent.profile.lock.retry.interval", 100L, "Interval between locking attempts for profile", this.fFeedback, this.kModule, this.fAgent.IAgent_getStringLocalizer()){};
        this.fAgent.IAgent_getConfigurationManager().add((ConfigurationProperty)prop, true);
        manager.setLockRetryIntervalProperty(prop);
        PositiveIntegerConfigurationProperty nprop = new PositiveIntegerConfigurationProperty("introscope.agent.profile.number.lock.retries", 100, "Maximum number of lock retry attempts for profile", this.fFeedback, this.kModule, this.fAgent.IAgent_getStringLocalizer()){};
        this.fAgent.IAgent_getConfigurationManager().add((ConfigurationProperty)nprop, true);
        manager.setNumberLockRetriesProperty(nprop);
        ProfileWriter profileWriter = new ProfileWriter(manager, notifier);
        Thread profileWriteSpooler = this.fAgent.IAgent_getAgentThreadFactory().IThreadFactory_createNewThread("ProfileWriterSpooler", (Runnable)profileWriter);
        profileWriteSpooler.start();
        this.fProfileWriter = profileWriter;
    }
}

